/*
 * Decompiled with CFR 0.152.
 */
package de.mrjulsen.trafficcraft.data;

import com.mojang.blaze3d.platform.NativeImage;
import de.mrjulsen.mcdragonlib.data.Pair;
import de.mrjulsen.mcdragonlib.util.DLUtils;
import de.mrjulsen.mcdragonlib.util.accessor.DataAccessor;
import de.mrjulsen.trafficcraft.TrafficCraft;
import de.mrjulsen.trafficcraft.block.data.TrafficSignShape;
import de.mrjulsen.trafficcraft.data.NamedTrafficSignTextureReference;
import de.mrjulsen.trafficcraft.data.TrafficSignTextureData;
import de.mrjulsen.trafficcraft.registry.ModAccessorTypes;
import dev.architectury.utils.GameInstance;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.texture.AbstractTexture;
import net.minecraft.client.renderer.texture.DynamicTexture;
import net.minecraft.client.renderer.texture.MissingTextureAtlasSprite;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.Resource;

public class TrafficSignClientTexture
implements AutoCloseable {
    public static final DynamicTexture EMPTY_TEXTURE;
    public static final TrafficSignClientTexture EMPTY;
    public static final ResourceLocation EMPTY_LOCATION;
    public static final Map<String, Pair.MutablePair<TrafficSignClientTexture, Integer>> cachedTexturesById;
    protected TrafficSignTextureData rawData = TrafficSignTextureData.empty();
    protected DynamicTexture texture = EMPTY_TEXTURE;
    protected DynamicTexture backgroundTexture = EMPTY_TEXTURE;
    protected ResourceLocation textureLocation = EMPTY_LOCATION;
    protected ResourceLocation backgroundTextureLocation = EMPTY_LOCATION;
    protected final String textureId;
    private boolean isClosed = false;
    private boolean builtIn = false;

    public static int debug_cachedTexturesCount() {
        return cachedTexturesById.size();
    }

    public static int closeAll() {
        int count = cachedTexturesById.size();
        new ArrayList<Pair.MutablePair<TrafficSignClientTexture, Integer>>(cachedTexturesById.values()).stream().map(x -> (TrafficSignClientTexture)x.getFirst()).forEach(x -> x.close());
        cachedTexturesById.clear();
        return count;
    }

    protected TrafficSignClientTexture(String textureId) {
        this.textureId = textureId;
    }

    private synchronized TrafficSignClientTexture init(TrafficSignTextureData rawData, boolean createBg) {
        if (this.isClosed) {
            return this;
        }
        this.rawData = rawData;
        DynamicTexture tex = EMPTY_TEXTURE;
        if (rawData.getPixelData().length > 0) {
            try {
                tex = new DynamicTexture(NativeImage.read((InputStream)new ByteArrayInputStream(rawData.getPixelData())));
            }
            catch (IOException e) {
                TrafficCraft.LOGGER.error("Unable to load texture.", (Throwable)e);
                tex = MissingTextureAtlasSprite.getTexture();
            }
        }
        this.texture = tex;
        this.textureLocation = ResourceLocation.fromNamespaceAndPath((String)"trafficcraft", (String)("sign_" + rawData.getHash().toString()));
        if (createBg && rawData.getShape() == TrafficSignShape.MISC) {
            this.generateBgTexture();
        }
        Minecraft.getInstance().getTextureManager().register(this.textureLocation, (AbstractTexture)tex);
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void generateBgTexture() {
        DynamicTexture originalTexture = EMPTY_TEXTURE;
        try {
            Object idSuffix = "_";
            if (this.isBuiltIn()) {
                NamedTrafficSignTextureReference.BuildInTrafficSignCodec codec = NamedTrafficSignTextureReference.BuildInTrafficSignCodec.decode(this.textureId);
                idSuffix = codec.id() + "_bg";
                originalTexture = new DynamicTexture(NativeImage.read((InputStream)((Resource)Minecraft.getInstance().getResourceManager().getResource(this.getTextureLocation()).get()).open()));
            } else {
                idSuffix = "_bg";
                originalTexture = this.texture;
            }
            if (originalTexture == null || originalTexture == EMPTY_TEXTURE) {
                return;
            }
            NativeImage bg = NativeImage.read((InputStream)((Resource)Minecraft.getInstance().getResourceManager().getResource(ResourceLocation.fromNamespaceAndPath((String)"trafficcraft", (String)"textures/block/sign/blank.png")).get()).open());
            int width = Math.min(bg.getWidth(), 32);
            int height = Math.min(bg.getHeight(), 32);
            for (int x = 0; x < width; ++x) {
                for (int y = 0; y < height; ++y) {
                    if (originalTexture.getPixels().getPixelRGBA(x, y) != 0) continue;
                    bg.setPixelRGBA(width - 1 - x, y, 0);
                }
            }
            this.backgroundTexture = new DynamicTexture(bg);
            this.backgroundTextureLocation = ResourceLocation.fromNamespaceAndPath((String)"trafficcraft", (String)("sign_" + String.valueOf(this.isBuiltIn() ? Integer.valueOf(this.rawData.getShape().getIndex()) : this.rawData.getHash().toString()) + (String)idSuffix));
            Minecraft.getInstance().getTextureManager().register(this.backgroundTextureLocation, (AbstractTexture)this.backgroundTexture);
        }
        catch (Exception e) {
            TrafficCraft.LOGGER.error("Unable to create traffic sign background texture.", (Throwable)e);
        }
        finally {
            if (this.isBuiltIn() && originalTexture != null && originalTexture != EMPTY_TEXTURE) {
                originalTexture.close();
            }
        }
    }

    public static TrafficSignTextureData createNew(TrafficSignShape shape, NativeImage image, Runnable andThen) {
        TrafficSignTextureData data;
        try {
            data = new TrafficSignTextureData(shape, image.asByteArray(), (short)image.getWidth(), (short)image.getHeight(), System.currentTimeMillis(), GameInstance.getClient().player.getUUID());
            DataAccessor.getFromServer((Object)data, ModAccessorTypes.CREATE_NEW_TRAFFIC_SIGN_TEXTURE, $ -> DLUtils.doIfNotNull((Object)andThen, x -> x.run()));
        }
        catch (IOException e) {
            TrafficCraft.LOGGER.error("Unable to create new traffic sign texture.", (Throwable)e);
            data = TrafficSignTextureData.empty();
        }
        return data;
    }

    public static TrafficSignClientTexture load(String id, boolean allowBackground) {
        Pair.MutablePair data = cachedTexturesById.computeIfAbsent(id, x -> {
            TrafficSignClientTexture textureData = new TrafficSignClientTexture(id);
            if (id.startsWith("builtIn")) {
                try {
                    NamedTrafficSignTextureReference.BuildInTrafficSignCodec codec = NamedTrafficSignTextureReference.BuildInTrafficSignCodec.decode(id);
                    textureData.builtIn = true;
                    textureData.texture = EMPTY_TEXTURE;
                    textureData.textureLocation = ResourceLocation.fromNamespaceAndPath((String)"trafficcraft", (String)String.format("textures/block/sign/%s/%s%s.png", codec.shape().getSerializedName(), codec.shape().getSerializedName(), codec.id()));
                    textureData.rawData = new TrafficSignTextureData(codec.shape(), new byte[0], codec.width(), codec.height(), System.currentTimeMillis(), new UUID(0L, 0L));
                }
                catch (Exception e) {
                    TrafficCraft.LOGGER.error("Error while loading TrafficSignClientTexture.", (Throwable)e);
                }
            } else {
                DataAccessor.getFromServer((Object)id, ModAccessorTypes.GET_TRAFFIC_SIGN_TEXTURE, a -> textureData.init((TrafficSignTextureData)a, allowBackground));
            }
            return new Pair.MutablePair((Object)textureData, (Object)0);
        });
        data.setSecond((Object)((Integer)data.getSecond() + 1));
        if (allowBackground && ((TrafficSignClientTexture)data.getFirst()).getRawData().getShape() == TrafficSignShape.MISC && ((TrafficSignClientTexture)data.getFirst()).isFullyLoaded()) {
            ((TrafficSignClientTexture)data.getFirst()).generateBgTexture();
        }
        return (TrafficSignClientTexture)data.getFirst();
    }

    public static void unload(UUID id) {
        TrafficSignClientTexture.unload(id.toString());
    }

    protected static void unload(String id) {
        if (!cachedTexturesById.containsKey(id)) {
            TrafficCraft.LOGGER.warn("There was no cached traffic sign texture with id " + id + ".");
            return;
        }
        Pair.MutablePair<TrafficSignClientTexture, Integer> data = cachedTexturesById.get(id);
        data.setSecond((Object)((Integer)data.getSecond() - 1));
        if ((Integer)data.getSecond() <= 0) {
            ((TrafficSignClientTexture)cachedTexturesById.remove(id).getFirst()).closeInternal();
        }
    }

    public TrafficSignTextureData getRawData() {
        return this.rawData;
    }

    public DynamicTexture getTexture() {
        if (this.builtIn) {
            throw new IllegalAccessError("Cannot access built-in textures as DynamicTexture.");
        }
        return this.texture;
    }

    public ResourceLocation getTextureLocation() {
        return this.textureLocation;
    }

    public DynamicTexture getBackgroundTexture() {
        if (this.builtIn) {
            throw new IllegalAccessError("Cannot access built-in textures as DynamicTexture.");
        }
        return this.backgroundTexture;
    }

    public ResourceLocation getBackgroundTextureLocation() {
        return this.backgroundTextureLocation;
    }

    public boolean isFullyLoaded() {
        return !this.equals(EMPTY);
    }

    public boolean isDisposed() {
        return this.isClosed;
    }

    public boolean isBuiltIn() {
        return this.builtIn;
    }

    public boolean hasBackground() {
        return this.backgroundTexture != null && this.backgroundTexture != EMPTY_TEXTURE;
    }

    public boolean equals(Object obj) {
        if (obj instanceof TrafficSignClientTexture) {
            TrafficSignClientTexture o = (TrafficSignClientTexture)obj;
            return this.textureLocation.equals((Object)o.textureLocation);
        }
        return super.equals(obj);
    }

    @Override
    public void close() {
        TrafficSignClientTexture.unload(this.textureId);
    }

    private void closeInternal() {
        this.isClosed = true;
        if (this != EMPTY && !this.equals(EMPTY) && !this.isBuiltIn()) {
            DLUtils.doIfNotNull((Object)this.texture, x -> x.close());
            Minecraft.getInstance().getTextureManager().release(this.textureLocation);
            if (this.backgroundTexture != null && this.backgroundTexture != EMPTY_TEXTURE) {
                this.backgroundTexture.close();
                Minecraft.getInstance().getTextureManager().release(this.backgroundTextureLocation);
            }
        }
    }

    static {
        NativeImage img = new NativeImage(1, 1, false);
        img.setPixelRGBA(0, 0, 0);
        EMPTY_TEXTURE = new DynamicTexture(img);
        EMPTY_LOCATION = ResourceLocation.fromNamespaceAndPath((String)"trafficcraft", (String)"empty_sign");
        Minecraft.getInstance().getTextureManager().register(EMPTY_LOCATION, (AbstractTexture)EMPTY_TEXTURE);
        EMPTY = new TrafficSignClientTexture("empty");
        cachedTexturesById = new HashMap<String, Pair.MutablePair<TrafficSignClientTexture, Integer>>();
    }
}

