/*
 * Decompiled with CFR 0.152.
 */
package de.mrjulsen.trafficcraft.client.tooltip;

import de.mrjulsen.mcdragonlib.util.DLUtils;
import de.mrjulsen.trafficcraft.data.AgingManager;
import de.mrjulsen.trafficcraft.data.IAgeable;
import de.mrjulsen.trafficcraft.data.NamedTrafficSignTextureReference;
import de.mrjulsen.trafficcraft.data.TrafficSignClientTexture;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.core.NonNullList;
import net.minecraft.world.inventory.tooltip.TooltipComponent;

public class TrafficSignTooltip
implements TooltipComponent,
IAgeable {
    private final NamedTrafficSignTextureReference selected;
    private final NonNullList<NamedTrafficSignTextureReference> patterns;
    private final Runnable onClear;
    private final Map<NamedTrafficSignTextureReference, TrafficSignClientTexture> textures = new HashMap<NamedTrafficSignTextureReference, TrafficSignClientTexture>();
    private final int selectedIndex;

    public TrafficSignTooltip(NonNullList<NamedTrafficSignTextureReference> patterns, NamedTrafficSignTextureReference selected, int selectedIndex, Runnable onClear) {
        this.patterns = patterns;
        this.selected = selected;
        this.selectedIndex = selectedIndex;
        this.onClear = onClear;
        this.textures.clear();
        patterns.stream().forEach(x -> this.textures.put((NamedTrafficSignTextureReference)x, TrafficSignClientTexture.load(x.getTextureId(), false)));
        DLUtils.doIfNotNull((Object)selected, a -> this.textures.computeIfAbsent((NamedTrafficSignTextureReference)a, x -> TrafficSignClientTexture.load(x.getTextureId(), false)));
    }

    public NonNullList<NamedTrafficSignTextureReference> getPatterns() {
        return this.patterns;
    }

    public NamedTrafficSignTextureReference getSelected() {
        return this.selected;
    }

    public int getSelectedIndex() {
        return this.selectedIndex;
    }

    public Map<NamedTrafficSignTextureReference, TrafficSignClientTexture> getTextures() {
        return this.textures;
    }

    @Override
    public void onAging(int age) {
        if (age > 2) {
            AgingManager.remove(this);
            this.textures.values().stream().forEach(x -> x.close());
            this.textures.clear();
            this.onClear.run();
        }
    }

    @Override
    public IAgeable.AgingType getAgingType() {
        return IAgeable.AgingType.RENDER;
    }
}

