/*
 * Decompiled with CFR 0.152.
 */
package de.mrjulsen.trafficcraft.client.screen;

import de.mrjulsen.mcdragonlib.client.gui.DLScreen;
import de.mrjulsen.mcdragonlib.client.gui.widgets.DLAbstractImageButton;
import de.mrjulsen.mcdragonlib.client.gui.widgets.DLIconButton;
import de.mrjulsen.mcdragonlib.client.gui.widgets.DLVerticalScrollBar;
import de.mrjulsen.mcdragonlib.client.render.DynamicGuiRenderer;
import de.mrjulsen.mcdragonlib.client.render.Sprite;
import de.mrjulsen.mcdragonlib.client.util.Graphics;
import de.mrjulsen.mcdragonlib.client.util.GuiAreaDefinition;
import de.mrjulsen.mcdragonlib.client.util.GuiUtils;
import de.mrjulsen.mcdragonlib.client.util.WidgetsCollection;
import de.mrjulsen.mcdragonlib.core.EAlignment;
import de.mrjulsen.mcdragonlib.net.BaseNetworkPacket;
import de.mrjulsen.mcdragonlib.net.DLNetworkManager;
import de.mrjulsen.mcdragonlib.util.TextUtils;
import de.mrjulsen.trafficcraft.data.PaintColor;
import de.mrjulsen.trafficcraft.network.packets.cts.PaintBrushPacket;
import java.util.ArrayList;
import java.util.Objects;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;

public class PaintBrushScreen
extends DLScreen {
    public static final Component title = TextUtils.translate((String)"gui.trafficcraft.paint_brush.title");
    public static final Component titleOpenFileDialog = TextUtils.translate((String)"gui.trafficcraft.signpicker.openfiledialog");
    public static final Component btnDoneText = TextUtils.translate((String)"gui.trafficcraft.signpicker.load");
    public static final Component tooltipImport = TextUtils.translate((String)"gui.trafficcraft.signpicker.tooltip.import");
    private static final int WIDTH = 187;
    private static final int HEIGHT = 171;
    private static final int MAX_ENTRIES_IN_ROW = 9;
    private static final int MAX_ROWS = 6;
    private static final int ICON_BUTTON_WIDTH = 18;
    private static final int ICON_BUTTON_HEIGHT = 18;
    private int guiLeft;
    private int guiTop;
    private ResourceLocation preview;
    private double scroll;
    private final int paint;
    private final PaintColor color;
    private final int diffuseColor;
    private int patternId;
    private final WidgetsCollection groupPatterns = new WidgetsCollection();
    private DLVerticalScrollBar scrollbar;
    private boolean updateScrollableContent = true;
    private final ResourceLocation[] resources;
    private final int count;

    public PaintBrushScreen(int patternId, int paint, PaintColor color) {
        super(title);
        this.patternId = patternId;
        this.paint = paint;
        this.color = color;
        this.diffuseColor = color.getTextureColor();
        ResourceLocation path = ResourceLocation.fromNamespaceAndPath((String)"trafficcraft", (String)"textures/block/sign_blank.png");
        ArrayList<ResourceLocation> locs = new ArrayList<ResourceLocation>();
        for (int i = 1; i <= 324; ++i) {
            locs.add(path);
            path = ResourceLocation.fromNamespaceAndPath((String)"trafficcraft", (String)("textures/block/patterns/" + i + ".png"));
        }
        this.resources = (ResourceLocation[])locs.toArray(ResourceLocation[]::new);
        this.count = this.resources.length;
    }

    public void onClose() {
        DLNetworkManager.sendToServer((BaseNetworkPacket)new PaintBrushPacket(this.patternId));
        super.onClose();
    }

    public void init() {
        super.init();
        this.guiLeft = this.width / 2 - 93;
        this.guiTop = this.height / 2 - 97;
        this.groupPatterns.components.clear();
        for (int i = 0; i < this.count; ++i) {
            int j = i;
            Sprite sprite = new Sprite(this.resources[j], 32, 32, 0, 0, 32, 32, 16, 16);
            DLIconButton btnImport = (DLIconButton)new DLIconButton(DLAbstractImageButton.ButtonType.RADIO_BUTTON, DynamicGuiRenderer.AreaStyle.BROWN, sprite, this.groupPatterns, this.guiLeft + 9, this.guiTop + 36 + j * 18, 18, 18, (Component)TextUtils.empty(), button -> {
                this.preview = this.resources[j];
                this.patternId = j;
            }){

                public void renderMainLayer(Graphics graphics, int mouseX, int mouseY, float partialTicks) {
                    GuiUtils.setTint((int)PaintBrushScreen.this.diffuseColor);
                    super.renderMainLayer(graphics, mouseX, mouseY, partialTicks);
                    GuiUtils.resetTint();
                }
            }.withAlignment(EAlignment.CENTER);
            if (this.patternId == j) {
                btnImport.select();
                this.preview = this.resources[j];
            }
            this.addRenderableWidget((GuiEventListener)btnImport);
        }
        this.scrollbar = (DLVerticalScrollBar)this.addRenderableWidget((GuiEventListener)((DLVerticalScrollBar)((DLVerticalScrollBar)new DLVerticalScrollBar(this.guiLeft + 171, this.guiTop + 16, 8, 110, new GuiAreaDefinition(this.guiLeft + 7, this.guiTop + 16, 164, 110)).withOnValueChanged(v -> {
            this.scroll = v.getScrollValue();
            if (this.updateScrollableContent) {
                this.fillButtons((DLIconButton[])this.groupPatterns.components.toArray(DLIconButton[]::new), this.scroll, this.guiLeft + 8, this.guiTop + 17, this.scrollbar);
            }
            this.updateScrollableContent = true;
        })).setAutoScrollerSize(true)));
        this.fillButtons((DLIconButton[])this.groupPatterns.components.toArray(DLIconButton[]::new), this.scroll, this.guiLeft + 8, this.guiTop + 17, this.scrollbar);
    }

    public void renderMainLayer(Graphics graphics, int mouseX, int mouseY, float partialTicks) {
        this.renderScreenBackground(graphics);
        DynamicGuiRenderer.renderWindow((Graphics)graphics, (int)this.guiLeft, (int)this.guiTop, (int)187, (int)171);
        DynamicGuiRenderer.renderArea((Graphics)graphics, (int)(this.guiLeft + 7), (int)(this.guiTop + 16), (int)164, (int)110, (DynamicGuiRenderer.AreaStyle)DynamicGuiRenderer.AreaStyle.BROWN, (DynamicGuiRenderer.ButtonState)DynamicGuiRenderer.ButtonState.DISABLED);
        super.renderMainLayer(graphics, mouseX, mouseY, partialTicks);
        GuiUtils.drawString((Graphics)graphics, (Font)this.font, (int)(this.guiLeft + 93), (int)(this.guiTop + 6), (FormattedText)title, (int)-12566464, (EAlignment)EAlignment.CENTER, (boolean)false);
        if (this.preview != null) {
            GuiUtils.setTint((int)this.diffuseColor);
            GuiUtils.drawTexture((ResourceLocation)this.preview, (Graphics)graphics, (int)(this.guiLeft + 8), (int)(this.guiTop + 130), (int)32, (int)32, (int)0, (int)0, (int)32, (int)32, (int)32, (int)32);
            GuiUtils.resetTint();
        }
        MutableComponent textPattern = TextUtils.translate((String)"item.trafficcraft.paint_brush.tooltip.pattern", (Object[])new Object[]{this.patternId});
        MutableComponent textColor = TextUtils.translate((String)"item.trafficcraft.paint_brush.tooltip.color", (Object[])new Object[]{TextUtils.translate((String)this.color.getValueTranslationKey("trafficcraft")).getString()});
        MutableComponent textPaint = TextUtils.translate((String)"item.trafficcraft.paint_brush.tooltip.paint", (Object[])new Object[]{(int)(0.78125f * (float)this.paint)});
        GuiUtils.drawString((Graphics)graphics, (Font)this.font, (int)(this.guiLeft + 187 - 7), (int)(this.guiTop + 130), (FormattedText)textPattern, (int)-12566464, (EAlignment)EAlignment.RIGHT, (boolean)false);
        Objects.requireNonNull(this.font);
        GuiUtils.drawString((Graphics)graphics, (Font)this.font, (int)(this.guiLeft + 187 - 7), (int)(this.guiTop + 130 + 9), (FormattedText)textColor, (int)-12566464, (EAlignment)EAlignment.RIGHT, (boolean)false);
        Objects.requireNonNull(this.font);
        GuiUtils.drawString((Graphics)graphics, (Font)this.font, (int)(this.guiLeft + 187 - 7), (int)(this.guiTop + 130 + 9 * 2), (FormattedText)textPaint, (int)-12566464, (EAlignment)EAlignment.RIGHT, (boolean)false);
    }

    private void fillButtons(DLIconButton[] buttons, double scrollRow, int defX, int defY, DLVerticalScrollBar scrollbar) {
        if (buttons.length <= 0) {
            return;
        }
        int currentRow = -1;
        for (int i = 0; i < buttons.length; ++i) {
            if (i % 9 == 0) {
                ++currentRow;
            }
            buttons[i].set_x(defX + i % 9 * 18);
            buttons[i].set_y((int)((double)(defY + currentRow * 18) - scrollRow * 18.0));
            buttons[i].set_visible((double)currentRow >= scrollRow && (double)currentRow < scrollRow + 6.0);
        }
        if (scrollbar != null) {
            this.updateScrollableContent = false;
            ((DLVerticalScrollBar)scrollbar.setScreenSize(6)).setMaxScroll(currentRow + 1);
        }
    }
}

