/*
 * Decompiled with CFR 0.152.
 */
package de.mrjulsen.trafficcraft.client.ber;

import com.mojang.math.Axis;
import de.mrjulsen.mcdragonlib.client.ber.BERGraphics;
import de.mrjulsen.mcdragonlib.client.ber.RotatableBlockEntityRenderer;
import de.mrjulsen.mcdragonlib.client.util.BERUtils;
import de.mrjulsen.trafficcraft.block.TrafficSignBlock;
import de.mrjulsen.trafficcraft.block.data.TrafficSignShape;
import de.mrjulsen.trafficcraft.block.entity.TrafficSignBlockEntity;
import de.mrjulsen.trafficcraft.data.TrafficSignClientTexture;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;

public class TrafficSignBlockEntityRenderer
extends RotatableBlockEntityRenderer<TrafficSignBlockEntity> {
    public TrafficSignBlockEntityRenderer(BlockEntityRendererProvider.Context context) {
        super(context);
    }

    public void renderBlock(BERGraphics<TrafficSignBlockEntity> graphics, float pPartialTick) {
        if (graphics.blockEntity() == null || ((TrafficSignBlockEntity)graphics.blockEntity()).isRemoved()) {
            return;
        }
        BlockState blockstate = ((TrafficSignBlockEntity)graphics.blockEntity()).getBlockState();
        if (blockstate == null) {
            return;
        }
        TrafficSignClientTexture tex = ((TrafficSignBlockEntity)graphics.blockEntity()).getClientTexture();
        if (tex.isDisposed()) {
            return;
        }
        double p = 0.0625;
        double z = blockstate.getValue(TrafficSignBlock.SHAPE) == TrafficSignShape.MISC ? 1.0 * p : 1.5 * p;
        graphics.poseStack().pushPose();
        graphics.poseStack().scale(16.0f, 16.0f, 16.0f);
        graphics.poseStack().translate(0.5f, 0.5f, 0.5f);
        graphics.poseStack().translate(-0.5, -0.5, z + 0.002);
        BERUtils.renderTexture((ResourceLocation)tex.getTextureLocation(), graphics, (boolean)true, (float)0.0f, (float)0.0f, (float)0.0f, (float)1.0f, (float)1.0f, (float)0.0f, (float)0.0f, (float)1.0f, (float)1.0f, (Direction)((Direction)blockstate.getValue((Property)TrafficSignBlock.FACING)), (int)-1, (int)graphics.packedLight());
        graphics.poseStack().popPose();
        if (tex.hasBackground()) {
            z = 9.0 * p - 0.5;
            graphics.poseStack().pushPose();
            graphics.poseStack().scale(16.0f, 16.0f, 16.0f);
            graphics.poseStack().translate(0.5f, 0.5f, 0.5f);
            graphics.poseStack().mulPose(Axis.YP.rotationDegrees(180.0f));
            graphics.poseStack().translate(-0.5, -0.5, -(p * 2.0) + z - 0.002);
            BERUtils.renderTexture((ResourceLocation)tex.getBackgroundTextureLocation(), graphics, (boolean)true, (float)0.0f, (float)0.0f, (float)0.0f, (float)1.0f, (float)1.0f, (float)0.0f, (float)0.0f, (float)1.0f, (float)1.0f, (Direction)((Direction)blockstate.getValue((Property)TrafficSignBlock.FACING)).getOpposite(), (int)-1, (int)graphics.packedLight());
            graphics.poseStack().popPose();
        }
    }
}

