/*
 * Decompiled with CFR 0.152.
 */
package de.mrjulsen.trafficcraft.block.entity;

import de.mrjulsen.mcdragonlib.block.SyncedBlockEntity;
import de.mrjulsen.mcdragonlib.core.Location;
import de.mrjulsen.trafficcraft.block.TrafficLightBlock;
import de.mrjulsen.trafficcraft.block.data.TrafficLightColor;
import de.mrjulsen.trafficcraft.block.data.TrafficLightControlType;
import de.mrjulsen.trafficcraft.block.entity.TrafficLightBlockEntity;
import de.mrjulsen.trafficcraft.data.TrafficLightSchedule;
import de.mrjulsen.trafficcraft.data.TrafficLightScheduleEntryData;
import de.mrjulsen.trafficcraft.registry.ModBlockEntities;
import de.mrjulsen.trafficcraft.util.OrderedArrayList;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;

public class TrafficLightControllerBlockEntity
extends SyncedBlockEntity {
    private static final String NBT_TRAFFIC_LIGHT_LOCATIONS = "LinkedTrafficLights";
    private static final String NBT_TICKS = "ticks";
    private static final String NBT_TOTAL_TICKS = "totalTicks";
    private static final String NBT_POWERED = "powered";
    private static final String NBT_SCHEDULES = "schedules";
    private static final String NBT_RUNNING = "running";
    private List<TrafficLightSchedule> schedules = new ArrayList<TrafficLightSchedule>();
    private int ticks = 0;
    private long totalTicks = 0L;
    private boolean running = true;
    private boolean powered = false;
    private List<Location> trafficLightLocations = new ArrayList<Location>();

    protected TrafficLightControllerBlockEntity(BlockEntityType<?> type, BlockPos pos, BlockState state) {
        super(type, pos, state);
    }

    public TrafficLightControllerBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)ModBlockEntities.TRAFFIC_LIGHT_CONTROLLER_BLOCK_ENTITY.get(), pos, state);
    }

    protected void loadAdditional(CompoundTag tag, HolderLookup.Provider registries) {
        super.loadAdditional(tag, registries);
        this.ticks = tag.getInt(NBT_TICKS);
        this.running = tag.getBoolean(NBT_RUNNING);
        this.totalTicks = tag.getLong(NBT_TOTAL_TICKS);
        this.powered = tag.getBoolean(NBT_POWERED);
        ListTag listTag = tag.getList(NBT_SCHEDULES, 10);
        this.schedules.clear();
        for (int i = 0; i < listTag.size(); ++i) {
            TrafficLightSchedule data = new TrafficLightSchedule();
            data.fromNbt(listTag.getCompound(i));
            this.schedules.add(data);
        }
        ListTag trafficLightsList = tag.getList(NBT_TRAFFIC_LIGHT_LOCATIONS, 10);
        this.trafficLightLocations.clear();
        for (int i = 0; i < trafficLightsList.size(); ++i) {
            Location loc = Location.fromNbt((CompoundTag)trafficLightsList.getCompound(i));
            this.trafficLightLocations.add(loc);
        }
    }

    protected void saveAdditional(CompoundTag tag, HolderLookup.Provider registries) {
        super.saveAdditional(tag, registries);
        ListTag listTag = new ListTag();
        for (TrafficLightSchedule data : this.schedules) {
            listTag.add((Object)data.toNbt());
        }
        ListTag trafficLightsList = new ListTag();
        for (Location loc : this.trafficLightLocations) {
            trafficLightsList.add((Object)loc.toNbt());
        }
        tag.putInt(NBT_TICKS, this.ticks);
        tag.putLong(NBT_TOTAL_TICKS, this.totalTicks);
        tag.putBoolean(NBT_POWERED, this.powered);
        tag.putBoolean(NBT_RUNNING, this.running);
        tag.put(NBT_SCHEDULES, (Tag)listTag);
        tag.put(NBT_TRAFFIC_LIGHT_LOCATIONS, (Tag)trafficLightsList);
    }

    private void instanceTick(Level level, BlockPos pos, BlockState state) {
        if (level.isClientSide) {
            return;
        }
        if (this.running) {
            TrafficLightSchedule schedule = this.getFirstOrMainSchedule();
            OrderedArrayList<TrafficLightScheduleEntryData> stateData = schedule.shouldChange(this.ticks);
            if (stateData == null) {
                this.ticks = 0;
                if (!schedule.isLoop()) {
                    this.setRunning(false);
                }
                return;
            }
            if (stateData.size() > 0) {
                for (TrafficLightScheduleEntryData entry : stateData) {
                    List<TrafficLightColor> colors = entry.getEnabledColors();
                    int phaseId = entry.getPhaseId();
                    this.trafficLightLocations.removeIf(a -> !level.isLoaded(a.getLocationBlockPos()) && !(level.getBlockState(a.getLocationBlockPos()).getBlock() instanceof TrafficLightBlock) || !(level.getBlockEntity(a.getLocationBlockPos()) instanceof TrafficLightBlockEntity));
                    this.trafficLightLocations.stream().filter(x -> {
                        TrafficLightBlockEntity blockEntity;
                        BlockEntity patt0$temp = level.getBlockEntity(x.getLocationBlockPos());
                        return patt0$temp instanceof TrafficLightBlockEntity && (blockEntity = (TrafficLightBlockEntity)patt0$temp).getControlType() == TrafficLightControlType.REMOTE && blockEntity.getPhaseId() == phaseId;
                    }).forEach(a -> ((TrafficLightBlockEntity)level.getBlockEntity(a.getLocationBlockPos())).enableOnlyColors(colors));
                }
            }
            ++this.ticks;
            ++this.totalTicks;
        }
        if (this.isPowered() && !level.hasNeighborSignal(pos)) {
            this.setPowered(false);
        }
    }

    public static void tick(Level level, BlockPos pos, BlockState state, TrafficLightControllerBlockEntity blockEntity) {
        blockEntity.instanceTick(level, pos, state);
    }

    public List<TrafficLightSchedule> getSchedules() {
        return this.schedules;
    }

    public TrafficLightSchedule getFirstOrMainSchedule() {
        if (this.schedules.size() > 0) {
            return this.schedules.get(0);
        }
        return new TrafficLightSchedule();
    }

    public void setFirstOrMainSchedule(TrafficLightSchedule schedule) {
        if (this.schedules.size() > 0) {
            this.schedules.remove(0);
        }
        this.schedules.add(0, schedule);
        this.notifyUpdate();
    }

    public void setSchedules(List<TrafficLightSchedule> schedules) {
        this.schedules.clear();
        this.schedules = schedules;
        this.notifyUpdate();
    }

    public int getCurrentTick() {
        return this.ticks;
    }

    public void setCurrentTick(int t) {
        this.ticks = t;
        this.notifyUpdate();
    }

    public boolean isRunning() {
        return this.running;
    }

    public void setRunning(boolean b) {
        this.running = b;
        this.notifyUpdate();
    }

    public void startSchedule(boolean forceRestart) {
        if (forceRestart || !this.isFirstIteration()) {
            this.totalTicks = 0L;
            this.ticks = 0;
            this.running = true;
            this.notifyUpdate();
        }
    }

    public void stopSchedule() {
        this.running = false;
        this.totalTicks = 0L;
        this.ticks = 0;
        this.notifyUpdate();
    }

    public boolean isFirstIteration() {
        return this.totalTicks == (long)this.ticks;
    }

    public void setPowered(boolean b) {
        this.powered = b;
        this.notifyUpdate();
    }

    public boolean isPowered() {
        return this.powered;
    }

    public List<Location> getTrafficLightLocations() {
        return this.trafficLightLocations;
    }

    public void addTrafficLightLocation(Location loc) {
        if (!this.trafficLightLocations.contains(loc)) {
            this.trafficLightLocations.add(loc);
            this.notifyUpdate();
        }
    }

    public void removeTrafficLightLocation(Location loc) {
        this.trafficLightLocations.removeIf(x -> x.equals((Object)loc));
        this.notifyUpdate();
    }
}

