/*
 * Decompiled with CFR 0.152.
 */
package de.mrjulsen.trafficcraft.block;

import com.mojang.serialization.MapCodec;
import de.mrjulsen.trafficcraft.block.data.ITrafficPostLike;
import de.mrjulsen.trafficcraft.block.entity.TrafficLightRequestButtonBlockEntity;
import de.mrjulsen.trafficcraft.registry.ModBlockEntities;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.level.material.MapColor;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;

public class TrafficLightRequestButtonBlock
extends BaseEntityBlock
implements SimpleWaterloggedBlock,
ITrafficPostLike {
    public static final MapCodec<TrafficLightRequestButtonBlock> CODEC = TrafficLightRequestButtonBlock.simpleCodec(TrafficLightRequestButtonBlock::new);
    public static final DirectionProperty FACING = HorizontalDirectionalBlock.FACING;
    public static final BooleanProperty POWERED = BooleanProperty.create((String)"powered");
    public static final BooleanProperty ACTIVATED = BooleanProperty.create((String)"activated");
    public static final BooleanProperty WATERLOGGED = BlockStateProperties.WATERLOGGED;
    private static final int PRESS_DURATION = 30;
    public static final VoxelShape SHAPE_COMMON = Block.box((double)7.0, (double)0.0, (double)7.0, (double)9.0, (double)16.0, (double)9.0);
    public static final VoxelShape SHAPE_NORTH = Shapes.or((VoxelShape)Block.box((double)5.0, (double)1.0, (double)3.0, (double)11.0, (double)10.0, (double)8.0), (VoxelShape)SHAPE_COMMON);
    public static final VoxelShape SHAPE_SOUTH = Shapes.or((VoxelShape)Block.box((double)5.0, (double)1.0, (double)8.0, (double)11.0, (double)10.0, (double)13.0), (VoxelShape)SHAPE_COMMON);
    public static final VoxelShape SHAPE_EAST = Shapes.or((VoxelShape)Block.box((double)8.0, (double)1.0, (double)5.0, (double)13.0, (double)10.0, (double)11.0), (VoxelShape)SHAPE_COMMON);
    public static final VoxelShape SHAPE_WEST = Shapes.or((VoxelShape)Block.box((double)3.0, (double)1.0, (double)5.0, (double)8.0, (double)10.0, (double)11.0), (VoxelShape)SHAPE_COMMON);

    protected MapCodec<? extends BaseEntityBlock> codec() {
        return CODEC;
    }

    public TrafficLightRequestButtonBlock(BlockBehaviour.Properties properties) {
        super(properties.mapColor(MapColor.METAL).strength(2.0f).requiresCorrectToolForDrops().sound(SoundType.METAL));
        this.registerDefaultState((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)FACING, (Comparable)Direction.NORTH)).setValue((Property)POWERED, (Comparable)Boolean.valueOf(false))).setValue((Property)ACTIVATED, (Comparable)Boolean.valueOf(false))).setValue((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false)));
    }

    public VoxelShape getShape(BlockState pState, BlockGetter pLevel, BlockPos pPos, CollisionContext pContext) {
        switch ((Direction)pState.getValue((Property)FACING)) {
            case NORTH: {
                return SHAPE_NORTH;
            }
            case SOUTH: {
                return SHAPE_SOUTH;
            }
            case EAST: {
                return SHAPE_EAST;
            }
            case WEST: {
                return SHAPE_WEST;
            }
        }
        return SHAPE_COMMON;
    }

    protected InteractionResult useWithoutItem(BlockState state, Level level, BlockPos pos, Player player, BlockHitResult hitResult) {
        BlockPos blockpos;
        Direction direction;
        boolean flag;
        if (!((Boolean)state.getValue((Property)POWERED)).booleanValue() && !((Boolean)state.getValue((Property)ACTIVATED)).booleanValue() && (flag = this.isProperHit(state, direction = hitResult.getDirection(), hitResult.getLocation().y - (double)(blockpos = hitResult.getBlockPos()).getY()))) {
            this.press(state, level, pos);
            level.gameEvent((Entity)player, (Holder)GameEvent.BLOCK_ACTIVATE, pos);
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.FAIL;
    }

    private boolean isProperHit(BlockState state, Direction pDirection, double pDistanceY) {
        return pDirection == state.getValue((Property)FACING) && !(pDistanceY > 0.625) && !(pDistanceY < 0.0625);
    }

    public void press(BlockState pState, Level pLevel, BlockPos pPos) {
        pLevel.setBlockAndUpdate(pPos, (BlockState)pState.setValue((Property)POWERED, (Comparable)Boolean.valueOf(true)));
        pLevel.playSound(null, pPos, SoundEvents.METAL_PRESSURE_PLATE_CLICK_ON, SoundSource.BLOCKS, 0.3f, 0.90000004f);
        pLevel.scheduleTick(pPos, (Block)this, 30);
    }

    public void tick(BlockState pState, ServerLevel pLevel, BlockPos pPos, RandomSource pRand) {
        if (((Boolean)pState.getValue((Property)POWERED)).booleanValue()) {
            TrafficLightRequestButtonBlockEntity blockEntity;
            BlockEntity blockEntity2 = pLevel.getBlockEntity(pPos);
            if (blockEntity2 instanceof TrafficLightRequestButtonBlockEntity && (blockEntity = (TrafficLightRequestButtonBlockEntity)blockEntity2).isValidLinked()) {
                if (blockEntity.activate()) {
                    pLevel.setBlockAndUpdate(pPos, (BlockState)((BlockState)pState.setValue((Property)POWERED, (Comparable)Boolean.valueOf(false))).setValue((Property)ACTIVATED, (Comparable)Boolean.valueOf(true)));
                } else {
                    pLevel.setBlockAndUpdate(pPos, (BlockState)((BlockState)pState.setValue((Property)POWERED, (Comparable)Boolean.valueOf(false))).setValue((Property)ACTIVATED, (Comparable)Boolean.valueOf(false)));
                }
            } else {
                pLevel.setBlockAndUpdate(pPos, (BlockState)((BlockState)pState.setValue((Property)POWERED, (Comparable)Boolean.valueOf(false))).setValue((Property)ACTIVATED, (Comparable)Boolean.valueOf(false)));
            }
            pLevel.playSound(null, pPos, SoundEvents.METAL_PRESSURE_PLATE_CLICK_OFF, SoundSource.BLOCKS, 0.3f, 0.75f);
            pLevel.gameEvent(null, (Holder)GameEvent.BLOCK_DEACTIVATE, pPos);
        }
    }

    public BlockState updateShape(BlockState pState, Direction pFacing, BlockState pFacingState, LevelAccessor pLevel, BlockPos pCurrentPos, BlockPos pFacingPos) {
        if (((Boolean)pState.getValue((Property)WATERLOGGED)).booleanValue()) {
            pLevel.scheduleTick(pCurrentPos, (Fluid)Fluids.WATER, Fluids.WATER.getTickDelay((LevelReader)pLevel));
        }
        return super.updateShape(pState, pFacing, pFacingState, pLevel, pCurrentPos, pFacingPos);
    }

    public FluidState getFluidState(BlockState pState) {
        return (Boolean)pState.getValue((Property)WATERLOGGED) != false ? Fluids.WATER.getSource(false) : super.getFluidState(pState);
    }

    public BlockState rotate(BlockState pState, Rotation pRotation) {
        return (BlockState)pState.setValue((Property)FACING, (Comparable)pRotation.rotate((Direction)pState.getValue((Property)FACING)));
    }

    public BlockState mirror(BlockState pState, Mirror pMirror) {
        return pState.rotate(pMirror.getRotation((Direction)pState.getValue((Property)FACING)));
    }

    public BlockState getStateForPlacement(BlockPlaceContext pContext) {
        FluidState fluidstate = pContext.getLevel().getFluidState(pContext.getClickedPos());
        boolean flag = fluidstate.getType() == Fluids.WATER;
        return (BlockState)((BlockState)this.defaultBlockState().setValue((Property)FACING, (Comparable)pContext.getHorizontalDirection().getOpposite())).setValue((Property)WATERLOGGED, (Comparable)Boolean.valueOf(flag));
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> pBuilder) {
        super.createBlockStateDefinition(pBuilder);
        pBuilder.add(new Property[]{FACING, POWERED, ACTIVATED, WATERLOGGED});
    }

    public boolean isPathfindable(BlockState pState, BlockGetter pLevel, BlockPos pPos, PathComputationType pType) {
        return false;
    }

    public RenderShape getRenderShape(BlockState pState) {
        return RenderShape.MODEL;
    }

    public BlockEntity newBlockEntity(BlockPos pPos, BlockState pState) {
        return new TrafficLightRequestButtonBlockEntity(pPos, pState);
    }

    public <T extends BlockEntity> BlockEntityTicker<T> getTicker(Level pLevel, BlockState pState, BlockEntityType<T> pBlockEntityType) {
        return TrafficLightRequestButtonBlock.createTickerHelper(pBlockEntityType, (BlockEntityType)((BlockEntityType)ModBlockEntities.TRAFFIC_LIGHT_REQUEST_BUTTON_BLOCK_ENTITY.get()), TrafficLightRequestButtonBlockEntity::tick);
    }

    @Override
    public boolean canAttach(BlockState pState, BlockPos pPos, Direction pDirection) {
        return pDirection != pState.getValue((Property)FACING);
    }
}

