/*
 * Decompiled with CFR 0.152.
 */
package de.mrjulsen.trafficcraft.block;

import com.mojang.serialization.MapCodec;
import de.mrjulsen.trafficcraft.block.data.TrafficLightTrigger;
import de.mrjulsen.trafficcraft.block.entity.TrafficLightControllerBlockEntity;
import de.mrjulsen.trafficcraft.client.ClientWrapper;
import de.mrjulsen.trafficcraft.item.ILinkerItem;
import de.mrjulsen.trafficcraft.item.WrenchItem;
import de.mrjulsen.trafficcraft.registry.ModBlockEntities;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.MapColor;
import net.minecraft.world.phys.BlockHitResult;

public class TrafficLightControllerBlock
extends BaseEntityBlock {
    public static final MapCodec<TrafficLightControllerBlock> CODEC = TrafficLightControllerBlock.simpleCodec(TrafficLightControllerBlock::new);
    public static final DirectionProperty FACING = HorizontalDirectionalBlock.FACING;

    protected MapCodec<? extends BaseEntityBlock> codec() {
        return CODEC;
    }

    public TrafficLightControllerBlock(BlockBehaviour.Properties properties) {
        super(properties.mapColor(MapColor.METAL).strength(1.5f).requiresCorrectToolForDrops().sound(SoundType.METAL));
        this.registerDefaultState((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)FACING, (Comparable)Direction.NORTH));
    }

    public BlockState rotate(BlockState pState, Rotation pRotation) {
        return (BlockState)pState.setValue((Property)FACING, (Comparable)pRotation.rotate((Direction)pState.getValue((Property)FACING)));
    }

    public BlockState mirror(BlockState pState, Mirror pMirror) {
        return pState.rotate(pMirror.getRotation((Direction)pState.getValue((Property)FACING)));
    }

    public BlockState getStateForPlacement(BlockPlaceContext pContext) {
        return (BlockState)this.defaultBlockState().setValue((Property)FACING, (Comparable)pContext.getHorizontalDirection().getOpposite());
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> pBuilder) {
        super.createBlockStateDefinition(pBuilder);
        pBuilder.add(new Property[]{FACING});
    }

    public void stepOn(Level pLevel, BlockPos pPos, BlockState pState, Entity pEntity) {
        if (!pLevel.dimensionType().ultraWarm()) {
            return;
        }
        if (!pEntity.isSteppingCarefully() && pEntity instanceof LivingEntity) {
            pEntity.hurt(pLevel.damageSources().hotFloor(), 1.0f);
        }
        super.stepOn(pLevel, pPos, pState, pEntity);
    }

    public void animateTick(BlockState pState, Level pLevel, BlockPos pPos, RandomSource pRandom) {
        TrafficLightControllerBlockEntity blockEntity;
        BlockEntity blockEntity2;
        if (pLevel.dimensionType().ultraWarm() && (blockEntity2 = pLevel.getBlockEntity(pPos)) instanceof TrafficLightControllerBlockEntity && (blockEntity = (TrafficLightControllerBlockEntity)blockEntity2).isRunning()) {
            pLevel.addParticle((ParticleOptions)ParticleTypes.SMOKE, (double)pPos.getX() + 0.5, (double)pPos.getY() + 0.5, (double)pPos.getZ() + 0.5, pRandom.triangle(-0.05, 0.05), pRandom.triangle(-0.05, 0.05), pRandom.triangle(-0.05, 0.05));
        }
        super.animateTick(pState, pLevel, pPos, pRandom);
    }

    protected ItemInteractionResult useItemOn(ItemStack stack, BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hitResult) {
        Item item = stack.getItem();
        if (!(item == null || !(item instanceof WrenchItem) || item instanceof ILinkerItem && ((ILinkerItem)item).isSourceBlockAccepted((Block)this))) {
            if (level.isClientSide && !player.isShiftKeyDown()) {
                ClientWrapper.showTrafficLightControllerScreen(pos, level);
            }
            return ItemInteractionResult.SUCCESS;
        }
        return ItemInteractionResult.PASS_TO_DEFAULT_BLOCK_INTERACTION;
    }

    public void neighborChanged(BlockState pState, Level pLevel, BlockPos pPos, Block pBlock, BlockPos pFromPos, boolean pIsMoving) {
        BlockEntity blockEntity = pLevel.getBlockEntity(pPos);
        if (blockEntity instanceof TrafficLightControllerBlockEntity) {
            TrafficLightControllerBlockEntity blockEntity2 = (TrafficLightControllerBlockEntity)blockEntity;
            if (pLevel.hasNeighborSignal(pPos)) {
                if (blockEntity2.getFirstOrMainSchedule().getTrigger() == TrafficLightTrigger.REDSTONE && !blockEntity2.isPowered()) {
                    blockEntity2.setPowered(true);
                    blockEntity2.startSchedule(true);
                }
            } else {
                blockEntity2.setPowered(false);
                if (blockEntity2.getFirstOrMainSchedule().getTrigger() == TrafficLightTrigger.REDSTONE) {
                    blockEntity2.stopSchedule();
                }
            }
        }
    }

    public boolean hasAnalogOutputSignal(BlockState pState) {
        return true;
    }

    public int getAnalogOutputSignal(BlockState pState, Level pLevel, BlockPos pPos) {
        TrafficLightControllerBlockEntity blockEntity;
        BlockEntity blockEntity2 = pLevel.getBlockEntity(pPos);
        return blockEntity2 instanceof TrafficLightControllerBlockEntity && (blockEntity = (TrafficLightControllerBlockEntity)blockEntity2).isRunning() ? 15 : 0;
    }

    public RenderShape getRenderShape(BlockState pState) {
        return RenderShape.MODEL;
    }

    public BlockEntity newBlockEntity(BlockPos pPos, BlockState pState) {
        return new TrafficLightControllerBlockEntity(pPos, pState);
    }

    public <T extends BlockEntity> BlockEntityTicker<T> getTicker(Level pLevel, BlockState pState, BlockEntityType<T> pBlockEntityType) {
        return TrafficLightControllerBlock.createTickerHelper(pBlockEntityType, (BlockEntityType)((BlockEntityType)ModBlockEntities.TRAFFIC_LIGHT_CONTROLLER_BLOCK_ENTITY.get()), TrafficLightControllerBlockEntity::tick);
    }
}

