/*
 * Decompiled with CFR 0.152.
 */
package net.aaavein.tidymods.data;

import java.util.Optional;
import net.aaavein.tidymods.data.ModData;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.neoforged.fml.ModContainer;
import net.neoforged.fml.ModList;
import net.neoforged.neoforge.client.gui.IConfigScreenFactory;
import net.neoforged.neoforgespi.language.IModInfo;
import org.jetbrains.annotations.Nullable;

public record NeoForgeData(IModInfo info) implements ModData
{
    private static final String MISSING_DESCRIPTION = "MISSING DESCRIPTION";

    @Override
    public String modId() {
        return this.info.getModId();
    }

    @Override
    public String displayName() {
        return this.info.getDisplayName();
    }

    @Override
    public String version() {
        return this.info.getVersion().toString();
    }

    @Override
    @Nullable
    public String description() {
        String desc = this.info.getDescription();
        if (desc == null || desc.isBlank() || desc.equals(MISSING_DESCRIPTION)) {
            return null;
        }
        return desc.trim();
    }

    @Override
    @Nullable
    public String authors() {
        return this.getConfigString("authors");
    }

    @Override
    @Nullable
    public String license() {
        try {
            String license = this.info.getOwningFile().getLicense();
            if (license != null && !license.isBlank()) {
                return license.trim();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    @Override
    @Nullable
    public String homepage() {
        return this.getConfigString("displayURL");
    }

    @Override
    @Nullable
    public String issueTracker() {
        String url = this.getConfigString("issueTrackerURL");
        if (url != null) {
            return url;
        }
        try {
            return this.info.getOwningFile().getConfig().getConfigElement(new String[]{"issueTrackerURL"}).orElse(null);
        }
        catch (Exception e) {
            return null;
        }
    }

    @Override
    @Nullable
    public String logoFile() {
        return this.info.getLogoFile().orElse(null);
    }

    @Override
    @Nullable
    public String declaredCategory() {
        return this.getConfigString("modCategory");
    }

    @Override
    public boolean hasConfig() {
        return this.getContainer().map(c -> c.getCustomExtension(IConfigScreenFactory.class).isPresent()).orElse(false);
    }

    @Override
    public boolean smoothLogo() {
        return this.info.getLogoBlur();
    }

    @Override
    public void openConfig(Screen parent) {
        this.getContainer().ifPresent(container -> container.getCustomExtension(IConfigScreenFactory.class).ifPresent(factory -> Minecraft.getInstance().setScreen(factory.createScreen(container, parent))));
    }

    private Optional<? extends ModContainer> getContainer() {
        return ModList.get().getModContainerById(this.info.getModId());
    }

    @Nullable
    private String getConfigString(String key) {
        try {
            return this.info.getConfig().getConfigElement(new String[]{key}).orElse(null);
        }
        catch (Exception e) {
            return null;
        }
    }
}

