/*
 * Decompiled with CFR 0.152.
 */
package net.aaavein.tidymods.config;

import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.minecraft.resources.ResourceLocation;
import net.neoforged.neoforge.common.ModConfigSpec;
import org.apache.commons.lang3.tuple.Pair;

public final class TidyModsConfig {
    public static final ModConfigSpec SPEC;
    private static final Config CONFIG;
    private static final Map<String, ResourceLocation> ICON_CACHE;
    private static final Set<String> HIDDEN_CACHE;
    private static ResourceLocation defaultIconCache;
    private static boolean cacheValid;

    private TidyModsConfig() {
    }

    public static boolean hideRealmsButton() {
        return (Boolean)TidyModsConfig.CONFIG.hideRealmsButton.get();
    }

    public static boolean showModCount() {
        return (Boolean)TidyModsConfig.CONFIG.showModCount.get();
    }

    public static boolean showModIds() {
        return (Boolean)TidyModsConfig.CONFIG.showModIds.get();
    }

    public static boolean entryShowVersion() {
        return (Boolean)TidyModsConfig.CONFIG.entryShowVersion.get();
    }

    public static boolean entryShowAuthors() {
        return (Boolean)TidyModsConfig.CONFIG.entryShowAuthors.get();
    }

    public static boolean hideConfigButtons() {
        return (Boolean)TidyModsConfig.CONFIG.hideConfigButtons.get();
    }

    public static boolean tooltipShowAuthors() {
        return (Boolean)TidyModsConfig.CONFIG.tooltipShowAuthors.get();
    }

    public static boolean tooltipShowDescription() {
        return (Boolean)TidyModsConfig.CONFIG.tooltipShowDescription.get();
    }

    public static boolean tooltipShowLicense() {
        return (Boolean)TidyModsConfig.CONFIG.tooltipShowLicense.get();
    }

    public static boolean configsOnly() {
        return (Boolean)TidyModsConfig.CONFIG.configsOnly.get();
    }

    public static List<? extends String> hiddenMods() {
        return (List)TidyModsConfig.CONFIG.hiddenMods.get();
    }

    public static boolean isHidden(String modId) {
        TidyModsConfig.ensureCached();
        return HIDDEN_CACHE.contains(modId.toLowerCase());
    }

    public static String defaultCategory() {
        return ((String)TidyModsConfig.CONFIG.defaultCategory.get()).toLowerCase();
    }

    public static boolean librariesAtBottom() {
        return (Boolean)TidyModsConfig.CONFIG.librariesAtBottom.get();
    }

    public static List<? extends String> categoryOverrides() {
        return (List)TidyModsConfig.CONFIG.categoryOverrides.get();
    }

    public static boolean useCategoryIcons() {
        return (Boolean)TidyModsConfig.CONFIG.useCategoryIcons.get();
    }

    public static ResourceLocation categoryIcon(String category) {
        TidyModsConfig.ensureCached();
        return ICON_CACHE.get(category.toLowerCase());
    }

    public static ResourceLocation defaultModIcon() {
        TidyModsConfig.ensureCached();
        return defaultIconCache;
    }

    public static boolean printUncategorized() {
        return (Boolean)TidyModsConfig.CONFIG.printUncategorized.get();
    }

    public static void clearCaches() {
        cacheValid = false;
    }

    private static void ensureCached() {
        if (cacheValid) {
            return;
        }
        cacheValid = true;
        ICON_CACHE.clear();
        for (String entry : (List)TidyModsConfig.CONFIG.categoryIcons.get()) {
            ResourceLocation loc;
            String[] parts = entry.split(";", 2);
            if (parts.length != 2 || (loc = ResourceLocation.tryParse((String)parts[1].trim())) == null) continue;
            ICON_CACHE.put(parts[0].trim().toLowerCase(), loc);
        }
        HIDDEN_CACHE.clear();
        for (String modId : (List)TidyModsConfig.CONFIG.hiddenMods.get()) {
            String trimmed = modId.trim().toLowerCase();
            if (trimmed.isEmpty()) continue;
            HIDDEN_CACHE.add(trimmed);
        }
        defaultIconCache = ResourceLocation.tryParse((String)((String)TidyModsConfig.CONFIG.defaultModIcon.get()));
    }

    private static boolean isValidString(Object obj) {
        return obj instanceof String;
    }

    private static boolean isValidMapping(Object obj) {
        String s;
        return obj instanceof String && (s = (String)obj).contains(";");
    }

    static {
        ICON_CACHE = new HashMap<String, ResourceLocation>();
        HIDDEN_CACHE = new HashSet<String>();
        defaultIconCache = null;
        cacheValid = false;
        Pair pair = new ModConfigSpec.Builder().configure(Config::new);
        CONFIG = (Config)pair.getLeft();
        SPEC = (ModConfigSpec)pair.getRight();
    }

    private static class Config {
        final ModConfigSpec.BooleanValue hideRealmsButton;
        final ModConfigSpec.BooleanValue showModCount;
        final ModConfigSpec.BooleanValue showModIds;
        final ModConfigSpec.BooleanValue entryShowVersion;
        final ModConfigSpec.BooleanValue entryShowAuthors;
        final ModConfigSpec.BooleanValue hideConfigButtons;
        final ModConfigSpec.BooleanValue tooltipShowAuthors;
        final ModConfigSpec.BooleanValue tooltipShowDescription;
        final ModConfigSpec.BooleanValue tooltipShowLicense;
        final ModConfigSpec.BooleanValue configsOnly;
        final ModConfigSpec.ConfigValue<List<? extends String>> hiddenMods;
        final ModConfigSpec.ConfigValue<String> defaultCategory;
        final ModConfigSpec.BooleanValue librariesAtBottom;
        final ModConfigSpec.ConfigValue<List<? extends String>> categoryOverrides;
        final ModConfigSpec.BooleanValue useCategoryIcons;
        final ModConfigSpec.ConfigValue<List<? extends String>> categoryIcons;
        final ModConfigSpec.ConfigValue<String> defaultModIcon;
        final ModConfigSpec.BooleanValue printUncategorized;

        Config(ModConfigSpec.Builder builder) {
            builder.push("display");
            this.showModCount = builder.comment(" Shows the total number of loaded mods in the screen title.").define("show_mod_count", true);
            this.showModIds = builder.comment(" Displays technical mod IDs instead of human-readable names.").define("show_mod_ids", false);
            this.hideRealmsButton = builder.comment(" Hides the Realms button on the title screen.").define("hide_realms_button", true);
            builder.pop();
            builder.push("entries");
            this.entryShowVersion = builder.comment(" Shows the version number next to each mod name.").define("entry_show_version", true);
            this.entryShowAuthors = builder.comment(" Shows the author names next to each mod name.").define("entry_show_authors", false);
            this.hideConfigButtons = builder.comment(" Hides the configuration buttons.").define("hide_config_buttons", false);
            builder.pop();
            builder.push("tooltips");
            this.tooltipShowAuthors = builder.comment(" Includes author information in the mod tooltip.").define("tooltip_show_authors", true);
            this.tooltipShowDescription = builder.comment(" Includes the mod description in the mod tooltip.").define("tooltip_show_description", true);
            this.tooltipShowLicense = builder.comment(" Includes license information in the mod tooltip.").define("tooltip_show_license", true);
            builder.pop();
            builder.push("filtering");
            this.configsOnly = builder.comment(" Only shows mods that have a configuration screen.").define("configs_only", false);
            this.hiddenMods = builder.comment(new String[]{" List of mod IDs to hide from the mod list.", " Format: modid"}).defineListAllowEmpty("hidden_mods", List.of(), () -> "", TidyModsConfig::isValidString);
            builder.pop();
            builder.push("categories");
            this.defaultCategory = builder.comment(new String[]{" Category assigned to mods without a predefined category.", " This category always appears at the bottom of the list."}).define("default_category", (Object)"uncategorized");
            this.librariesAtBottom = builder.comment(" Places the libraries category at the bottom, below the default category.").define("libraries_at_bottom", true);
            this.categoryOverrides = builder.comment(new String[]{" Custom category assignments that override built-in defaults.", " Format: modid;category"}).defineListAllowEmpty("category_overrides", List.of(), () -> "", TidyModsConfig::isValidMapping);
            builder.pop();
            builder.push("icons");
            this.useCategoryIcons = builder.comment(" Uses a shared icon for all mods in each category instead of individual mod icons.").define("use_category_icons", false);
            this.categoryIcons = builder.comment(new String[]{" Texture mappings for category icons.", " Format: category;namespace:path/to/texture.png"}).defineListAllowEmpty("category_icons", List.of("library;minecraft:textures/item/book.png", "technology;minecraft:textures/item/copper_ingot.png", "magic;minecraft:textures/item/blaze_powder.png", "agriculture;minecraft:textures/item/wheat.png", "worldgen;minecraft:textures/block/oak_sapling.png", "mobs;minecraft:textures/item/egg.png", "equipment;minecraft:textures/item/iron_sword.png", "storage;minecraft:textures/item/chest_minecart.png", "building;minecraft:textures/item/brick.png", "utility;minecraft:textures/item/redstone.png", "system;minecraft:textures/item/feather.png", "functional;minecraft:textures/item/compass_28.png", "uncategorized;minecraft:textures/item/paper.png"), () -> "", TidyModsConfig::isValidMapping);
            this.defaultModIcon = builder.comment(" Fallback texture for mods without an icon. Used when category icons are disabled.").define("default_mod_icon", (Object)"minecraft:textures/misc/unknown_server.png");
            builder.pop();
            builder.push("debug");
            this.printUncategorized = builder.comment(" Logs all uncategorized mods to the console during startup.").define("print_uncategorized", false);
            builder.pop();
        }
    }
}

