/*
 * Decompiled with CFR 0.152.
 */
package net.aaavein.tidymods.client.gui.widget;

import com.mojang.blaze3d.systems.RenderSystem;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.Tooltip;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class IconButton
extends Button {
    public static final ResourceLocation TEXTURE = ResourceLocation.fromNamespaceAndPath((String)"tidymods", (String)"textures/gui/icons.png");
    public static final int CONFIG = 0;
    public static final int WEB = 1;
    public static final int ISSUES = 2;
    private static final int SIZE = 20;
    private static final int ICON_SIZE = 10;
    private static final int ICON_OFFSET = 5;
    private static final int TEXTURE_SIZE = 64;
    private final int icon;

    public IconButton(int x, int y, int icon, @Nullable Component tooltip, @NotNull Button.OnPress action) {
        super(x, y, 20, 20, CommonComponents.EMPTY, action, DEFAULT_NARRATION);
        this.icon = icon;
        if (tooltip != null) {
            this.setTooltip(Tooltip.create((Component)tooltip));
        }
    }

    public void renderWidget(@NotNull GuiGraphics gfx, int mx, int my, float pt) {
        super.renderWidget(gfx, mx, my, pt);
        float brightness = this.active ? 1.0f : 0.5f;
        RenderSystem.setShaderColor((float)brightness, (float)brightness, (float)brightness, (float)this.alpha);
        RenderSystem.enableBlend();
        gfx.blit(TEXTURE, this.getX() + 5, this.getY() + 5, (float)(this.icon * 10), 0.0f, 10, 10, 64, 64);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.disableBlend();
    }
}

