/*
 * Decompiled with CFR 0.152.
 */
package net.aaavein.tidymods.client.gui.widget;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import java.util.function.Consumer;
import java.util.function.Supplier;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.Style;
import net.minecraft.util.FormattedCharSequence;
import org.jetbrains.annotations.NotNull;

public class AutoCompleteEditBox
extends EditBox {
    private static final int DEFAULT_TEXT_COLOR = 0xE0E0E0;
    private static final int DEFAULT_SUGGESTION_COLOR = 0x888888;
    private static final int CATEGORY_TEXT_COLOR = 0x55FF55;
    private static final int CATEGORY_SUGGESTION_COLOR = 2785322;
    private static final int MODID_TEXT_COLOR = 0x5555FF;
    private static final int MODID_SUGGESTION_COLOR = 2763392;
    private static final int AUTHOR_TEXT_COLOR = 0xFFFF55;
    private static final int AUTHOR_SUGGESTION_COLOR = 8421418;
    private static final int LICENSE_TEXT_COLOR = 0x55FFFF;
    private static final int LICENSE_SUGGESTION_COLOR = 2785408;
    private static final int PADDING = 4;
    private final Font font;
    private final Supplier<List<String>> suggestionsSupplier;
    private Consumer<String> externalResponder;
    private String currentSuggestion = "";

    public AutoCompleteEditBox(Font font, int x, int y, int width, int height, Component message, Supplier<List<String>> suggestionsSupplier) {
        super(font, x, y, width, height, message);
        this.font = font;
        this.suggestionsSupplier = suggestionsSupplier;
        super.setResponder(this::onTextChanged);
        this.setFormatter(this::formatText);
    }

    private FormattedCharSequence formatText(String text, int firstCharIndex) {
        if (text.isEmpty()) {
            return FormattedCharSequence.EMPTY;
        }
        int[] colors = this.calculateColors(text);
        ArrayList<FormattedCharSequence> parts = new ArrayList<FormattedCharSequence>();
        int i = 0;
        while (i < text.length()) {
            int color = colors[i];
            int start = i;
            while (i < text.length() && colors[i] == color) {
                ++i;
            }
            parts.add(FormattedCharSequence.forward((String)text.substring(start, i), (Style)Style.EMPTY.withColor(color)));
        }
        return FormattedCharSequence.composite(parts);
    }

    private int[] calculateColors(String text) {
        int[] colors = new int[text.length()];
        Arrays.fill(colors, 0xE0E0E0);
        int i = 0;
        while (i < text.length()) {
            if (text.charAt(i) == ' ') {
                colors[i] = 0xE0E0E0;
                ++i;
                continue;
            }
            char firstChar = text.charAt(i);
            if (this.isFilterPrefix(firstChar)) {
                int filterColor;
                colors[i] = filterColor = this.getFilterColor(firstChar);
                if (++i < text.length() && text.charAt(i) == '\"') {
                    do {
                        colors[i] = filterColor;
                    } while (++i < text.length() && text.charAt(i) != '\"');
                    if (i >= text.length()) continue;
                    colors[i] = filterColor;
                    ++i;
                    continue;
                }
                while (i < text.length() && text.charAt(i) != ' ') {
                    colors[i] = filterColor;
                    ++i;
                }
                continue;
            }
            while (i < text.length() && text.charAt(i) != ' ') {
                colors[i] = 0xE0E0E0;
                ++i;
            }
        }
        return colors;
    }

    private boolean isFilterPrefix(char c) {
        return c == '#' || c == '@' || c == '!' || c == '$';
    }

    private int getFilterColor(char prefix) {
        return switch (prefix) {
            case '#' -> 0x55FF55;
            case '@' -> 0x5555FF;
            case '!' -> 0xFFFF55;
            case '$' -> 0x55FFFF;
            default -> 0xE0E0E0;
        };
    }

    private int getFilterSuggestionColor(char prefix) {
        return switch (prefix) {
            case '#' -> 2785322;
            case '@' -> 2763392;
            case '!' -> 8421418;
            case '$' -> 2785408;
            default -> 0x888888;
        };
    }

    private int getSuggestionColor() {
        String value = this.getValue();
        if (value.isEmpty()) {
            return 0x888888;
        }
        String currentToken = this.getCurrentToken(value);
        if (currentToken.isEmpty()) {
            return 0x888888;
        }
        char firstChar = currentToken.charAt(0);
        if (this.isFilterPrefix(firstChar)) {
            return this.getFilterSuggestionColor(firstChar);
        }
        return 0x888888;
    }

    private String getCurrentToken(String text) {
        if (text.isEmpty()) {
            return "";
        }
        int tokenStart = 0;
        boolean inQuotes = false;
        for (int i = 0; i < text.length(); ++i) {
            char c = text.charAt(i);
            if (c == '\"') {
                inQuotes = !inQuotes;
                continue;
            }
            if (c != ' ' || inQuotes) continue;
            tokenStart = i + 1;
        }
        return text.substring(tokenStart);
    }

    public void setResponder(@NotNull Consumer<String> responder) {
        this.externalResponder = responder;
    }

    private void onTextChanged(String text) {
        this.updateSuggestion(text);
        if (this.externalResponder != null) {
            this.externalResponder.accept(text);
        }
    }

    private void updateSuggestion(String text) {
        String searchPart;
        if (text.isEmpty()) {
            this.currentSuggestion = "";
            return;
        }
        String currentToken = this.getCurrentToken(text);
        if (currentToken.isEmpty()) {
            this.currentSuggestion = "";
            return;
        }
        char firstChar = currentToken.charAt(0);
        boolean isFilter = this.isFilterPrefix(firstChar);
        boolean isQuoted = false;
        if (isFilter) {
            if (currentToken.length() > 1 && currentToken.charAt(1) == '\"') {
                isQuoted = true;
                searchPart = currentToken.substring(2);
            } else {
                searchPart = currentToken.substring(1);
            }
        } else {
            searchPart = currentToken;
        }
        String searchLower = searchPart.toLowerCase(Locale.ROOT);
        for (String candidate : this.suggestionsSupplier.get()) {
            if (candidate.isEmpty()) continue;
            char candFirst = candidate.charAt(0);
            if (isFilter) {
                String candValue;
                if (candFirst != firstChar || !(candValue = candidate.substring(1)).toLowerCase(Locale.ROOT).startsWith(searchLower)) continue;
                Object suggestion = candValue.substring(searchPart.length());
                if (candValue.contains(" ") && isQuoted) {
                    suggestion = (String)suggestion + "\"";
                }
                this.currentSuggestion = suggestion;
                return;
            }
            if (this.isFilterPrefix(candFirst) || !candidate.toLowerCase(Locale.ROOT).startsWith(searchLower)) continue;
            this.currentSuggestion = candidate.substring(searchPart.length());
            return;
        }
        this.currentSuggestion = "";
    }

    public boolean keyPressed(int keyCode, int scanCode, int modifiers) {
        if (keyCode == 258 && !this.currentSuggestion.isEmpty() && this.isFocused()) {
            String currentValue = this.getValue();
            String currentToken = this.getCurrentToken(currentValue);
            if (!currentToken.isEmpty() && this.isFilterPrefix(currentToken.charAt(0))) {
                String valueWithoutPrefix;
                boolean isAlreadyQuoted;
                boolean bl = isAlreadyQuoted = currentToken.length() > 1 && currentToken.charAt(1) == '\"';
                if (!isAlreadyQuoted && (valueWithoutPrefix = currentToken.substring(1) + this.currentSuggestion).contains(" ")) {
                    int tokenStartInValue = currentValue.length() - currentToken.length();
                    char prefix = currentToken.charAt(0);
                    String newValue = currentValue.substring(0, tokenStartInValue) + prefix + "\"" + valueWithoutPrefix + "\"";
                    this.setValue(newValue);
                    this.moveCursorToEnd(false);
                    return true;
                }
            }
            this.setValue(currentValue + this.currentSuggestion);
            this.moveCursorToEnd(false);
            return true;
        }
        return super.keyPressed(keyCode, scanCode, modifiers);
    }

    public void renderWidget(@NotNull GuiGraphics gfx, int mouseX, int mouseY, float partialTick) {
        super.renderWidget(gfx, mouseX, mouseY, partialTick);
        this.renderSuggestion(gfx);
    }

    private void renderSuggestion(GuiGraphics gfx) {
        int innerWidth;
        if (this.currentSuggestion.isEmpty() || !this.isFocused() || !this.isVisible()) {
            return;
        }
        if (this.getCursorPosition() != this.getValue().length()) {
            return;
        }
        String text = this.getValue();
        int textWidth = this.font.width(text);
        if (textWidth >= (innerWidth = this.getInnerWidth())) {
            return;
        }
        int availableWidth = innerWidth - textWidth;
        String visible = this.font.plainSubstrByWidth(this.currentSuggestion, availableWidth);
        if (visible.isEmpty()) {
            return;
        }
        int x = this.getX() + 4 + textWidth;
        int y = this.getY() + (this.height - 8) / 2;
        gfx.drawString(this.font, visible, x, y, this.getSuggestionColor(), false);
    }
}

