/*
 * Decompiled with CFR 0.152.
 */
package net.aaavein.tidymods.client.gui;

import com.google.common.collect.ImmutableList;
import com.mojang.blaze3d.platform.NativeImage;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import net.aaavein.tidymods.client.ModDataManager;
import net.aaavein.tidymods.client.gui.ModListScreen;
import net.aaavein.tidymods.client.gui.widget.IconButton;
import net.aaavein.tidymods.config.TidyModsConfig;
import net.aaavein.tidymods.data.ModData;
import net.minecraft.ChatFormatting;
import net.minecraft.Util;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.ComponentPath;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractSelectionList;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.ContainerObjectSelectionList;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.layouts.HeaderAndFooterLayout;
import net.minecraft.client.gui.narration.NarratableEntry;
import net.minecraft.client.gui.narration.NarratedElementType;
import net.minecraft.client.gui.narration.NarrationElementOutput;
import net.minecraft.client.gui.navigation.FocusNavigationEvent;
import net.minecraft.client.renderer.texture.DynamicTexture;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.FormattedCharSequence;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ModListWidget
extends ContainerObjectSelectionList<Entry> {
    private static final Map<String, TextureInfo> TEXTURE_CACHE = new HashMap<String, TextureInfo>();
    private static final int TOOLTIP_MAX_WIDTH = 200;
    private static final String LIBRARY_CATEGORY = "library";
    private final ModListScreen screen;
    private String query = "";
    private int modCount = 0;

    public ModListWidget(ModListScreen screen, @NotNull Minecraft mc) {
        super(mc, screen.width, screen.height - 64, 48, 24);
        this.screen = screen;
        this.refresh();
    }

    public void updateLayout(int width, HeaderAndFooterLayout layout) {
        this.setSize(width, layout.getContentHeight());
        this.setY(layout.getHeaderHeight());
    }

    public void filter(String text) {
        this.query = text.toLowerCase(Locale.ROOT);
        this.refresh();
    }

    public int getModCount() {
        return this.modCount;
    }

    public void refresh() {
        double scroll = this.getScrollAmount();
        this.clearEntries();
        this.modCount = 0;
        Map<String, List<ModData>> grouped = this.groupMods();
        List<String> sorted = this.sortCategories(grouped);
        for (String category : sorted) {
            List<ModData> mods = grouped.get(category);
            if (mods == null || mods.isEmpty()) continue;
            mods.sort(Comparator.comparing(ModData::displayName, String.CASE_INSENSITIVE_ORDER));
            this.addEntry((AbstractSelectionList.Entry)new CategoryEntry((Component)Component.translatable((String)("tidymods.category." + category))));
            for (ModData mod : mods) {
                this.addEntry((AbstractSelectionList.Entry)new ModEntry(mod, category));
            }
        }
        this.setScrollAmount(scroll);
    }

    private Map<String, List<ModData>> groupMods() {
        HashMap<String, List<ModData>> grouped = new HashMap<String, List<ModData>>();
        for (ModData mod : ModDataManager.all()) {
            if (TidyModsConfig.isHidden(mod.modId()) || !this.query.isEmpty() && !this.matches(mod) || TidyModsConfig.configsOnly() && !mod.hasConfig()) continue;
            ++this.modCount;
            String category = ModDataManager.category(mod.modId());
            grouped.computeIfAbsent(category, k -> new ArrayList()).add(mod);
        }
        return grouped;
    }

    private List<String> sortCategories(Map<String, List<ModData>> grouped) {
        String defaultCategory = TidyModsConfig.defaultCategory();
        boolean librariesAtBottom = TidyModsConfig.librariesAtBottom();
        ArrayList<String> sorted = new ArrayList<String>(grouped.keySet());
        sorted.sort((a, b) -> {
            boolean aDefault = a.equals(defaultCategory);
            boolean bDefault = b.equals(defaultCategory);
            boolean aLibrary = a.equals(LIBRARY_CATEGORY);
            boolean bLibrary = b.equals(LIBRARY_CATEGORY);
            if (librariesAtBottom) {
                if (aLibrary && !bLibrary) {
                    return 1;
                }
                if (bLibrary && !aLibrary) {
                    return -1;
                }
            }
            if (aDefault && !bDefault) {
                return 1;
            }
            if (bDefault && !aDefault) {
                return -1;
            }
            return a.compareTo((String)b);
        });
        return sorted;
    }

    private boolean matches(ModData mod) {
        if (this.query.isEmpty()) {
            return true;
        }
        List<ParsedFilter> filters = this.parseFilters(this.query);
        for (ParsedFilter filter : filters) {
            if (this.matchesSingleFilter(mod, filter)) continue;
            return false;
        }
        return true;
    }

    private List<ParsedFilter> parseFilters(String text) {
        ArrayList<ParsedFilter> filters = new ArrayList<ParsedFilter>();
        int i = 0;
        while (i < text.length()) {
            String value;
            int start;
            while (i < text.length() && text.charAt(i) == ' ') {
                ++i;
            }
            if (i >= text.length()) break;
            char firstChar = text.charAt(i);
            if (this.isFilterPrefix(firstChar)) {
                if (++i < text.length() && text.charAt(i) == '\"') {
                    start = ++i;
                    while (i < text.length() && text.charAt(i) != '\"') {
                        ++i;
                    }
                    value = text.substring(start, i);
                    if (i < text.length()) {
                        ++i;
                    }
                } else {
                    start = i;
                    while (i < text.length() && text.charAt(i) != ' ') {
                        ++i;
                    }
                    value = text.substring(start, i);
                }
                filters.add(new ParsedFilter(firstChar, value.toLowerCase(Locale.ROOT)));
                continue;
            }
            if (firstChar == '\"') {
                start = ++i;
                while (i < text.length() && text.charAt(i) != '\"') {
                    ++i;
                }
                value = text.substring(start, i);
                if (i < text.length()) {
                    ++i;
                }
            } else {
                start = i;
                while (i < text.length() && text.charAt(i) != ' ') {
                    ++i;
                }
                value = text.substring(start, i);
            }
            filters.add(new ParsedFilter('\u0000', value.toLowerCase(Locale.ROOT)));
        }
        return filters;
    }

    private boolean matchesSingleFilter(ModData mod, ParsedFilter filter) {
        if (filter.value.isEmpty()) {
            return true;
        }
        return switch (filter.type) {
            case '#' -> ModDataManager.category(mod.modId()).toLowerCase(Locale.ROOT).contains(filter.value);
            case '@' -> mod.modId().toLowerCase(Locale.ROOT).contains(filter.value);
            case '!' -> {
                String authors = mod.authors();
                if (authors != null && authors.toLowerCase(Locale.ROOT).contains(filter.value)) {
                    yield true;
                }
                yield false;
            }
            case '$' -> {
                String license = mod.license();
                if (license != null && license.toLowerCase(Locale.ROOT).contains(filter.value)) {
                    yield true;
                }
                yield false;
            }
            default -> mod.displayName().toLowerCase(Locale.ROOT).contains(filter.value);
        };
    }

    private boolean isFilterPrefix(char c) {
        return c == '#' || c == '@' || c == '!' || c == '$';
    }

    public int getRowWidth() {
        return 340;
    }

    protected int getScrollbarPosition() {
        return this.width / 2 + 180;
    }

    private void cacheTexture(final ModData mod) {
        if (TEXTURE_CACHE.containsKey(mod.modId())) {
            return;
        }
        TEXTURE_CACHE.put(mod.modId(), null);
        String path = mod.logoFile();
        if (path == null || path.isEmpty()) {
            return;
        }
        ModDataManager.loadImage(mod.modId(), path, img -> {
            DynamicTexture texture = new DynamicTexture(this, (NativeImage)img){

                public void upload() {
                    this.bind();
                    NativeImage pixels = this.getPixels();
                    if (pixels != null) {
                        pixels.upload(0, 0, 0, 0, 0, pixels.getWidth(), pixels.getHeight(), mod.smoothLogo(), false, false, false);
                    }
                }
            };
            ResourceLocation loc = this.minecraft.getTextureManager().register("tidymods_icon", texture);
            TEXTURE_CACHE.put(mod.modId(), new TextureInfo(loc, img.getWidth(), img.getHeight()));
        });
    }

    public class CategoryEntry
    extends Entry {
        private final Component name;
        private final int textWidth;

        public CategoryEntry(Component name) {
            this.name = name;
            this.textWidth = ((ModListWidget)ModListWidget.this).minecraft.font.width((FormattedText)name);
        }

        public void render(@NotNull GuiGraphics gfx, int idx, int top, int left, int w, int h, int mx, int my, boolean hover, float pt) {
            int x = ModListWidget.this.width / 2 - this.textWidth / 2;
            int y = top + h - 10;
            gfx.drawString(((ModListWidget)ModListWidget.this).minecraft.font, this.name, x, y, 0xFFFFFF, false);
        }

        @Nullable
        public ComponentPath nextFocusPath(@NotNull FocusNavigationEvent e) {
            return null;
        }

        @NotNull
        public List<? extends GuiEventListener> children() {
            return Collections.emptyList();
        }

        @NotNull
        public List<? extends NarratableEntry> narratables() {
            return ImmutableList.of((Object)new NarratableEntry(){

                @NotNull
                public NarratableEntry.NarrationPriority narrationPriority() {
                    return NarratableEntry.NarrationPriority.HOVERED;
                }

                public void updateNarration(@NotNull NarrationElementOutput out) {
                    out.add(NarratedElementType.TITLE, CategoryEntry.this.name);
                }
            });
        }
    }

    public class ModEntry
    extends Entry {
        private final ModData mod;
        private final String category;
        private final Button configBtn;
        private final Button webBtn;
        private final Button issuesBtn;

        public ModEntry(ModData mod, String category) {
            this.mod = mod;
            this.category = category;
            this.configBtn = new IconButton(0, 0, 0, this.createConfigTooltip(mod), b -> mod.openConfig(ModListWidget.this.screen));
            this.configBtn.active = mod.hasConfig();
            this.webBtn = new IconButton(0, 0, 1, this.createUrlTooltip(mod.homepage(), "tidymods.gui.website"), b -> this.openUrl(mod.homepage()));
            this.webBtn.active = mod.homepage() != null;
            this.issuesBtn = new IconButton(0, 0, 2, this.createUrlTooltip(mod.issueTracker(), "tidymods.gui.issues"), b -> this.openUrl(mod.issueTracker()));
            this.issuesBtn.active = mod.issueTracker() != null;
        }

        private Component createConfigTooltip(ModData mod) {
            String key = mod.hasConfig() ? "tidymods.gui.config.tooltip" : "tidymods.gui.config.unavailable";
            return Component.translatable((String)key);
        }

        private Component createUrlTooltip(@Nullable String url, String key) {
            if (url == null) {
                return Component.translatable((String)(key + ".unavailable"));
            }
            return Component.translatable((String)(key + ".tooltip")).append("\n").append((Component)Component.literal((String)url).withStyle(ChatFormatting.GRAY));
        }

        private void openUrl(@Nullable String url) {
            if (url != null) {
                Util.getPlatform().openUri(url);
            }
        }

        public void render(@NotNull GuiGraphics gfx, int idx, int top, int left, int w, int h, int mx, int my, boolean hover, float pt) {
            int buttonsEndX;
            Font font = ((ModListWidget)ModListWidget.this).minecraft.font;
            int scrollbarX = ModListWidget.this.getScrollbarPosition();
            int y = top + 2;
            boolean hideConfig = TidyModsConfig.hideConfigButtons();
            int issuesX = scrollbarX - 30;
            this.issuesBtn.setPosition(issuesX, y);
            this.issuesBtn.render(gfx, mx, my, pt);
            int webX = issuesX - 22;
            this.webBtn.setPosition(webX, y);
            this.webBtn.render(gfx, mx, my, pt);
            if (hideConfig) {
                buttonsEndX = webX;
            } else {
                int configX = webX - 22;
                this.configBtn.setPosition(configX, y);
                this.configBtn.render(gfx, mx, my, pt);
                buttonsEndX = configX;
            }
            this.renderIcon(gfx, left, top + (h - 16) / 2);
            int textX = left + 24;
            int textY = top + h / 2 - 4;
            int maxWidth = buttonsEndX - textX - 8;
            FormattedCharSequence text = this.buildDisplayText(maxWidth, font).getVisualOrderText();
            gfx.drawString(font, text, textX, textY, 0xFFFFFF);
            if (hover && mx < buttonsEndX - 4 && !this.isOverButton(mx, my)) {
                this.renderTooltip(gfx, mx, my);
            }
        }

        private boolean isOverButton(int mx, int my) {
            if (TidyModsConfig.hideConfigButtons()) {
                return this.webBtn.isMouseOver((double)mx, (double)my) || this.issuesBtn.isMouseOver((double)mx, (double)my);
            }
            return this.configBtn.isMouseOver((double)mx, (double)my) || this.webBtn.isMouseOver((double)mx, (double)my) || this.issuesBtn.isMouseOver((double)mx, (double)my);
        }

        private void renderTooltip(GuiGraphics gfx, int mx, int my) {
            String license;
            String description;
            String authors;
            MutableComponent title = Component.literal((String)this.mod.displayName()).withStyle(new ChatFormatting[]{ChatFormatting.BOLD, ChatFormatting.WHITE});
            String version = this.mod.version();
            if (version != null && !version.isEmpty()) {
                title.append((Component)Component.literal((String)(" (" + version + ")")).withStyle(new ChatFormatting[]{ChatFormatting.BOLD, ChatFormatting.GRAY}));
            }
            ArrayList<FormattedCharSequence> lines = new ArrayList<FormattedCharSequence>(((ModListWidget)ModListWidget.this).minecraft.font.split((FormattedText)title, 200));
            if (TidyModsConfig.tooltipShowAuthors() && (authors = this.mod.authors()) != null && !authors.isEmpty()) {
                lines.add(FormattedCharSequence.EMPTY);
                MutableComponent authorsLine = Component.translatable((String)"tidymods.gui.tooltip.authors").withStyle(ChatFormatting.GRAY).append((Component)Component.literal((String)": ").withStyle(ChatFormatting.GRAY)).append((Component)Component.literal((String)authors).withStyle(ChatFormatting.WHITE));
                lines.addAll(((ModListWidget)ModListWidget.this).minecraft.font.split((FormattedText)authorsLine, 200));
            }
            if (TidyModsConfig.tooltipShowDescription() && (description = this.getDescription()) != null && !description.isBlank()) {
                lines.add(FormattedCharSequence.EMPTY);
                lines.addAll(((ModListWidget)ModListWidget.this).minecraft.font.split((FormattedText)Component.literal((String)description).withStyle(ChatFormatting.GRAY), 200));
            }
            if (TidyModsConfig.tooltipShowLicense() && (license = this.mod.license()) != null && !license.isEmpty()) {
                lines.add(FormattedCharSequence.EMPTY);
                MutableComponent licenseLine = Component.translatable((String)"tidymods.gui.tooltip.license").withStyle(ChatFormatting.GRAY).append((Component)Component.literal((String)": ").withStyle(ChatFormatting.GRAY)).append((Component)Component.literal((String)license).withStyle(ChatFormatting.WHITE));
                lines.addAll(((ModListWidget)ModListWidget.this).minecraft.font.split((FormattedText)licenseLine, 200));
            }
            if (!lines.isEmpty()) {
                gfx.renderTooltip(((ModListWidget)ModListWidget.this).minecraft.font, lines, mx, my);
            }
        }

        @Nullable
        private String getDescription() {
            String key = "tidymods.description." + this.mod.modId();
            if (I18n.exists((String)key)) {
                return I18n.get((String)key, (Object[])new Object[0]);
            }
            return this.mod.description();
        }

        private Component buildDisplayText(int maxWidth, Font font) {
            String name;
            String string = name = TidyModsConfig.showModIds() ? this.mod.modId() : this.mod.displayName();
            if (name == null || name.isEmpty()) {
                name = this.mod.modId();
            }
            boolean showVersion = TidyModsConfig.entryShowVersion();
            boolean showAuthors = TidyModsConfig.entryShowAuthors();
            String version = showVersion ? this.mod.version() : null;
            String authors = showAuthors ? this.mod.authors() : null;
            MutableComponent full = Component.empty().append((Component)Component.literal((String)name).withStyle(ChatFormatting.WHITE));
            if (version != null && !version.isEmpty()) {
                full.append((Component)Component.literal((String)(" (" + version + ")")).withStyle(ChatFormatting.GRAY));
            }
            if (authors != null && !authors.isEmpty()) {
                full.append((Component)Component.translatable((String)"tidymods.gui.by").withStyle(ChatFormatting.DARK_GRAY));
                full.append((Component)Component.literal((String)authors).withStyle(ChatFormatting.GRAY));
            }
            if (font.width((FormattedText)full) <= maxWidth) {
                return full;
            }
            return this.truncateText(name, version, authors, maxWidth, font);
        }

        private Component truncateText(String name, @Nullable String version, @Nullable String authors, int maxWidth, Font font) {
            MutableComponent withVersion;
            MutableComponent truncated = Component.empty().append((Component)Component.literal((String)name).withStyle(ChatFormatting.WHITE));
            if (version != null && !version.isEmpty() && font.width((FormattedText)(withVersion = truncated.copy().append((Component)Component.literal((String)(" (" + version + ")")).withStyle(ChatFormatting.GRAY)))) + font.width("...") <= maxWidth) {
                MutableComponent withAuthors;
                truncated = withVersion;
                if (authors != null && !authors.isEmpty() && font.width((FormattedText)(withAuthors = truncated.copy().append((Component)Component.translatable((String)"tidymods.gui.by").withStyle(ChatFormatting.DARK_GRAY)).append((Component)Component.literal((String)authors).withStyle(ChatFormatting.GRAY)))) <= maxWidth) {
                    return withAuthors;
                }
            }
            if (font.width((FormattedText)truncated) + font.width("...") > maxWidth) {
                String cut = font.plainSubstrByWidth(name, maxWidth - font.width("..."));
                return Component.literal((String)(cut + "...")).withStyle(ChatFormatting.WHITE);
            }
            return truncated.append((Component)Component.literal((String)"...").withStyle(ChatFormatting.GRAY));
        }

        private void renderIcon(GuiGraphics gfx, int x, int y) {
            if (TidyModsConfig.useCategoryIcons()) {
                ResourceLocation categoryIcon = TidyModsConfig.categoryIcon(this.category);
                if (categoryIcon == null) {
                    categoryIcon = TidyModsConfig.categoryIcon("uncategorized");
                }
                if (categoryIcon != null) {
                    this.blitIcon(gfx, categoryIcon, x, y, 16, 16);
                    return;
                }
            }
            ModListWidget.this.cacheTexture(this.mod);
            TextureInfo info = TEXTURE_CACHE.get(this.mod.modId());
            if (info != null) {
                this.blitIcon(gfx, info.loc, x, y, info.w, info.h);
                return;
            }
            ResourceLocation defaultIcon = TidyModsConfig.defaultModIcon();
            if (defaultIcon != null) {
                this.blitIcon(gfx, defaultIcon, x, y, 16, 16);
            }
        }

        private void blitIcon(GuiGraphics gfx, ResourceLocation loc, int x, int y, int w, int h) {
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            RenderSystem.enableBlend();
            gfx.blit(loc, x, y, 16, 16, 0.0f, 0.0f, w, h, w, h);
            RenderSystem.disableBlend();
        }

        @NotNull
        public List<? extends GuiEventListener> children() {
            if (TidyModsConfig.hideConfigButtons()) {
                return ImmutableList.of((Object)this.webBtn, (Object)this.issuesBtn);
            }
            return ImmutableList.of((Object)this.configBtn, (Object)this.webBtn, (Object)this.issuesBtn);
        }

        @NotNull
        public List<? extends NarratableEntry> narratables() {
            if (TidyModsConfig.hideConfigButtons()) {
                return ImmutableList.of((Object)this.webBtn, (Object)this.issuesBtn);
            }
            return ImmutableList.of((Object)this.configBtn, (Object)this.webBtn, (Object)this.issuesBtn);
        }
    }

    private record ParsedFilter(char type, String value) {
    }

    private record TextureInfo(ResourceLocation loc, int w, int h) {
    }

    public static abstract class Entry
    extends ContainerObjectSelectionList.Entry<Entry> {
    }
}

