/*
 * Decompiled with CFR 0.152.
 */
package net.aaavein.tidymods.client.gui;

import java.lang.invoke.CallSite;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import net.aaavein.tidymods.client.ModDataManager;
import net.aaavein.tidymods.client.gui.ModListWidget;
import net.aaavein.tidymods.client.gui.widget.AutoCompleteEditBox;
import net.aaavein.tidymods.config.TidyModsConfig;
import net.aaavein.tidymods.data.ModData;
import net.minecraft.Util;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.layouts.HeaderAndFooterLayout;
import net.minecraft.client.gui.layouts.LayoutElement;
import net.minecraft.client.gui.layouts.LinearLayout;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.neoforged.fml.loading.FMLPaths;
import org.jetbrains.annotations.NotNull;

public class ModListScreen
extends Screen {
    private static final Component TITLE = Component.translatable((String)"tidymods.gui.title");
    private static final Component SEARCH_HINT = Component.translatable((String)"tidymods.gui.search.hint").withStyle(s -> s.withColor(0x888888));
    private static double savedScrollAmount = 0.0;
    private static String savedSearchQuery = "";
    private final Screen parent;
    private final HeaderAndFooterLayout layout = new HeaderAndFooterLayout((Screen)this, 48, 33);
    private final ConfigSnapshot configSnapshot = new ConfigSnapshot();
    private AutoCompleteEditBox searchBox;
    private ModListWidget list;
    private List<String> searchSuggestions;

    public ModListScreen(@NotNull Screen parent) {
        super(TITLE);
        this.parent = parent;
        this.configSnapshot.capture();
    }

    protected void init() {
        this.buildSearchSuggestions();
        this.searchBox = new AutoCompleteEditBox(this.font, this.width / 2 - 100, 22, 200, 20, (Component)Component.translatable((String)"tidymods.gui.search"), () -> this.searchSuggestions);
        this.searchBox.setHint(SEARCH_HINT);
        this.searchBox.setResponder(s -> {
            if (this.list != null) {
                this.list.filter((String)s);
            }
        });
        this.searchBox.setValue(savedSearchQuery);
        this.addWidget((GuiEventListener)this.searchBox);
        this.list = (ModListWidget)this.addRenderableWidget((GuiEventListener)new ModListWidget(this, Minecraft.getInstance()));
        this.list.filter(savedSearchQuery);
        this.list.setScrollAmount(savedScrollAmount);
        LinearLayout footer = (LinearLayout)this.layout.addToFooter((LayoutElement)LinearLayout.horizontal().spacing(8));
        footer.addChild((LayoutElement)Button.builder((Component)Component.translatable((String)"tidymods.gui.open_mods_folder"), b -> Util.getPlatform().openFile(FMLPaths.MODSDIR.get().toFile())).width(150).build());
        footer.addChild((LayoutElement)Button.builder((Component)CommonComponents.GUI_DONE, b -> this.onClose()).width(150).build());
        this.layout.visitWidgets(x$0 -> {
            AbstractWidget cfr_ignored_0 = (AbstractWidget)this.addRenderableWidget((GuiEventListener)x$0);
        });
        this.repositionElements();
    }

    private void buildSearchSuggestions() {
        HashSet<String> displayNames = new HashSet<String>();
        HashSet<String> modIds = new HashSet<String>();
        HashSet<String> categories = new HashSet<String>();
        HashSet<String> authors = new HashSet<String>();
        HashSet<Object> licenses = new HashSet<Object>();
        for (ModData mod : ModDataManager.all()) {
            Object license;
            if (TidyModsConfig.isHidden(mod.modId())) continue;
            displayNames.add(mod.displayName());
            modIds.add(mod.modId());
            categories.add(ModDataManager.category(mod.modId()));
            String authorString = mod.authors();
            if (authorString != null && !authorString.isBlank()) {
                for (String author : authorString.split(",")) {
                    String string = author.trim();
                    if (string.isEmpty()) continue;
                    authors.add(string);
                }
            }
            if ((license = mod.license()) == null || ((String)license).isBlank()) continue;
            licenses.add(license);
        }
        ArrayList nameSuggestions = new ArrayList(displayNames);
        nameSuggestions.sort(String.CASE_INSENSITIVE_ORDER);
        ArrayList<String> suggestions = new ArrayList<String>(nameSuggestions);
        ArrayList<CallSite> idSuggestions = new ArrayList<CallSite>();
        for (String modId : modIds) {
            idSuggestions.add((CallSite)((Object)("@" + modId)));
        }
        idSuggestions.sort(String.CASE_INSENSITIVE_ORDER);
        suggestions.addAll(idSuggestions);
        ArrayList<CallSite> categorySuggestions = new ArrayList<CallSite>();
        for (String category : categories) {
            categorySuggestions.add((CallSite)((Object)("#" + category)));
        }
        categorySuggestions.sort(String.CASE_INSENSITIVE_ORDER);
        suggestions.addAll(categorySuggestions);
        ArrayList<CallSite> authorSuggestions = new ArrayList<CallSite>();
        for (String author : authors) {
            authorSuggestions.add((CallSite)((Object)("!" + author)));
        }
        authorSuggestions.sort(String.CASE_INSENSITIVE_ORDER);
        suggestions.addAll(authorSuggestions);
        ArrayList<CallSite> licenseSuggestions = new ArrayList<CallSite>();
        for (String string : licenses) {
            licenseSuggestions.add((CallSite)((Object)("$" + string)));
        }
        licenseSuggestions.sort(String.CASE_INSENSITIVE_ORDER);
        suggestions.addAll(licenseSuggestions);
        this.searchSuggestions = suggestions;
    }

    protected void repositionElements() {
        this.layout.arrangeElements();
        if (this.list != null) {
            this.list.updateLayout(this.width, this.layout);
        }
        if (this.searchBox != null) {
            this.searchBox.setX(this.width / 2 - 100);
        }
    }

    protected void setInitialFocus() {
        this.setInitialFocus((GuiEventListener)this.searchBox);
    }

    public void onClose() {
        if (this.list != null) {
            savedScrollAmount = this.list.getScrollAmount();
        }
        if (this.searchBox != null) {
            savedSearchQuery = this.searchBox.getValue();
        }
        Minecraft.getInstance().setScreen(this.parent);
    }

    public void tick() {
        super.tick();
        if (this.configSnapshot.hasChanged()) {
            ModDataManager.reloadCategories();
            this.buildSearchSuggestions();
            if (this.list != null) {
                this.list.refresh();
            }
            this.configSnapshot.capture();
        }
    }

    public void render(@NotNull GuiGraphics gfx, int mx, int my, float pt) {
        super.render(gfx, mx, my, pt);
        gfx.drawCenteredString(this.font, this.buildTitle(), this.width / 2, 8, 0xFFFFFF);
        this.searchBox.render(gfx, mx, my, pt);
    }

    private Component buildTitle() {
        if (TidyModsConfig.showModCount() && this.list != null) {
            return Component.translatable((String)"tidymods.gui.title.count", (Object[])new Object[]{this.list.getModCount()});
        }
        return TITLE;
    }

    private static class ConfigSnapshot {
        private boolean showIds;
        private boolean showCount;
        private boolean configsOnly;
        private boolean categoryIcons;
        private boolean librariesAtBottom;
        private boolean hideConfigButtons;
        private boolean entryShowVersion;
        private boolean entryShowAuthors;
        private boolean tooltipShowAuthors;
        private boolean tooltipShowDescription;
        private boolean tooltipShowLicense;
        private String defaultCategory;
        private int hiddenHash;
        private int overridesHash;

        private ConfigSnapshot() {
        }

        void capture() {
            this.showIds = TidyModsConfig.showModIds();
            this.showCount = TidyModsConfig.showModCount();
            this.configsOnly = TidyModsConfig.configsOnly();
            this.categoryIcons = TidyModsConfig.useCategoryIcons();
            this.librariesAtBottom = TidyModsConfig.librariesAtBottom();
            this.hideConfigButtons = TidyModsConfig.hideConfigButtons();
            this.entryShowVersion = TidyModsConfig.entryShowVersion();
            this.entryShowAuthors = TidyModsConfig.entryShowAuthors();
            this.tooltipShowAuthors = TidyModsConfig.tooltipShowAuthors();
            this.tooltipShowDescription = TidyModsConfig.tooltipShowDescription();
            this.tooltipShowLicense = TidyModsConfig.tooltipShowLicense();
            this.defaultCategory = TidyModsConfig.defaultCategory();
            this.hiddenHash = TidyModsConfig.hiddenMods().hashCode();
            this.overridesHash = TidyModsConfig.categoryOverrides().hashCode();
        }

        boolean hasChanged() {
            return this.showIds != TidyModsConfig.showModIds() || this.showCount != TidyModsConfig.showModCount() || this.configsOnly != TidyModsConfig.configsOnly() || this.categoryIcons != TidyModsConfig.useCategoryIcons() || this.librariesAtBottom != TidyModsConfig.librariesAtBottom() || this.hideConfigButtons != TidyModsConfig.hideConfigButtons() || this.entryShowVersion != TidyModsConfig.entryShowVersion() || this.entryShowAuthors != TidyModsConfig.entryShowAuthors() || this.tooltipShowAuthors != TidyModsConfig.tooltipShowAuthors() || this.tooltipShowDescription != TidyModsConfig.tooltipShowDescription() || this.tooltipShowLicense != TidyModsConfig.tooltipShowLicense() || !this.defaultCategory.equals(TidyModsConfig.defaultCategory()) || this.hiddenHash != TidyModsConfig.hiddenMods().hashCode() || this.overridesHash != TidyModsConfig.categoryOverrides().hashCode();
        }
    }
}

