/*
 * Decompiled with CFR 0.152.
 */
package net.aaavein.tidymods.client.event;

import net.aaavein.tidymods.client.gui.ModListScreen;
import net.aaavein.tidymods.config.TidyModsConfig;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.PauseScreen;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.TitleScreen;
import net.minecraft.network.chat.Component;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.client.event.ScreenEvent;

@EventBusSubscriber(modid="tidymods", value={Dist.CLIENT})
public final class ScreenEvents {
    private static final Component MODS_TEXT = Component.translatable((String)"fml.menu.mods");
    private static final Component REALMS_TEXT = Component.translatable((String)"menu.online");
    private static final int BUTTON_SPACING = 4;
    private static final int BOTTOM_BUTTON_MARGIN = 50;

    private ScreenEvents() {
    }

    @SubscribeEvent
    public static void onScreenInit(ScreenEvent.Init.Post event) {
        Screen screen = event.getScreen();
        if (screen instanceof TitleScreen) {
            if (TidyModsConfig.hideRealmsButton()) {
                ScreenEvents.replaceRealmsWithMods(screen, event);
            } else {
                ScreenEvents.replaceModsButton(screen, event);
            }
        } else if (screen instanceof PauseScreen) {
            ScreenEvents.replaceModsButton(screen, event);
        }
    }

    private static void replaceModsButton(Screen screen, ScreenEvent.Init.Post event) {
        String targetText = MODS_TEXT.getString();
        for (GuiEventListener listener : event.getListenersList()) {
            Button btn;
            if (!(listener instanceof Button) || !(btn = (Button)listener).getMessage().getString().equals(targetText)) continue;
            event.removeListener((GuiEventListener)btn);
            event.addListener((GuiEventListener)Button.builder((Component)MODS_TEXT, b -> ScreenEvents.openModList(screen)).bounds(btn.getX(), btn.getY(), btn.getWidth(), btn.getHeight()).build());
            return;
        }
    }

    private static void replaceRealmsWithMods(Screen screen, ScreenEvent.Init.Post event) {
        String realmsText = REALMS_TEXT.getString();
        String modsText = MODS_TEXT.getString();
        Button realmsBtn = null;
        Button modsBtn = null;
        for (GuiEventListener listener : event.getListenersList()) {
            if (!(listener instanceof Button)) continue;
            Button btn = (Button)listener;
            String text = btn.getMessage().getString();
            if (text.equals(realmsText)) {
                realmsBtn = btn;
                continue;
            }
            if (!text.equals(modsText)) continue;
            modsBtn = btn;
        }
        if (realmsBtn == null) {
            ScreenEvents.replaceModsButton(screen, event);
            return;
        }
        int realmsX = realmsBtn.getX();
        int realmsY = realmsBtn.getY();
        int realmsW = realmsBtn.getWidth();
        int realmsH = realmsBtn.getHeight();
        event.removeListener(realmsBtn);
        int newModsY = realmsY;
        if (modsBtn != null) {
            int modsY = modsBtn.getY();
            event.removeListener((GuiEventListener)modsBtn);
            if (modsY != realmsY) {
                int halfRowHeight = (realmsH + 4) / 2;
                int bottomThreshold = screen.height - 50;
                for (GuiEventListener listener : event.getListenersList()) {
                    Button btn;
                    int btnY;
                    if (!(listener instanceof Button) || (btnY = (btn = (Button)listener).getY()) > bottomThreshold) continue;
                    if (btnY < modsY) {
                        btn.setY(btnY + halfRowHeight);
                        continue;
                    }
                    if (btnY <= modsY) continue;
                    btn.setY(btnY - halfRowHeight);
                }
                newModsY = realmsY < modsY ? realmsY + halfRowHeight : realmsY - halfRowHeight;
            }
        }
        event.addListener((GuiEventListener)Button.builder((Component)MODS_TEXT, b -> ScreenEvents.openModList(screen)).bounds(realmsX, newModsY, realmsW, realmsH).build());
    }

    private static void openModList(Screen parent) {
        Minecraft.getInstance().setScreen((Screen)new ModListScreen(parent));
    }
}

