/*
 * Decompiled with CFR 0.152.
 */
package net.aaavein.tidymods.client;

import com.mojang.blaze3d.platform.NativeImage;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import net.aaavein.tidymods.TidyMods;
import net.aaavein.tidymods.client.BuiltInCategories;
import net.aaavein.tidymods.config.TidyModsConfig;
import net.aaavein.tidymods.data.MinecraftData;
import net.aaavein.tidymods.data.ModData;
import net.aaavein.tidymods.data.NeoForgeData;
import net.neoforged.fml.ModList;
import net.neoforged.neoforgespi.language.IModInfo;

public final class ModDataManager {
    private static final Map<String, ModData> MODS = new HashMap<String, ModData>();
    private static final Map<String, String> CATEGORY_OVERRIDES = new HashMap<String, String>();
    private static boolean modsLoaded = false;
    private static boolean categoriesLoaded = false;

    private ModDataManager() {
    }

    public static Collection<ModData> all() {
        ModDataManager.loadMods();
        return MODS.values();
    }

    public static String category(String modId) {
        String declared;
        ModDataManager.loadMods();
        ModDataManager.loadCategories();
        String id = modId.toLowerCase();
        String override = CATEGORY_OVERRIDES.get(id);
        if (override != null) {
            return override;
        }
        ModData mod = MODS.get(id);
        if (mod != null && (declared = mod.declaredCategory()) != null && !declared.isBlank()) {
            return declared.toLowerCase();
        }
        String builtin = BuiltInCategories.get(id);
        if (builtin != null) {
            return builtin;
        }
        return TidyModsConfig.defaultCategory();
    }

    public static boolean hasCategory(String modId) {
        String declared;
        ModDataManager.loadMods();
        ModDataManager.loadCategories();
        String id = modId.toLowerCase();
        if (CATEGORY_OVERRIDES.containsKey(id)) {
            return true;
        }
        ModData mod = MODS.get(id);
        if (mod != null && (declared = mod.declaredCategory()) != null && !declared.isBlank()) {
            return true;
        }
        return BuiltInCategories.has(id);
    }

    public static List<ModData> uncategorized() {
        ModDataManager.loadMods();
        ModDataManager.loadCategories();
        ArrayList<ModData> result = new ArrayList<ModData>();
        for (ModData mod : MODS.values()) {
            if (ModDataManager.hasCategory(mod.modId())) continue;
            result.add(mod);
        }
        return result;
    }

    public static void reloadCategories() {
        categoriesLoaded = false;
        ModDataManager.loadCategories();
    }

    public static void loadImage(String modId, String path, Consumer<NativeImage> callback) {
        block8: {
            try {
                Path file = ModList.get().getModFileById(modId).getFile().findResource(new String[]{path});
                if (!Files.exists(file, new LinkOption[0])) break block8;
                try (InputStream in = Files.newInputStream(file, new OpenOption[0]);){
                    callback.accept(NativeImage.read((InputStream)in));
                }
            }
            catch (Exception e) {
                TidyMods.LOG.debug("Failed to load image {} from {}", (Object)path, (Object)modId);
            }
        }
    }

    private static void loadMods() {
        if (modsLoaded) {
            return;
        }
        modsLoaded = true;
        ModList.get().getMods().forEach(info -> {
            String id = info.getModId().toLowerCase();
            MODS.put(id, new NeoForgeData((IModInfo)info));
        });
        MODS.put("minecraft", new MinecraftData());
    }

    private static void loadCategories() {
        if (categoriesLoaded) {
            return;
        }
        categoriesLoaded = true;
        CATEGORY_OVERRIDES.clear();
        for (String string : TidyModsConfig.categoryOverrides()) {
            String[] parts = string.split(";", 2);
            if (parts.length != 2) continue;
            String id = parts[0].trim().toLowerCase();
            String cat = parts[1].trim().toLowerCase();
            if (id.isEmpty() || cat.isEmpty()) continue;
            CATEGORY_OVERRIDES.put(id, cat);
        }
    }
}

