/*
 * Decompiled with CFR 0.152.
 */
package net.aaavein.tidymods.client;

import java.util.HashMap;
import java.util.Map;

public final class BuiltInCategories {
    private static final Map<String, String> ASSIGNMENTS = new HashMap<String, String>();

    private BuiltInCategories() {
    }

    public static void agriculture(String ... modIds) {
        BuiltInCategories.assign("agriculture", modIds);
    }

    public static void building(String ... modIds) {
        BuiltInCategories.assign("building", modIds);
    }

    public static void equipment(String ... modIds) {
        BuiltInCategories.assign("equipment", modIds);
    }

    public static void functional(String ... modIds) {
        BuiltInCategories.assign("functional", modIds);
    }

    public static void library(String ... modIds) {
        BuiltInCategories.assign("library", modIds);
    }

    public static void magic(String ... modIds) {
        BuiltInCategories.assign("magic", modIds);
    }

    public static void misc(String ... modIds) {
        BuiltInCategories.assign("misc", modIds);
    }

    public static void mobs(String ... modIds) {
        BuiltInCategories.assign("mobs", modIds);
    }

    public static void storage(String ... modIds) {
        BuiltInCategories.assign("storage", modIds);
    }

    public static void system(String ... modIds) {
        BuiltInCategories.assign("system", modIds);
    }

    public static void technology(String ... modIds) {
        BuiltInCategories.assign("technology", modIds);
    }

    public static void utility(String ... modIds) {
        BuiltInCategories.assign("utility", modIds);
    }

    public static void worldgen(String ... modIds) {
        BuiltInCategories.assign("worldgen", modIds);
    }

    private static void assign(String category, String ... modIds) {
        for (String id : modIds) {
            ASSIGNMENTS.put(id.toLowerCase(), category);
        }
    }

    public static String get(String modId) {
        return ASSIGNMENTS.get(modId.toLowerCase());
    }

    public static boolean has(String modId) {
        return ASSIGNMENTS.containsKey(modId.toLowerCase());
    }

    static {
        BuiltInCategories.agriculture("berry_good", "neapolitan", "abnormals_delight", "aquaculture", "starcatcher", "vinery", "herbalbrews", "rusticdelight", "arsdelight", "dumplings_delight", "farm_and_charm", "animal_feeding_trough", "fruitsdelight", "ends_delight", "brewery", "beachparty", "moredelight", "barbequesdelight", "animal_pen", "mynethersdelight", "twilightdelight", "oceansdelight", "endersdelight", "jags", "bonsaitrees4", "botanypots", "botanypotsmystical", "botanytrees", "chicken_roost", "cookingforblockheads", "create_central_kitchen", "farmersdelight", "farmingforblockheads", "herbsandharvest", "mysticalagradditions", "mysticalagriculture", "pamhc2crops", "pamhc2foodcore", "pamhc2foodextended", "pamhc2trees", "randombonemealflowers", "squatgrow", "sushigocrafting", "treetap");
        BuiltInCategories.building("clayworks", "woodworks", "blahaj", "arts_and_crafts", "trofers", "mcwpaintings", "plushie_buddies", "curious_armor_stands", "displaydelight", "woodwevegot", "aurelj_paintings", "diagonalwalls", "another_furniture", "diagonalfences", "stoneworks", "additional_lights", "antiblocksrechiseled", "bambooeverything", "bellsandwhistles", "betterblockz", "bibliocraft", "bibliowoods", "byzantine", "chipped", "chisel", "chromacarvings", "cloudglass", "connectedglass", "crystalix", "domum_ornamentum", "dyenamics", "dyenamicsandfriends", "everythingcopper", "factory_blocks", "framedblocks", "ftbunearthed", "glassential", "handcrafted", "luminax", "mcwbridges", "mcwdoors", "mcwfences", "mcwfurnitures", "mcwholidays", "mcwlights", "mcwpaths", "mcwroofs", "mcwstairs", "mcwtrpdoors", "mcwwindows", "merrymaking", "rechiseled", "rechiseled_chipped", "rechiseledcreate", "refurbished_furniture", "simplylight", "stylecolonies", "xtonesreworked");
        BuiltInCategories.equipment("bettercombat", "hazennstuff", "mekaweapons", "usefulhats", "charmofundying", "moretotems", "elytraslot", "transmog", "aether_protect_your_moa", "advancednetherite", "aether_treasure_reforging", "rarcompat", "allthemodium", "artifacts", "bhc", "sgearmetalworks", "silentgear", "silentgems", "simplyswords");
        BuiltInCategories.functional("boatload", "rubinated_nether", "obsidianboat", "immersive_aircraft", "extrasponges", "exposure", "exposure_polaroid", "sereneseasons", "rewithered", "aether_enhanced_extinguishing", "vanillabackport", "xpbook", "tradingpost", "magnumtorch", "yigd", "barteringstation", "repeatable_trial_vaults", "gag", "ftbultimine", "dummmmmmy", "akashictome", "toolbelt", "utilityvest", "justhammers", "morphtool", "omnitools", "beer", "simplemagnets", "underlay", "solcarrot", "amendments", "comforts", "constructionstick", "elevatorid", "entangled", "explorerscompass", "fuelgoeshere", "lootr", "measurements", "naturescompass", "sawmill", "shrink", "simpletomb", "supplementaries", "torchmaster", "trashcans", "waystones", "crafting_on_a_stick", "fastitemframes", "fireproofboats", "jumpboat", "jumpoverfences", "accelerateddecay", "woodenshears", "chancecubes", "ftbezcrystals", "ftbstuff", "magic_coins");
        BuiltInCategories.library("tiny_config", "mixed_litter", "blueprint", "polytone", "kirin", "pride", "l2harvester", "emiprofessions", "emi_enchanting", "emi_ores", "emi_loot", "emiffect", "irons_spells_js", "mekagenjei", "jei", "jei_mekanism_multiblocks", "ftbjeiextras", "ae2jeiintegration", "capejs", "extra_mod_integrations_pneumaticcraft", "doapi", "seasonal_lets_do", "mekajadeupgrade", "bendylib", "libtooltips", "extra_mod_integrations", "cfm_wap", "extra_mod_integrations_farmers_delight", "lootintegrations_structory", "extra_apoth_compat", "cerbons_api", "extra_mod_integrations_irons_spellbooks", "emi_letsdo_compat", "puffish_attributes", "letsdocompat", "libipn", "creativecore", "phantoms_utilities", "lootintegrations_dungeoncrawl", "nirvana_lib", "lootintegration_townsandtowers", "extra_mod_integrations_rechiseled", "voicechat_api", "lootintegrations_hopo", "yumi_mc_core", "pufferfish_unofficial_additions", "jinxedlib", "keybindjs", "extra_mod_integrations_reliquary", "gtbcs_spell_lib", "lambdynlights_runtime", "extra_mod_integrations_actually_additions", "terraform", "ftbxaerocompat", "spruceui", "lootintegrations_cataclysm", "extra_mod_integrations_core", "craftoria_core", "extra_mod_integrations_chipped", "mr_farmers_cuttingohthebiomeswevegone", "immersivemessages", "limitlesscontainers", "blended_compat", "mpuc_lavendermd", "modmenu", "chunkactivitytracker", "diagonalblocks", "accessorify", "connectorextras_kubejs_bridge", "fabric_rendering_fluids_v1", "fabric_command_api_v2", "connectorextras_rei_bridge", "biolith", "fabric_client_tags_api_v1", "fabric_screen_handler_api_v1", "epherolib", "midnightlib", "lootintegration_wda", "lootintegrations_moog", "lootintegrations_yungs", "lootintegrations_formations", "lootintegrations_bygonepillage", "fabric_block_api_v1", "fabric_resource_conditions_api_v1", "forgeconfigapiport", "fabric_registry_sync_v0", "cclayer", "fabric_object_builder_api_v1", "fabric_message_api_v1", "fabric_item_api_v1", "sodiumoptionsapi", "connector", "fabric_api", "connectorextras_modmenu_bridge", "fabric_api_lookup_api_v1", "seasonal_integration", "fabric_key_binding_api_v1", "fabric_transfer_api_v1", "connectorextras_pehkui_bridge", "fabric_resource_loader_v0", "txnilib", "azurelib", "connectorextras_energy_bridge", "mixson", "fabric_blockrenderlayer_v1", "fabric_gametest_api_v1", "fabric_biome_api_v1", "forgified_fabric_api", "fabric_convention_tags_v1", "fabric_convention_tags_v2", "fabric_screen_api_v1", "connectorextras_terrablender_bridge", "fabric_game_rule_api_v1", "fabric_entity_events_v1", "sodiumoptionsmodcompat", "fabric_model_loading_api_v1", "fabric_rendering_v1", "fabric_renderer_indigo", "glitchcore", "jamlib", "connectorextras_jei_bridge", "aeroblender", "fabric_item_group_api_v1", "l2core", "fabric_recipe_api_v1", "fabric_sound_api_v1", "configurable", "tclayer", "fabric_data_attachment_api_v1", "neoforgedatapackextensions", "fabric_content_registries_v0", "villagerapi", "mixintracereforged", "fabric_loot_api_v2", "connectorextras", "fabric_loot_api_v3", "fabric_networking_api_v1", "fabric_lifecycle_events_v1", "accessories_compat_layer", "extensibleenums", "fabric_transitive_access_wideners_v1", "platform", "connectorextras_emi_bridge", "fabric_data_generation_api_v1", "fabric_events_interaction_v0", "almanac", "additionalentityattributes", "custommachinery", "ftbxmodcompat", "endercore", "databank", "refinedstorage_curios_integration", "refinedstorage_jei_integration", "fabric_particles_v1", "custommachineryars", "custommachinerycreate", "custommachinerymekanism", "aaron", "accessories", "ae2addonlib", "ae2wtlib_api", "ali", "apothic_compats", "architectury", "athena", "atlas_api", "baguettelib", "balm", "blockui", "bookshelf", "brandonscore", "caelus", "carbonconfig", "clavis", "cloth_config", "codechickenlib", "cognition", "collective", "common_storage_lib_data", "commoncapabilities", "commonnetworking", "conditional_mixin", "corgilib", "coroutil", "cristellib", "ctm", "cucumber", "cumulus_menus", "cupboard", "curios", "cyclopscore", "edivadlib", "entityjs", "expandability", "experiencelib", "fabric_api_base", "fabric_block_view_api_v2", "fabric_renderer_api_v1", "fabric_rendering_data_attachment_v1", "fdlib", "flywheel", "framework", "ftbauxilium", "ftblibrary", "ftbmaterials", "ftbpmapi", "fzzy_config", "gaze", "geckolib", "guideme", "iceberg", "kiwi", "konkrete", "kotlinforforge", "kubejs", "kubejs_actuallyadditions", "kubejs_curios", "kubejs_enderio", "kubejs_mekanism", "kubejspowah", "kubejstweaks", "kubeutils", "kuma_api", "lambdynlights_api", "lionfishapi", "lithostitched", "lodestone", "lootjs", "lychee", "mcjtylib", "mecrh", "mekanismcurios", "modder_name_lib", "modonomicon", "monolib", "moonlight", "morejs", "mru", "nitrogen_internals", "octolib", "omegaconfig", "owo", "patchouli", "placebo", "playeranimator", "polylib", "ponder", "ponderjs", "prickle", "productivelib", "puzzleslib", "reliquified_ars_nouveau", "reliquified_lenders_cataclysm", "reliquified_twilight_forest", "renderjs", "replication_matter_overflow", "resourcefulconfig", "resourcefullib", "resourcefullibkt", "rhino", "searchables", "shield_api", "silentlib", "smartbrainlib", "sophisticatedcore", "spectrelib", "supermartijn642configlib", "supermartijn642corelib", "terrablender", "tesseract_api", "titanium", "toolkit", "valhelsia_core", "yet_another_config_lib_v3", "yungsapi", "zerocore", "cryonicconfig", "transition", "cobweb", "theurgy_kubejs", "occultism_kubejs", "fusion", "journeymap_api", "nuggets", "melody", "trender", "deimos", "glodium", "grandpower", "jupiter", "uranus", "olympus", "prism", "sauce", "minecraft", "neoforge", "ohthetreesyoullgrow", "infiniverse");
        BuiltInCategories.magic("allurement", "cataclysm_spellbooks", "irons_spells_dynamic_skilltree", "aces_spell_utils", "gametechbcs_spellbooks", "thaumon", "allthearcanistgear", "allthewizardgear", "apotheosis", "apothic_attributes", "apothic_enchanting", "apothic_spawners", "ars_additions", "ars_affinity", "ars_controle", "ars_creo", "ars_elemancy", "ars_elemental", "ars_hex", "ars_nouveau", "ars_ocultas", "ars_technica", "disenchanting_table", "evilcraft", "evilcraftcompat", "forbidden_arcanus", "gateways", "irons_apothic", "irons_jewelry", "irons_spellbooks", "mahoutsukai", "malum", "naturesaura", "not_enough_glyphs", "occultism", "potionsmaster", "projecte", "psi", "relics", "reliquary", "rootsclassic", "starbunclemania", "theurgy", "tiab", "tombstone");
        BuiltInCategories.misc("ftbpromoter", "bhmenu", "rgp_client", "packanalytics");
        BuiltInCategories.mobs("pet_cemetery", "incubation", "buzzier_bees", "respawninganimals", "duckling", "reanimal", "bosses_of_mass_destruction", "guardvillagers", "ribbits", "wstweaks", "villagernames", "sussysniffers", "catjammies", "moredragoneggs", "hardenedarmadillos", "heyberryshutup", "skeletonaifix", "dolphin_fix", "golem_spawn_fix", "neobeefix", "horsebreedingfix", "revampedwolf", "morevillagers", "goblintraders", "hybrid_aquatic", "dmr", "illagerinvasion", "takesapillage", "raided", "friendsandfoes", "mowziesmobs", "zombieimprovements", "smarterfarmers", "piglinproliferation", "petrock", "busy_villagers", "cataclysm", "colorfulallays", "creeperoverhaul", "endermanoverhaul", "fdbosses", "ftboceanmobs", "iceandfire", "irons_apothic_invaders", "livingthings", "moofluids", "variantsandventures");
        BuiltInCategories.storage("tankstorage", "morefunctionalstorage", "bankstorage", "netherchested", "toms_storage", "backpacked", "sophisticatedbackpackscreateintegration", "refinedstorage_mekanism_integration", "sophisticatedstoragecreateintegration", "allthecompressed", "dimstorage", "extradisks", "extrastorage", "ironchest", "metalbarrels", "pocketstorage", "sophisticatedbackpacks", "sophisticatedstorage", "sophisticatedstorageinmotion", "stonechest", "storagedelight", "appex", "createenderstorage", "refinedstorage", "refinedstorage_quartz_arsenal", "functionalstorage", "enderstorage", "rftoolsstorage");
        BuiltInCategories.system("debugify", "immersive_optimization", "noisium", "despawntweaks", "particle_core", "vanillin", "cerulean", "c2me_fixes_general_threading_issues", "krypton_fnp", "c2me_threading_lighting", "lithium", "fastasyncworldsave", "sodium", "c2me_opts_worldgen_vanilla", "c2me_opts_scheduling", "smoothchunk", "fastpaintings", "tfthreadsafetyaddon", "gpumemleakfix", "scalablelux", "c2me_fixes_worldgen_vanilla_bugs", "fastipping", "longnbtkiller", "c2me_rewrites_chunkio", "badoptimizations", "c2me_fixes_worldgen_threading_issues", "c2me_rewrites_chunk_serializer", "featurerecycler", "c2me", "c2me_base", "structure_layout_optimizer", "c2me_opts_dfc", "sodiumleafculling", "neruina", "c2me_rewrites_chunk_system", "logbegone", "c2me_opts_natives_math", "betterbiomereblend", "redirected", "c2me_opts_math", "hrtffix", "c2me_fixes_chunkio_threading_issues", "c2me_client_uncapvd", "c2me_opts_allocs", "alternate_current", "c2me_server_utils", "c2me_opts_worldgen_general", "c2me_opts_chunkio", "packetfixer", "c2me_notickvd", "chunksending", "does_it_tick", "nerb", "entityguardian", "nanny", "yeetusexperimentus", "aiimprovements", "alltheleaks", "attributefix", "clumps", "connectivity", "embeddium", "entityculling", "fastbench", "fastfurnace", "fastsuite", "ferritecore", "flickerfix", "netherportalfix", "getittogetherdrops", "imfast", "immediatelyfast", "modelfix", "modernfix", "servercore", "bowinfinityfix", "disconnect_packet_fix", "randomenchantfix", "nondirectionaldamagetiltfix");
        BuiltInCategories.technology("createultimine", "cursedearth", "createfiltersanywhere", "modernindustrialrouters", "mechtrowel", "createcasing", "mekanism_extras", "pocketmachines", "createstockbridge", "bigger_ae2", "mi_tweaks", "moremekanismprocessing", "create_pattern_schematics", "autochefsdelight", "modularbees", "actuallyadditions", "advanced_ae", "advancedperipherals", "ae2", "ae2ct", "ae2importexportcard", "ae2netanalyser", "ae2wtlib", "aeinfinitybooster", "appflux", "appmek", "arseng", "bigreactors", "buildinggadgets2", "cabletiers", "charginggadgets", "cobblegengalore", "compactmachines", "computercraft", "create", "create_aquatic_ambitions", "create_dragons_plus", "create_enchantment_industry", "create_hypertube", "createaddition", "draconicevolution", "dysoncubeproject", "easy_villagers", "enderdrives", "enderio", "enderio_armory", "enderio_base", "enderio_conduits", "enderio_conduits_modded", "enderio_machines", "expandedae", "extended_industrialization", "extendedae", "fluxnetworks", "generatorgalore", "gmut", "hostilenetworks", "industrialforegoing", "industrialforegoingsouls", "industrialization_overdrive", "integratedcrafting", "integrateddynamics", "integrateddynamicscompat", "integratedscripting", "integratedterminals", "integratedterminalscompat", "integratedtunnels", "integratedtunnelscompat", "interdimensionalwirelesstransmitter", "ironfurnaces", "ironjetpacks", "itemcollectors", "justdirethings", "laserbridges", "laserio", "little_big_redstone", "megacells", "mekanism", "mekanismcovers", "mekanismgenerators", "mekanisticrouters", "mekanismtools", "mekmm", "merequester", "mffs", "minecolonies", "mininggadgets", "mob_grinding_utils", "modern_industrialization", "moderndynamics", "modularrouters", "morered", "moreredxcctcompat", "multipiston", "oritech", "pipez", "pneumaticcraft", "powah", "productivebees", "productivemetalworks", "productivetrees", "pylons", "quarryplus", "railcraft", "rangedpumps", "redstonepen", "refinedtypes", "rftoolsbase", "rftoolsbuilder", "rftoolspower", "rftoolsutility", "securitycraft", "sfm", "soulplied_energistics", "stevescarts", "structurize", "tempad", "universalgrid", "wirelesschargers", "xnet", "xycraft_core", "xycraft_machines", "xycraft_override", "xycraft_world", "mifa", "immersiveengineering", "immeng", "ae2things", "avaritia", "belts", "cable_facades", "classicpipes", "craftingstation", "create_connected", "create_shimmer", "createenchantablemachinery", "irregular_implements", "jumbofurnace", "justdynathings", "me_beam_former", "mekanism_lasers", "mekanism_unleashed", "more_immersive_wires", "occultengineering", "oritechthings", "pipe_connector", "rep_ae2_bridge", "replication", "replication_rs2_bridge", "routers", "rsinfinitybooster", "rsrequestify", "schematicenergistics", "simpleteleporters", "tesseract", "trenzalore", "xnetgases", "xp_synthesiser");
        BuiltInCategories.utility("tia", "firstperson", "darkness", "smoothskies", "cameraoverhaul", "betterclouds", "betterthirdperson", "colorfulsubtitles", "particlerain", "personality", "spiffyhud", "raised", "modernui", "smoothswapping", "nostalgic_tweaks", "presencefootsteps", "better_climbing", "immersiveui", "pinghud", "lighty", "clienttweaks", "mi_sound_addon", "emotecraft", "emi", "voicechat", "darkglint", "equipmentcompare", "ambientsounds", "moremousetweaks", "inventoryprofilesnext", "desiredservers", "perception", "travelerstitles", "chattoggle", "serverstarted", "lootbeams", "zume", "fancytoasts", "jadeaddons", "more_sounds", "showcaseitem", "stickit", "yukamibackpacktab", "xaeromaps_waystones", "lambdynlights", "seasonhud", "chatimpressiveanimation", "toomanyrecipeviewers", "waveycapes", "sounds", "puffish_skills", "lootintegrations", "luna_minecraft", "snowrealmagic", "betterworldloadingnf21", "better_client", "openpartiesandclaims", "questkilltask", "bedrockoid", "certain_questing_additions", "immersivelanterns", "rightclickharvest", "dyedflames", "noreportbutton", "clientcrafting", "iris_shader_folder", "highlighter", "reeses_sodium_options", "yungsmenutweaks", "fallingtree", "visualworkbench", "misctweaks", "foolproof", "bettergrass", "worldplaytime", "carryon", "entity_model_features", "entity_texture_features", "boatiview", "modpackupdatechecker", "cherishedworlds", "easymagic", "reset_controls_confirmation", "skinlayers3d", "citresewn", "particle_effects", "wakes", "easyanvils", "sodiumextras", "subtle_effects", "sound_physics_remastered", "clientsort", "chat_heads", "leavesbegone", "miningspeedtooltips", "veinmining", "doubledoors", "audioimprovements", "immersivetips", "deleteworldstotrash", "xaerominimap", "leavemybarsalone", "xaeroplus", "continuity", "biomemusic", "earlybedtime", "recipeessentials", "easydisenchanting", "kleeslabs", "xaeroworldmap", "sodiumdynamiclights", "pingwheel", "configured", "farsight_view", "immersivearmorhud", "cutthrough", "distraction_free_recipes", "serverbrowser", "modernworldcreation", "dsp", "ftbechoes", "cosmeticarmorreworked", "ftbpc", "advancementplaques", "allthetweaks", "almostunified", "appleskin", "ars_polymorphia", "ars_unification", "authme", "auroras", "bcc", "betteradvancements", "blueflame", "bridgingmod", "bwncr", "camol", "cleanswing", "colorfulhearts", "controlling", "craftingtweaks", "darkmodeeverywhere", "drippyloadingscreen", "durabilitytooltip", "enchdesc", "extremesoundmuffler", "extremesoundvisualizer", "fadingnightvision", "fancymenu", "findme", "ftbbackups3", "ftbchunks", "ftbessentials", "ftbfiltersystem", "ftbquests", "ftbquestslangsplitter", "ftbranks", "ftbteambases", "ftbteams", "ibicf", "incontrol", "inventoryessentials", "inventorysorter", "invtweaks", "jade", "jearchaeology", "journeymap", "justenoughbreeding", "justenoughprofessions", "justzoom", "keybindbundles", "keybindspurger", "leaderboards", "legendarytooltips", "lmft", "memorysettings", "moreoverlays", "mousetweaks", "mysticalcustomization", "nbt_ac", "neo_auth", "nochatreports", "nolijium", "notenoughanimations", "novillagerdm", "oracle_index", "overflowingbars", "overloadedarmorbar", "particular", "pickupnotifier", "pipegoggles", "pop", "rainbows", "reap", "rebind_narrator", "resourcepackoverrides", "restrictions", "sdrp", "shiny", "simple_weather", "simplebackups", "smithingtemplateviewer", "statuseffectbars", "tipsmod", "toastcontrol", "toofast", "tooltipoverhaul", "towntalk", "trade_cycling", "transfer_labels", "trashslot", "trophymanager", "utilitarian", "villagerconfig", "watut", "wits", "polymorph", "euphoria_patcher", "iris", "spark", "colorwheel", "colorwheel_patcher", "openloader", "paxi", "monocle", "observable", "crash_assistant", "crashutilities", "polyeng", "magiccoinstweak");
        BuiltInCategories.worldgen("nomansland", "environmental", "abundant_atmosphere", "upgrade_aquatic", "atmospheric", "autumnity", "antiquetradingship", "tectonic", "smallhorsestable", "hopo", "flatbedrock", "hopour", "hoporp", "javd", "jamd", "yungsbridges", "dungeons_arise_seven_seas", "yungscavebiomes", "desert_oasis", "twilight_treehouses", "sawmillhouse", "respawningstructures", "structures_tweaker", "structureessentials", "structurify", "abridged", "puffish_biome_dither", "simple_snowy_fix", "netherite_tweaks_luna", "hearths", "mmv", "stonycliffs", "mr_dungeons_andtavernsancientcityoverhaul", "explorations", "improved_village_placement", "climaterivers", "snowundertrees", "adventuredungeons", "repurposed_structures_farmers_delight_compat", "farmers_structures", "gardens_of_the_dead", "eternalnether", "geophilic", "mr_lukis_crazychambers", "deep_aether", "sparsestructures", "adorabuild_structures", "mr_dungeons_andtavernsswamphutoverhaul", "mr_dungeons_andtavernswoodlandmansionreplacement", "wetland_whimsy", "aether_villages", "illagerwarship", "hyperbox", "aether", "alltheores", "betterdeserttemples", "betterdungeons", "betterendisland", "betterfortresses", "betterjungletemples", "bettermineshafts", "betteroceanmonuments", "betterstrongholds", "betterwitchhuts", "bibliobiomes", "biomeswevegone", "ctov", "deepdarkdimdungeons", "deeperdarker", "dimdungeons", "dungeoncrawl", "dungeons_arise", "eternal_starlight", "explorify", "formations", "formationsnether", "formationsoverworld", "mes", "mns", "moogs_structures", "mostructures", "mss", "mvs", "nullscape", "regions_unexplored", "repurposed_structures", "structory", "structory_towers", "structureexpansion", "t_and_t", "the_bumblezone", "twilightforest", "undergarden", "underground_villages", "villagesandpillages", "yungsextras");
    }
}

