/*
 * Decompiled with CFR 0.152.
 */
package com.li64.tide.registries.items;

import com.li64.tide.Tide;
import com.li64.tide.client.gui.overlays.CastBarOverlay;
import com.li64.tide.data.minigame.FishCatchMinigame;
import com.li64.tide.data.rods.BobberModifier;
import com.li64.tide.data.rods.CustomRodManager;
import com.li64.tide.data.rods.HookModifier;
import com.li64.tide.data.rods.LineModifier;
import com.li64.tide.registries.TideEntityTypes;
import com.li64.tide.registries.entities.misc.fishing.HookAccessor;
import com.li64.tide.registries.entities.misc.fishing.TideFishingHook;
import com.li64.tide.util.TideUtils;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.core.Holder;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.stats.Stats;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.FishingRodItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.UseAnim;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.gameevent.GameEvent;

public class TideFishingRodItem
extends FishingRodItem {
    public static final ResourceLocation CAST_PROPERTY = Tide.resource("cast");

    public TideFishingRodItem(double baseDurability, Item.Properties properties) {
        super(properties.durability((int)(baseDurability * (Tide.CONFIG == null ? 1.0 : Tide.CONFIG.general.rodDurabilityMultiplier))));
    }

    public boolean isLavaproof(ItemStack stack) {
        return CustomRodManager.getHook(stack).isLavaproof();
    }

    public InteractionResultHolder<ItemStack> use(Level level, Player player, InteractionHand hand) {
        if (this.isHookActive(player)) {
            TideFishingHook hook = this.getHook(player);
            if (!this.isMinigameActive(player) && Tide.CONFIG.general.doMinigame) {
                if (Tide.PLATFORM.isModLoaded("stardew_fishing")) {
                    if (hook.getCatchType() == TideFishingHook.CatchType.FISH || hook.getCatchType() == TideFishingHook.CatchType.ITEM) {
                        if (!level.isClientSide()) {
                            Tide.LOG.info("Starting stardew fishing minigame");
                            level.playSound(null, player.getX(), player.getY(), player.getZ(), SoundEvents.FISHING_BOBBER_RETRIEVE, SoundSource.NEUTRAL, 1.2f, 0.4f / (level.getRandom().nextFloat() * 0.4f + 0.8f));
                            if (!Tide.PLATFORM.stardewStart((ServerPlayer)player, (HookAccessor)player.fishing, player.getItemInHand(hand), List.of(hook.getHookedItem().getDefaultInstance()))) {
                                this.retrieveHook(player.getItemInHand(hand), player, level);
                            }
                        }
                    } else {
                        this.retrieveHook(player.getItemInHand(hand), player, level);
                    }
                } else if (hook.getCatchType() == TideFishingHook.CatchType.FISH) {
                    if (!level.isClientSide() && !this.isMinigameActive(player)) {
                        Tide.LOG.info("Starting tide fishing minigame");
                        FishCatchMinigame.create(player);
                    }
                } else {
                    this.retrieveHook(player.getItemInHand(hand), player, level);
                }
            } else if (!level.isClientSide()) {
                if (Tide.CONFIG.general.doMinigame) {
                    FishCatchMinigame minigame = FishCatchMinigame.getInstance(player);
                    if (minigame != null) {
                        minigame.interact();
                    }
                } else {
                    hook.retrieve();
                }
            }
            return InteractionResultHolder.sidedSuccess((Object)player.getItemInHand(hand), (boolean)level.isClientSide());
        }
        if (Tide.CONFIG.general.holdToCast) {
            level.playSound(null, player.getX(), player.getY(), player.getZ(), SoundEvents.FISHING_BOBBER_RETRIEVE, SoundSource.NEUTRAL, 1.5f, 0.3f / (level.getRandom().nextFloat() * 0.4f + 0.7f));
            player.startUsingItem(hand);
            return InteractionResultHolder.consume((Object)player.getItemInHand(hand));
        }
        this.castHook(player.getItemInHand(hand), player, level, 1.0f);
        return InteractionResultHolder.sidedSuccess((Object)player.getItemInHand(hand), (boolean)level.isClientSide());
    }

    private boolean isMinigameActive(Player player) {
        return FishCatchMinigame.minigameActive(player);
    }

    public void releaseUsing(ItemStack rod, Level level, LivingEntity user, int charge) {
        if (user instanceof Player) {
            Player player = (Player)user;
            int chargeDifference = this.getUseDuration(rod, user) - charge;
            if (chargeDifference > this.getChargeDuration(rod)) {
                chargeDifference = this.getChargeDuration(rod);
            }
            float chargeMultiplier = (float)chargeDifference / (float)this.getChargeDuration(rod) + 0.5f;
            this.castHook(rod, player, level, chargeMultiplier);
        }
    }

    public boolean isHookActive(Player player) {
        TideFishingHook hook = HookAccessor.getHook(player);
        return hook != null;
    }

    public TideFishingHook getHook(Player player) {
        return HookAccessor.getHook(player);
    }

    public void castHook(ItemStack rod, Player player, Level level, float charge) {
        TideFishingHook activeHook = HookAccessor.getHook(player);
        if (activeHook == null) {
            level.playSound(null, player.getX(), player.getY(), player.getZ(), SoundEvents.FISHING_BOBBER_THROW, SoundSource.NEUTRAL, 0.5f, 0.4f / (level.getRandom().nextFloat() * 0.4f + 0.8f));
            if (!level.isClientSide) {
                int speed = (int)(EnchantmentHelper.getFishingTimeReduction((ServerLevel)((ServerLevel)level), (ItemStack)rod, (Entity)player) / 5.0f);
                int luck = EnchantmentHelper.getFishingLuckBonus((ServerLevel)((ServerLevel)level), (ItemStack)rod, (Entity)player);
                if (TideUtils.isHoldingBait(player)) {
                    speed += TideUtils.getBaitSpeed(TideUtils.getHeldBaitItem(player));
                    luck += TideUtils.getBaitLuck(TideUtils.getHeldBaitItem(player));
                }
                level.addFreshEntity((Entity)new TideFishingHook(TideEntityTypes.FISHING_BOBBER, player, level, luck, speed, charge, rod));
            }
            player.awardStat(Stats.ITEM_USED.get((Object)this));
            player.gameEvent((Holder)GameEvent.ITEM_INTERACT_START);
        }
    }

    public void retrieveHook(ItemStack rod, Player player, Level level) {
        TideFishingHook activeHook = HookAccessor.getHook(player);
        if (activeHook != null) {
            if (!level.isClientSide) {
                int durabilityLoss = activeHook.retrieve(rod, (ServerLevel)level, player);
                rod.hurtAndBreak(durabilityLoss, (LivingEntity)player, LivingEntity.getSlotForHand((InteractionHand)player.getUsedItemHand()));
            }
            level.playSound(null, player.getX(), player.getY(), player.getZ(), SoundEvents.FISHING_BOBBER_RETRIEVE, SoundSource.NEUTRAL, 1.2f, 0.4f / (level.getRandom().nextFloat() * 0.4f + 0.8f));
            player.gameEvent((Holder)GameEvent.ITEM_INTERACT_FINISH);
        }
    }

    public void onUseTick(Level level, LivingEntity user, ItemStack rod, int charge) {
        super.onUseTick(level, user, rod, charge);
        if (level.isClientSide() && user == Minecraft.getInstance().player) {
            int chargeDifference = this.getUseDuration(rod, user) - charge;
            if (chargeDifference > this.getChargeDuration(rod)) {
                chargeDifference = this.getChargeDuration(rod);
            }
            CastBarOverlay.rodChargeTick((float)chargeDifference / (float)this.getChargeDuration(rod));
        }
    }

    public int getUseDuration(ItemStack stack, LivingEntity entity) {
        return 60000;
    }

    public int getChargeDuration(ItemStack rod) {
        return CustomRodManager.getLine(rod) == LineModifier.BRAIDED ? 15 : 25;
    }

    public UseAnim getUseAnimation(ItemStack stack) {
        return UseAnim.BOW;
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltip, TooltipFlag flag) {
        super.appendHoverText(stack, context, tooltip, flag);
        BobberModifier bobber = CustomRodManager.getBobber(stack);
        HookModifier hook = CustomRodManager.getHook(stack);
        LineModifier line = CustomRodManager.getLine(stack);
        MutableComponent bobberComponent = Component.translatable((String)bobber.getTranslationKey());
        tooltip.add((Component)bobberComponent.withStyle(bobberComponent.getStyle().withItalic(Boolean.valueOf(true)).withColor(ChatFormatting.YELLOW)));
        MutableComponent hookComponent = Component.translatable((String)hook.getTranslationKey());
        tooltip.add((Component)hookComponent.withStyle(hookComponent.getStyle().withItalic(Boolean.valueOf(true)).withColor(ChatFormatting.YELLOW)));
        MutableComponent lineComponent = Component.translatable((String)line.getTranslationKey());
        tooltip.add((Component)lineComponent.withStyle(lineComponent.getStyle().withItalic(Boolean.valueOf(true)).withColor(ChatFormatting.YELLOW)));
    }
}

