/*
 * Decompiled with CFR 0.152.
 */
package com.li64.tide.registries.entities.renderers;

import com.li64.tide.Tide;
import com.li64.tide.registries.entities.fish.Catfish;
import com.li64.tide.registries.entities.models.CatfishModel;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.MobRenderer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;

public class CatfishRenderer<T extends Catfish>
extends MobRenderer<T, CatfishModel<T>> {
    private final ResourceLocation texLocation = Tide.resource("textures/entity/fish/catfish.png");

    public CatfishRenderer(EntityRendererProvider.Context context) {
        super(context, new CatfishModel(context.bakeLayer(CatfishModel.LAYER_LOCATION)), 0.3f);
    }

    public ResourceLocation getTextureLocation(T fish) {
        return this.texLocation;
    }

    protected void setupRotations(T fish, PoseStack poseStack, float rx, float ry, float rz, float idk) {
        super.setupRotations(fish, poseStack, rx, ry, rz, idk);
        float f = 4.3f * Mth.sin((float)(0.6f * rx));
        poseStack.mulPose(Axis.YP.rotationDegrees(f));
        if (!fish.isInWater()) {
            poseStack.translate(0.1f, 0.1f, -0.1f);
            poseStack.mulPose(Axis.ZP.rotationDegrees(90.0f));
        }
    }
}

