/*
 * Decompiled with CFR 0.152.
 */
package com.li64.tide.registries.entities.models;

import com.li64.tide.Tide;
import com.li64.tide.registries.entities.fish.Catfish;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.util.Mth;

public class CatfishModel<T extends Catfish>
extends EntityModel<T> {
    public static final ModelLayerLocation LAYER_LOCATION = new ModelLayerLocation(Tide.resource("catfish"), "main");
    private final ModelPart body;
    private final ModelPart tail;

    public CatfishModel(ModelPart root) {
        this.body = root.getChild("body");
        this.tail = this.body.getChild("tail");
    }

    public static LayerDefinition createBodyLayer() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.getRoot();
        PartDefinition body = partdefinition.addOrReplaceChild("body", CubeListBuilder.create().texOffs(11, 0).addBox(-1.0f, -5.0f, -4.0f, 2.0f, 4.0f, 3.0f, new CubeDeformation(0.0f)).texOffs(18, 6).addBox(-1.0f, -4.0f, -5.0f, 2.0f, 3.0f, 1.0f, new CubeDeformation(0.0f)).texOffs(0, 0).addBox(-1.0f, -5.0f, -1.0f, 2.0f, 4.0f, 7.0f, new CubeDeformation(0.0f)).texOffs(8, 17).addBox(-3.0f, -3.0f, -5.0f, 6.0f, 3.0f, 0.0f, new CubeDeformation(0.0f)).texOffs(8, 20).addBox(-3.0f, -3.0f, -3.5f, 6.0f, 3.0f, 0.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)24.0f, (float)0.0f));
        body.addOrReplaceChild("fin_right", CubeListBuilder.create().texOffs(0, 5).addBox(0.0f, -2.0f, -4.0f, 0.0f, 2.0f, 8.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)-1.0f, (float)-2.0f, (float)1.0f, (float)3.1416f, (float)0.0f, (float)0.6981f));
        body.addOrReplaceChild("fin_left", CubeListBuilder.create().texOffs(0, 7).addBox(0.0f, -2.0f, -4.0f, 0.0f, 2.0f, 8.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)1.0f, (float)-2.0f, (float)1.0f, (float)0.0f, (float)0.0f, (float)2.4435f));
        body.addOrReplaceChild("fin_top", CubeListBuilder.create().texOffs(0, 3).addBox(0.0f, -2.0f, -4.0f, 0.0f, 2.0f, 8.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)-5.0f, (float)1.0f, (float)0.0f, (float)3.1416f, (float)0.0f));
        body.addOrReplaceChild("tail", CubeListBuilder.create().texOffs(0, 13).addBox(0.0f, -2.0f, 0.0f, 0.0f, 4.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)-3.0f, (float)6.0f));
        return LayerDefinition.create((MeshDefinition)meshdefinition, (int)32, (int)32);
    }

    public void setupAnim(T entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        float f = 1.0f;
        if (!entity.isInWater()) {
            f = 1.5f;
        }
        this.tail.yRot = -f * 0.45f * Mth.sin((float)(0.6f * ageInTicks));
    }

    public void renderToBuffer(PoseStack poseStack, VertexConsumer vertexConsumer, int packedLight, int packedOverlay, int color) {
        this.body.render(poseStack, vertexConsumer, packedLight, packedOverlay, color);
    }
}

