/*
 * Decompiled with CFR 0.152.
 */
package com.li64.tide.registries.entities.misc.fishing;

import com.li64.tide.Tide;
import com.li64.tide.registries.entities.misc.fishing.TideFishingBobberLayer;
import com.li64.tide.registries.entities.misc.fishing.TideFishingHook;
import com.li64.tide.registries.entities.misc.fishing.TideFishingHookModel;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import java.awt.Color;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.FastColor;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.HumanoidArm;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.FishingRodItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;

public class TideFishingHookRenderer
extends EntityRenderer<TideFishingHook>
implements RenderLayerParent<TideFishingHook, TideFishingHookModel<TideFishingHook>> {
    private final TideFishingHookModel<TideFishingHook> model;
    private final TideFishingBobberLayer bobberLayer;
    private static final ResourceLocation HOOK_TEX_LOCATION = Tide.resource("textures/entity/fishing_hook/fishing_hook.png");

    public TideFishingHookRenderer(EntityRendererProvider.Context context) {
        super(context);
        this.model = new TideFishingHookModel(context.bakeLayer(TideFishingHookModel.LAYER_LOCATION));
        this.bobberLayer = new TideFishingBobberLayer(this, context.getModelSet());
        this.shadowRadius = 0.1f;
    }

    public void render(TideFishingHook hookEntity, float entityYaw, float partialTick, PoseStack poseStack, MultiBufferSource bufferSource, int packedLight) {
        Player player = hookEntity.getPlayerOwner();
        if (player == null) {
            return;
        }
        poseStack.pushPose();
        poseStack.pushPose();
        poseStack.translate(0.03125f, 0.0f, 0.03125f);
        poseStack.mulPose(Axis.YP.rotationDegrees(180.0f - hookEntity.getInitialYaw()));
        poseStack.scale(-1.0f, -1.0f, 1.0f);
        this.model.setupAnim(hookEntity, partialTick, 0.0f, -0.1f, 0.0f, 0.0f);
        VertexConsumer vertexConsumer = bufferSource.getBuffer(RenderType.entityCutoutNoCull((ResourceLocation)this.getTextureLocation(hookEntity)));
        this.model.renderToBuffer(poseStack, vertexConsumer, packedLight, OverlayTexture.NO_OVERLAY, FastColor.ARGB32.color((int)255, (int)255, (int)255, (int)255));
        this.bobberLayer.render(poseStack, bufferSource, packedLight, hookEntity, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f);
        poseStack.popPose();
        this.renderConnectingString(hookEntity, partialTick, poseStack, bufferSource, player);
        poseStack.popPose();
        super.render((Entity)hookEntity, entityYaw, partialTick, poseStack, bufferSource, packedLight);
    }

    private void renderConnectingString(TideFishingHook hookEntity, float partialTick, PoseStack poseStack, MultiBufferSource multiBufferSource, Player player) {
        float f3;
        double d6;
        double d5;
        double d4;
        int i = player.getMainArm() == HumanoidArm.RIGHT ? 1 : -1;
        ItemStack itemstack = player.getMainHandItem();
        if (!(itemstack.getItem() instanceof FishingRodItem)) {
            i = -i;
        }
        float f = player.getAttackAnim(partialTick);
        float f1 = Mth.sin((float)(Mth.sqrt((float)f) * (float)Math.PI));
        float f2 = Mth.lerp((float)partialTick, (float)player.yBodyRotO, (float)player.yBodyRot) * ((float)Math.PI / 180);
        double d0 = Mth.sin((float)f2);
        double d1 = Mth.cos((float)f2);
        double d2 = (double)i * 0.35;
        double d3 = 0.8;
        if (this.entityRenderDispatcher.options.getCameraType().isFirstPerson() && player == Minecraft.getInstance().player) {
            double d7 = 960.0 / (double)((Integer)this.entityRenderDispatcher.options.fov().get()).intValue();
            Vec3 vec3 = this.entityRenderDispatcher.camera.getNearPlane().getPointOnPlane((float)i * 0.525f, -0.1f);
            vec3 = vec3.scale(d7);
            vec3 = vec3.yRot(f1 * 0.5f);
            vec3 = vec3.xRot(-f1 * 0.7f);
            d4 = Mth.lerp((double)partialTick, (double)player.xo, (double)player.getX()) + vec3.x;
            d5 = Mth.lerp((double)partialTick, (double)player.yo, (double)player.getY()) + vec3.y;
            d6 = Mth.lerp((double)partialTick, (double)player.zo, (double)player.getZ()) + vec3.z;
            f3 = player.getEyeHeight();
        } else {
            d4 = Mth.lerp((double)partialTick, (double)player.xo, (double)player.getX()) - d1 * d2 - d0 * 0.8;
            d5 = player.yo + (double)player.getEyeHeight() + (player.getY() - player.yo) * (double)partialTick - 0.45;
            d6 = Mth.lerp((double)partialTick, (double)player.zo, (double)player.getZ()) - d0 * d2 + d1 * 0.8;
            f3 = player.isCrouching() ? -0.1875f : 0.0f;
        }
        double d9 = Mth.lerp((double)partialTick, (double)hookEntity.xo, (double)hookEntity.getX());
        double d10 = Mth.lerp((double)partialTick, (double)hookEntity.yo, (double)hookEntity.getY()) + 0.25;
        double d8 = Mth.lerp((double)partialTick, (double)hookEntity.zo, (double)hookEntity.getZ());
        float f4 = (float)(d4 - d9);
        float f5 = (float)(d5 - d10) + f3;
        float f6 = (float)(d6 - d8);
        VertexConsumer vertexconsumer1 = multiBufferSource.getBuffer(RenderType.lineStrip());
        PoseStack.Pose posestack$pose1 = poseStack.last();
        for (int k = 0; k <= 16; ++k) {
            BlockPos vertexPos = new BlockPos((int)d9, (int)d10, (int)d8);
            TideFishingHookRenderer.stringVertex(f4, f5, f6, vertexconsumer1, posestack$pose1, TideFishingHookRenderer.fraction(k, 16), TideFishingHookRenderer.fraction(k + 1, 16), vertexPos, hookEntity.level(), hookEntity.getLineModifier().getLineColor());
        }
    }

    private static float fraction(int a, int b) {
        return (float)a / (float)b;
    }

    private static void stringVertex(float x, float y, float z, VertexConsumer vertexConsumer, PoseStack.Pose pose, float frac1, float frac2, BlockPos hookPos, Level level, String colorHex) {
        float f = x * frac1;
        float f1 = y * (frac1 * frac1 + frac1) * 0.5f + 0.25f;
        float f2 = z * frac1;
        float f3 = x * frac2 - f;
        float f4 = y * (frac2 * frac2 + frac2) * 0.5f + 0.25f - f1;
        float f5 = z * frac2 - f2;
        float f6 = Mth.sqrt((float)(f3 * f3 + f4 * f4 + f5 * f5));
        f3 /= f6;
        f4 /= f6;
        f5 /= f6;
        Color color = Color.decode(colorHex);
        float colorBrightness = Tide.CONFIG.general.defaultLineColor ? 0.0f : 1.0f;
        int r = (int)((float)color.getRed() * colorBrightness);
        int g = (int)((float)color.getGreen() * colorBrightness);
        int b = (int)((float)color.getBlue() * colorBrightness);
        vertexConsumer.addVertex(pose.pose(), f, f1, f2).setColor(FastColor.ARGB32.color((int)255, (int)r, (int)g, (int)b)).setNormal(pose, f3, f4, f5);
    }

    public TideFishingHookModel<TideFishingHook> getModel() {
        return this.model;
    }

    public ResourceLocation getTextureLocation(TideFishingHook hookEntity) {
        if (!this.allowModifiers()) {
            return HOOK_TEX_LOCATION;
        }
        return hookEntity.getHookModifier().getTextureLocation();
    }

    protected boolean allowModifiers() {
        return true;
    }
}

