/*
 * Decompiled with CFR 0.152.
 */
package com.li64.tide.registries.entities.misc.fishing;

import com.li64.tide.Tide;
import com.li64.tide.data.TideCriteriaTriggers;
import com.li64.tide.data.TideTags;
import com.li64.tide.data.rods.BobberModifier;
import com.li64.tide.data.rods.CustomRodManager;
import com.li64.tide.data.rods.HookModifier;
import com.li64.tide.data.rods.LineModifier;
import com.li64.tide.registries.TideBlocks;
import com.li64.tide.registries.TideItems;
import com.li64.tide.registries.entities.misc.LootCrateEntity;
import com.li64.tide.registries.entities.misc.fishing.HookAccessor;
import com.li64.tide.registries.items.TideFishingRodItem;
import com.li64.tide.util.TideUtils;
import com.mojang.logging.LogUtils;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Random;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.game.ClientboundAddEntityPacket;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.stats.Stats;
import net.minecraft.tags.ItemTags;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.ExperienceOrb;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.entity.projectile.ProjectileUtil;
import net.minecraft.world.item.FishingRodItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.level.storage.loot.BuiltInLootTables;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSets;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import org.slf4j.Logger;

public class TideFishingHook
extends Projectile {
    private static final Logger LOGGER = LogUtils.getLogger();
    private final RandomSource synchronizedRandom = RandomSource.create();
    private boolean biting;
    private int outOfWaterTime;
    private static final EntityDataAccessor<Integer> DATA_HOOKED_ENTITY = SynchedEntityData.defineId(TideFishingHook.class, (EntityDataSerializer)EntityDataSerializers.INT);
    private static final EntityDataAccessor<Boolean> DATA_BITING = SynchedEntityData.defineId(TideFishingHook.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    private static final EntityDataAccessor<ItemStack> DATA_ROD_ITEM = SynchedEntityData.defineId(TideFishingHook.class, (EntityDataSerializer)EntityDataSerializers.ITEM_STACK);
    private static final EntityDataAccessor<Integer> DATA_CATCH_TYPE = SynchedEntityData.defineId(TideFishingHook.class, (EntityDataSerializer)EntityDataSerializers.INT);
    private static final EntityDataAccessor<Boolean> DATA_MINIGAME_ACTIVE = SynchedEntityData.defineId(TideFishingHook.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    private static final EntityDataAccessor<Float> DATA_INITIAL_YAW = SynchedEntityData.defineId(TideFishingHook.class, (EntityDataSerializer)EntityDataSerializers.FLOAT);
    private int life;
    private int nibble;
    private int timeUntilLured;
    private int timeUntilHooked;
    private float fishAngle;
    private boolean openWater = true;
    private Entity hookedIn;
    private FishHookState currentState = FishHookState.FLYING;
    private FluidState fluid;
    private final int luck;
    private final int lureSpeed;
    private boolean minigameActive = false;
    protected ItemStack rod;
    protected ItemStack hookedItem;
    protected CatchType catchType = CatchType.NOTHING;

    private TideFishingHook(EntityType<? extends TideFishingHook> entityType, Level level, int luck, int lureSpeed, ItemStack rod) {
        super(entityType, level);
        this.noCulling = true;
        this.rod = rod;
        this.entityData.set(DATA_ROD_ITEM, (Object)rod);
        this.luck = Math.max(0, luck + (this.getLineModifier() == LineModifier.FORTUNE ? 1 : 0));
        this.lureSpeed = Math.max(0, lureSpeed);
    }

    public TideFishingHook(EntityType<? extends TideFishingHook> entityType, Level level) {
        this(entityType, level, 0, 0, Items.FISHING_ROD.getDefaultInstance());
    }

    public TideFishingHook(EntityType<? extends TideFishingHook> hookType, Player player, Level level, int luck, int lureSpeed, float charge, ItemStack rod) {
        this(hookType, level, luck, lureSpeed, rod);
        this.setOwner((Entity)player);
        float f = player.getXRot();
        float f1 = player.getYRot();
        float f2 = Mth.cos((float)(-f1 * ((float)Math.PI / 180) - (float)Math.PI));
        float f3 = Mth.sin((float)(-f1 * ((float)Math.PI / 180) - (float)Math.PI));
        float f4 = -Mth.cos((float)(-f * ((float)Math.PI / 180)));
        float f5 = Mth.sin((float)(-f * ((float)Math.PI / 180)));
        double d0 = player.getX() - (double)f3 * 0.3;
        double d1 = player.getEyeY();
        double d2 = player.getZ() - (double)f2 * 0.3;
        this.moveTo(d0, d1, d2, f1, f);
        Vec3 vec3 = new Vec3((double)(-f3), (double)Mth.clamp((float)(-(f5 / f4)), (float)-5.0f, (float)5.0f), (double)(-f2));
        double d3 = vec3.length();
        vec3 = vec3.multiply((double)charge, (double)charge, (double)charge);
        vec3 = vec3.multiply(0.6 / d3 + this.random.triangle(0.5, 0.0103365), 0.6 / d3 + this.random.triangle(0.5, 0.0103365), 0.6 / d3 + this.random.triangle(0.5, 0.0103365));
        this.setDeltaMovement(vec3);
        this.setYRot(f1);
        this.setXRot(0.0f);
        this.yRotO = this.getYRot();
        this.xRotO = this.getXRot();
        this.entityData.set(DATA_INITIAL_YAW, (Object)Float.valueOf(f1));
        this.entityData.set(DATA_ROD_ITEM, (Object)rod);
    }

    public void invalidateCatch() {
        this.hookedItem = null;
        this.catchType = CatchType.NOTHING;
        this.getEntityData().set(DATA_CATCH_TYPE, (Object)this.catchType.ordinal());
    }

    public int getLuck() {
        return this.luck;
    }

    public float getInitialYaw() {
        return ((Float)this.entityData.get(DATA_INITIAL_YAW)).floatValue();
    }

    public int getLureSpeed() {
        return this.lureSpeed;
    }

    public Holder<Biome> getBiome() {
        return this.level().getBiome(this.blockPosition());
    }

    public boolean isOpenWaterFishing() {
        return this.openWater;
    }

    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        builder.define(DATA_HOOKED_ENTITY, (Object)0);
        builder.define(DATA_BITING, (Object)false);
        builder.define(DATA_ROD_ITEM, (Object)Items.FISHING_ROD.getDefaultInstance());
        builder.define(DATA_CATCH_TYPE, (Object)CatchType.NOTHING.ordinal());
        builder.define(DATA_MINIGAME_ACTIVE, (Object)false);
        builder.define(DATA_INITIAL_YAW, (Object)Float.valueOf(0.0f));
    }

    public void onSyncedDataUpdated(EntityDataAccessor<?> data) {
        if (DATA_HOOKED_ENTITY.equals(data)) {
            int i = (Integer)this.getEntityData().get(DATA_HOOKED_ENTITY);
            Entity entity = this.hookedIn = i > 0 ? this.level().getEntity(i - 1) : null;
        }
        if (DATA_BITING.equals(data)) {
            this.biting = (Boolean)this.getEntityData().get(DATA_BITING);
            if (this.biting) {
                this.setDeltaMovement(this.getDeltaMovement().x, -0.4f * Mth.nextFloat((RandomSource)this.synchronizedRandom, (float)0.6f, (float)1.0f), this.getDeltaMovement().z);
            }
        }
        if (DATA_ROD_ITEM.equals(data)) {
            this.rod = (ItemStack)this.getEntityData().get(DATA_ROD_ITEM);
        }
        if (DATA_CATCH_TYPE.equals(data) && this.level().isClientSide()) {
            this.catchType = CatchType.values()[(Integer)this.getEntityData().get(DATA_CATCH_TYPE)];
        }
        if (DATA_MINIGAME_ACTIVE.equals(data)) {
            this.minigameActive = (Boolean)this.getEntityData().get(DATA_MINIGAME_ACTIVE);
            if (!this.level().isClientSide() && !this.minigameActive) {
                this.restartFishingSequence();
            }
        }
        super.onSyncedDataUpdated(data);
    }

    public boolean shouldRenderAtSqrDistance(double dst) {
        return dst < 4096.0;
    }

    public void lerpTo(double p_37127_, double p_37128_, double p_37129_, float p_37130_, float p_37131_, int p_37132_, boolean p_37133_) {
    }

    public static Vec3 lerpPos(Vec3 start, Vec3 end, float t) {
        double x = start.x + (end.x - start.x) * (double)t;
        double y = start.y + (end.y - start.y) * (double)t;
        double z = start.z + (end.z - start.z) * (double)t;
        return new Vec3(x, y, z);
    }

    public void tick() {
        this.synchronizedRandom.setSeed(this.getUUID().getLeastSignificantBits() ^ this.level().getGameTime());
        super.tick();
        Player player = this.getPlayerOwner();
        if (player == null) {
            this.discard();
        } else if (this.level().isClientSide || !this.shouldStopFishing(player)) {
            boolean flag;
            FluidState fluidstate;
            if (this.onGround()) {
                ++this.life;
                if (this.life >= 1200) {
                    this.discard();
                    return;
                }
            } else {
                this.life = 0;
            }
            float f = 0.0f;
            BlockPos blockpos = this.blockPosition();
            this.fluid = fluidstate = this.level().getFluidState(blockpos);
            if (this.canFishIn(fluidstate)) {
                f = fluidstate.getHeight((BlockGetter)this.level(), blockpos);
            }
            boolean bl = flag = f > 0.0f;
            if (this.currentState == FishHookState.FLYING) {
                if (this.hookedIn != null) {
                    this.setDeltaMovement(Vec3.ZERO);
                    this.currentState = FishHookState.HOOKED_IN_ENTITY;
                    return;
                }
                if (flag) {
                    this.setDeltaMovement(this.getDeltaMovement().multiply(0.3, 0.2, 0.3));
                    this.currentState = FishHookState.BOBBING;
                    return;
                }
                this.checkCollision();
            } else {
                if (this.currentState == FishHookState.HOOKED_IN_ENTITY) {
                    if (this.hookedIn != null) {
                        if (!this.hookedIn.isRemoved() && this.hookedIn.level().dimension() == this.level().dimension()) {
                            this.setPos(this.hookedIn.getX(), this.hookedIn.getY(0.8), this.hookedIn.getZ());
                        } else {
                            this.setHookedEntity(null);
                            this.currentState = FishHookState.FLYING;
                        }
                    }
                    return;
                }
                if (this.currentState == FishHookState.BOBBING) {
                    Vec3 vec3 = this.getDeltaMovement();
                    double d0 = this.getY() + vec3.y - (double)blockpos.getY() - (double)f;
                    if (Math.abs(d0) < 0.01) {
                        d0 += Math.signum(d0) * 0.1;
                    }
                    this.setDeltaMovement(vec3.x * 0.9, vec3.y - d0 * (double)this.random.nextFloat() * 0.2, vec3.z * 0.9);
                    if (this.nibble <= 0 && this.timeUntilHooked <= 0) {
                        this.openWater = true;
                    } else {
                        boolean bl2 = this.openWater = this.openWater && this.outOfWaterTime < 10 && this.calculateOpenWater(blockpos);
                    }
                    if (flag) {
                        this.outOfWaterTime = Math.max(0, this.outOfWaterTime - 1);
                        if (this.biting) {
                            this.setDeltaMovement(this.getDeltaMovement().add(0.0, -0.1 * (double)this.synchronizedRandom.nextFloat() * (double)this.synchronizedRandom.nextFloat(), 0.0));
                        }
                        if (!this.level().isClientSide) {
                            this.catchingFish(blockpos);
                        }
                    } else {
                        this.outOfWaterTime = Math.min(10, this.outOfWaterTime + 1);
                    }
                }
            }
            if (!this.canFishIn(fluidstate)) {
                this.setDeltaMovement(this.getDeltaMovement().add(0.0, -0.03, 0.0));
            }
            this.move(MoverType.SELF, this.getDeltaMovement());
            if (this.currentState == FishHookState.FLYING && (this.onGround() || this.horizontalCollision)) {
                this.setDeltaMovement(Vec3.ZERO);
            }
            double d1 = 0.92;
            this.setDeltaMovement(this.getDeltaMovement().scale(d1));
            this.reapplyPosition();
        }
    }

    private boolean shouldStopFishing(Player player) {
        ItemStack mainHand = player.getMainHandItem();
        ItemStack offHand = player.getOffhandItem();
        boolean flag = mainHand.getItem() instanceof FishingRodItem;
        boolean flag1 = offHand.getItem() instanceof FishingRodItem;
        if (!player.isRemoved() && player.isAlive() && (flag || flag1) && !(this.distanceToSqr((Entity)player) > 1224.0)) {
            return false;
        }
        this.discard();
        return true;
    }

    private void checkCollision() {
        HitResult hitresult = ProjectileUtil.getHitResultOnMoveVector((Entity)this, this::canHitEntity);
        this.hitTargetOrDeflectSelf(hitresult);
    }

    protected boolean canHitEntity(Entity entity) {
        return super.canHitEntity(entity) || entity.isAlive() && entity instanceof ItemEntity;
    }

    protected void onHitEntity(EntityHitResult result) {
        super.onHitEntity(result);
        if (!this.level().isClientSide) {
            if (result.getEntity() == this.getOwner()) {
                this.discard();
            }
            this.setHookedEntity(result.getEntity());
        }
    }

    protected void onHitBlock(BlockHitResult result) {
        super.onHitBlock(result);
        this.setDeltaMovement(this.getDeltaMovement().normalize().scale(result.distanceTo((Entity)this)));
    }

    private void setHookedEntity(Entity p_150158_) {
        this.hookedIn = p_150158_;
        this.getEntityData().set(DATA_HOOKED_ENTITY, (Object)(p_150158_ == null ? 0 : p_150158_.getId() + 1));
    }

    private void catchingFish(BlockPos pos) {
        if (Tide.PLATFORM.isModLoaded("stardew_fishing") && Tide.PLATFORM.stardewGetRewards((HookAccessor)this.getPlayerOwner().fishing).isEmpty()) {
            return;
        }
        ServerLevel level = (ServerLevel)this.level();
        int i = 1;
        BlockPos abovePos = pos.above();
        if (this.random.nextFloat() < 0.25f && this.level().isRainingAt(abovePos)) {
            ++i;
        }
        if (this.random.nextFloat() < 0.5f && !this.level().canSeeSky(abovePos)) {
            --i;
        }
        if (this.nibble > 0) {
            if (!this.minigameActive) {
                --this.nibble;
            }
            if (this.nibble <= 0) {
                this.restartFishingSequence();
            }
        } else if (this.timeUntilHooked > 0) {
            this.timeUntilHooked -= i;
            if (this.timeUntilHooked > 0) {
                double d2;
                double d1;
                this.fishAngle += (float)this.random.triangle(0.0, 9.188);
                float f = this.fishAngle * ((float)Math.PI / 180);
                float f1 = Mth.sin((float)f);
                float f2 = Mth.cos((float)f);
                double d0 = this.getX() + (double)(f1 * (float)this.timeUntilHooked * 0.1f);
                BlockState blockstate = level.getBlockState(BlockPos.containing((double)d0, (double)((d1 = (double)((float)Mth.floor((double)this.getY()) + 1.0f)) - 1.0), (double)(d2 = this.getZ() + (double)(f2 * (float)this.timeUntilHooked * 0.1f))));
                if (blockstate.is(Blocks.WATER)) {
                    this.fluid = Fluids.WATER.defaultFluidState();
                    if (this.random.nextFloat() < 0.15f) {
                        level.sendParticles((ParticleOptions)ParticleTypes.BUBBLE, d0, d1 - (double)0.1f, d2, 1, (double)f1, 0.1, (double)f2, 0.0);
                    }
                    float f3 = f1 * 0.04f;
                    float f4 = f2 * 0.04f;
                    level.sendParticles((ParticleOptions)ParticleTypes.FISHING, d0, d1, d2, 0, (double)f4, 0.01, (double)(-f3), 1.0);
                    level.sendParticles((ParticleOptions)ParticleTypes.FISHING, d0, d1, d2, 0, (double)(-f4), 0.01, (double)f3, 1.0);
                } else if (blockstate.is(Blocks.LAVA)) {
                    this.fluid = Fluids.LAVA.defaultFluidState();
                    if (this.random.nextFloat() < 0.15f) {
                        level.sendParticles((ParticleOptions)ParticleTypes.FLAME, d0, d1 - (double)0.1f, d2, 1, (double)f1, 0.1, (double)f2, 0.0);
                    }
                    float f3 = f1 * 0.04f;
                    float f4 = f2 * 0.04f;
                    level.sendParticles((ParticleOptions)ParticleTypes.LAVA, d0, d1, d2, 0, (double)f4, 0.01, (double)(-f3), 1.0);
                    level.sendParticles((ParticleOptions)ParticleTypes.SMOKE, d0, d1, d2, 0, 0.0, 0.01, 0.0, 1.0);
                    level.sendParticles((ParticleOptions)ParticleTypes.LAVA, d0, d1, d2, 0, (double)(-f4), 0.01, (double)f3, 1.0);
                }
            } else {
                if (this.fluid.is(TideTags.Fluids.LAVA_FISHING)) {
                    this.playSound(SoundEvents.BUCKET_EMPTY_LAVA, 0.25f, 1.0f + (this.random.nextFloat() - this.random.nextFloat()) * 0.4f);
                    if (Tide.PLATFORM.isModLoaded("stardew_fishing")) {
                        this.playSound(SoundEvents.FISHING_BOBBER_SPLASH, 0.25f, 1.0f + (this.random.nextFloat() - this.random.nextFloat()) * 0.4f);
                    }
                    double d3 = this.getY() + 0.5;
                    level.sendParticles((ParticleOptions)ParticleTypes.LAVA, this.getX(), d3, this.getZ(), (int)(1.0f + this.getBbWidth() * 20.0f), (double)this.getBbWidth(), 0.0, (double)this.getBbWidth(), (double)0.2f);
                    level.sendParticles((ParticleOptions)ParticleTypes.SMOKE, this.getX(), d3, this.getZ(), (int)(1.0f + this.getBbWidth() * 20.0f), (double)this.getBbWidth(), 0.0, (double)this.getBbWidth(), (double)0.2f);
                } else {
                    this.playSound(SoundEvents.FISHING_BOBBER_SPLASH, 0.25f, 1.0f + (this.random.nextFloat() - this.random.nextFloat()) * 0.4f);
                    double d3 = this.getY() + 0.5;
                    level.sendParticles((ParticleOptions)ParticleTypes.BUBBLE, this.getX(), d3, this.getZ(), (int)(1.0f + this.getBbWidth() * 20.0f), (double)this.getBbWidth(), 0.0, (double)this.getBbWidth(), (double)0.2f);
                    level.sendParticles((ParticleOptions)ParticleTypes.FISHING, this.getX(), d3, this.getZ(), (int)(1.0f + this.getBbWidth() * 20.0f), (double)this.getBbWidth(), 0.0, (double)this.getBbWidth(), (double)0.2f);
                }
                this.nibble = Mth.nextInt((RandomSource)this.random, (int)20, (int)40);
                this.getEntityData().set(DATA_BITING, (Object)true);
                if (this.getPlayerOwner() != null) {
                    this.selectCatch(this.getPlayerOwner(), this.rod);
                } else {
                    this.catchType = CatchType.NOTHING;
                    this.getEntityData().set(DATA_CATCH_TYPE, (Object)this.catchType.ordinal());
                }
            }
        } else if (this.timeUntilLured > 0) {
            this.timeUntilLured -= i;
            float f5 = 0.15f;
            if (this.timeUntilLured < 20) {
                f5 += (float)(20 - this.timeUntilLured) * 0.05f;
            } else if (this.timeUntilLured < 40) {
                f5 += (float)(40 - this.timeUntilLured) * 0.02f;
            } else if (this.timeUntilLured < 60) {
                f5 += (float)(60 - this.timeUntilLured) * 0.01f;
            }
            if (this.random.nextFloat() < f5) {
                double d6;
                double d5;
                float f6 = Mth.nextFloat((RandomSource)this.random, (float)0.0f, (float)360.0f) * ((float)Math.PI / 180);
                float f7 = Mth.nextFloat((RandomSource)this.random, (float)25.0f, (float)60.0f);
                double d4 = this.getX() + (double)(Mth.sin((float)f6) * f7) * 0.1;
                BlockState blockstate1 = level.getBlockState(BlockPos.containing((double)d4, (double)((d5 = (double)((float)Mth.floor((double)this.getY()) + 1.0f)) - 1.0), (double)(d6 = this.getZ() + (double)(Mth.cos((float)f6) * f7) * 0.1)));
                if (blockstate1.is(Blocks.WATER)) {
                    level.sendParticles((ParticleOptions)ParticleTypes.SPLASH, d4, d5, d6, 2 + this.random.nextInt(2), (double)0.1f, 0.0, (double)0.1f, 0.0);
                } else if (blockstate1.is(Blocks.LAVA)) {
                    level.sendParticles((ParticleOptions)ParticleTypes.LAVA, d4, d5, d6, 2 + this.random.nextInt(2), (double)0.1f, 0.0, (double)0.1f, 0.0);
                }
            }
            if (this.timeUntilLured <= 0) {
                this.fishAngle = Mth.nextFloat((RandomSource)this.random, (float)0.0f, (float)360.0f);
                this.timeUntilHooked = Mth.nextInt((RandomSource)this.random, (int)20, (int)80);
            }
        } else {
            this.timeUntilLured = Mth.nextInt((RandomSource)this.random, (int)100, (int)600);
            this.timeUntilLured -= this.lureSpeed * 20 * 5;
        }
    }

    public void restartFishingSequence() {
        this.catchType = CatchType.NOTHING;
        this.getEntityData().set(DATA_CATCH_TYPE, (Object)this.catchType.ordinal());
        this.timeUntilLured = 0;
        this.timeUntilHooked = 0;
        this.getEntityData().set(DATA_BITING, (Object)false);
    }

    private boolean calculateOpenWater(BlockPos p_37159_) {
        OpenFluidType openWaterType = OpenFluidType.INVALID;
        for (int i = -1; i <= 2; ++i) {
            OpenFluidType openWaterType1 = this.getOpenWaterTypeForArea(p_37159_.offset(-2, i, -2), p_37159_.offset(2, i, 2));
            switch (openWaterType1.ordinal()) {
                case 2: {
                    return false;
                }
                case 0: {
                    if (openWaterType != OpenFluidType.INVALID) break;
                    return false;
                }
                case 1: {
                    if (openWaterType != OpenFluidType.ABOVE_WATER) break;
                    return false;
                }
            }
            openWaterType = openWaterType1;
        }
        return true;
    }

    private OpenFluidType getOpenWaterTypeForArea(BlockPos p_37148_, BlockPos p_37149_) {
        return BlockPos.betweenClosedStream((BlockPos)p_37148_, (BlockPos)p_37149_).map(this::getOpenWaterTypeForBlock).reduce((p_37139_, p_37140_) -> p_37139_ == p_37140_ ? p_37139_ : OpenFluidType.INVALID).orElse(OpenFluidType.INVALID);
    }

    private OpenFluidType getOpenWaterTypeForBlock(BlockPos p_37164_) {
        BlockState blockstate = this.level().getBlockState(p_37164_);
        if (!blockstate.isAir() && !blockstate.is(Blocks.LILY_PAD)) {
            FluidState fluidstate = blockstate.getFluidState();
            return this.canFishIn(fluidstate) && fluidstate.isSource() && blockstate.getCollisionShape((BlockGetter)this.level(), p_37164_).isEmpty() ? OpenFluidType.INSIDE_WATER : OpenFluidType.INVALID;
        }
        return OpenFluidType.ABOVE_WATER;
    }

    public void addAdditionalSaveData(CompoundTag tag) {
    }

    public void readAdditionalSaveData(CompoundTag tag) {
    }

    public void retrieve() {
        this.getRodItem().retrieveHook(this.rod, this.getPlayerOwner(), this.level());
    }

    public int retrieve(ItemStack stack, ServerLevel level, Player player) {
        if (!this.level().isClientSide && player != null && !this.shouldStopFishing(player)) {
            int i = 0;
            if (this.getHookedIn() != null) {
                this.pullEntity(this.getHookedIn());
                CriteriaTriggers.FISHING_ROD_HOOKED.trigger((ServerPlayer)player, stack, player.fishing, Collections.emptyList());
                this.level().broadcastEntityEvent((Entity)this, (byte)31);
                i = this.getHookedIn() instanceof ItemEntity ? 3 : 5;
            } else if (this.nibble > 0) {
                ArrayList<ItemStack> itemList = new ArrayList<ItemStack>();
                switch (this.catchType.ordinal()) {
                    case 0: 
                    case 2: {
                        boolean canceled;
                        if (!this.hasHookedItem()) {
                            return 0;
                        }
                        itemList.add(this.hookedItem);
                        if (this.fluid.is(TideTags.Fluids.LAVA_FISHING)) {
                            TideCriteriaTriggers.FISHED_IN_LAVA.trigger((ServerPlayer)player);
                        }
                        if (canceled = Tide.PLATFORM.forgeItemFishedEvent(itemList, this.onGround() ? 2 : 1, player.fishing)) {
                            this.discard();
                            return 1;
                        }
                        ItemEntity itemEntity = new ItemEntity(this.level(), this.getX(), this.getY(), this.getZ(), this.hookedItem);
                        double d0 = player.getX() - this.getX();
                        double d1 = player.getY() - this.getY();
                        double d2 = player.getZ() - this.getZ();
                        itemEntity.setDeltaMovement(d0 * 0.1, d1 * 0.1 + Math.sqrt(Math.sqrt(d0 * d0 + d1 * d1 + d2 * d2)) * 0.08, d2 * 0.1);
                        this.level().addFreshEntity((Entity)itemEntity);
                        player.level().addFreshEntity((Entity)new ExperienceOrb(player.level(), player.getX(), player.getY() + 0.5, player.getZ() + 0.5, this.random.nextInt(6) + 1));
                        if (this.hookedItem.is(ItemTags.FISHES)) {
                            player.awardStat(Stats.FISH_CAUGHT, 1);
                        }
                        CriteriaTriggers.FISHING_ROD_HOOKED.trigger((ServerPlayer)player, stack, player.fishing, itemList);
                        Tide.LOG.info("Caught fish: {}", (Object)this.hookedItem.getDescriptionId());
                        break;
                    }
                    case 1: {
                        ResourceKey<LootTable> lootTable = TideUtils.getCrateLoot(this.getX(), this.getY(), this.getZ(), this.fluid, this.level());
                        BlockState lootCrate = this.getCrateBlock(this.fluid);
                        LootParams.Builder lootParamsBuilder = new LootParams.Builder((ServerLevel)this.level()).withParameter(LootContextParams.ORIGIN, (Object)this.position()).withParameter(LootContextParams.TOOL, (Object)stack).withParameter(LootContextParams.THIS_ENTITY, (Object)this);
                        if (!Tide.PLATFORM.isFabric()) {
                            lootParamsBuilder = lootParamsBuilder.withParameter(LootContextParams.ATTACKING_ENTITY, (Object)Objects.requireNonNull(this.getOwner()));
                        }
                        LootParams lootParams = lootParamsBuilder.withLuck((float)this.luck + player.getLuck()).create(LootContextParamSets.FISHING);
                        level.setBlockAndUpdate(this.blockPosition(), lootCrate);
                        double dx = player.getX() - (double)this.blockPosition().getX();
                        double dy = player.getY() - (double)this.blockPosition().getY();
                        double dz = player.getZ() - (double)this.blockPosition().getZ();
                        LootCrateEntity.fall((Level)level, this.blockPosition(), lootCrate, dx * 0.0666, dy * 0.0666 + Math.sqrt(Math.sqrt(dx * dx + dy * dy + dz * dz)) * 0.082 + 0.27, dz * 0.0666, lootTable, lootParams);
                        if (this.fluid.is(TideTags.Fluids.LAVA_FISHING) && this.fluid.is((Fluid)Fluids.LAVA)) {
                            level.setBlockAndUpdate(this.blockPosition(), Blocks.LAVA.defaultBlockState());
                        }
                        if (this.fluid.is(TideTags.Fluids.WATER_FISHING) && this.fluid.is((Fluid)Fluids.WATER)) {
                            level.setBlockAndUpdate(this.blockPosition(), Blocks.WATER.defaultBlockState());
                        }
                        TideCriteriaTriggers.FISHED_CRATE.trigger((ServerPlayer)player);
                        break;
                    }
                }
                i = 1;
            }
            if (this.onGround()) {
                i = 2;
            }
            this.startRetrieving();
            if (this.getLineModifier() == LineModifier.REINFORCED) {
                i -= new Random().nextFloat() > 0.7f ? 1 : 0;
            }
            return i;
        }
        return 0;
    }

    public void selectCatch(Player player, ItemStack rod) {
        this.catchType = CatchType.NOTHING;
        this.hookedItem = null;
        boolean pullCrate = false;
        if (player.getOffhandItem().is(TideItems.MAGNETIC_BAIT)) {
            if (this.random.nextInt(0, 4) == 0) {
                pullCrate = true;
            }
        } else if (this.random.nextInt(0, 20) == 0) {
            pullCrate = true;
        }
        if (TideUtils.moddedDimension((ResourceKey<Level>)this.level().dimension())) {
            pullCrate = false;
        }
        if (pullCrate) {
            this.catchType = CatchType.CRATE;
        } else {
            LootParams.Builder lootParamsBuilder = new LootParams.Builder((ServerLevel)this.level()).withParameter(LootContextParams.ORIGIN, (Object)this.position()).withParameter(LootContextParams.TOOL, (Object)rod).withParameter(LootContextParams.THIS_ENTITY, (Object)this);
            if (!Tide.PLATFORM.isFabric()) {
                lootParamsBuilder = lootParamsBuilder.withParameter(LootContextParams.ATTACKING_ENTITY, (Object)Objects.requireNonNull(this.getOwner()));
            }
            LootParams lootParams = lootParamsBuilder.withLuck((float)this.luck + player.getLuck()).create(LootContextParamSets.CHEST);
            ResourceKey<LootTable> lootKey = BuiltInLootTables.FISHING;
            LootTable table = this.level().getServer().reloadableRegistries().getLootTable((ResourceKey)lootKey);
            ServerLevel overworld = this.level().getServer().overworld();
            Object list = table.getRandomItems(lootParams);
            if (list.isEmpty()) {
                list = ObjectArrayList.of((Object[])new ItemStack[]{Items.SALMON.getDefaultInstance()});
            }
            if (TideUtils.shouldGrabTideLootTable((List<ItemStack>)(list = TideUtils.checkForOverrides((List<ItemStack>)list, this, overworld)), this.fluid)) {
                lootKey = TideUtils.getTideLootTable(this.getX(), this.getY(), this.getZ(), this.fluid, this.level(), this.random);
                table = this.level().getServer().reloadableRegistries().getLootTable(lootKey);
                list = table.getRandomItems(lootParams);
            }
            Tide.LOG.info("Loot table used: {}", (Object)lootKey.location());
            this.hookedItem = list.size() == 1 ? (ItemStack)list.getFirst() : (ItemStack)list.get(new Random().nextInt(0, list.size()));
            CatchType catchType = this.catchType = this.hookedItem.is(ItemTags.FISHES) || TideUtils.isJournalFish(this.hookedItem) ? CatchType.FISH : CatchType.ITEM;
        }
        if (TideUtils.isHoldingBait(player)) {
            if (!player.isCreative()) {
                player.getOffhandItem().shrink(1);
            }
            Tide.LOG.info("Using bait");
        }
        this.getEntityData().set(DATA_CATCH_TYPE, (Object)this.catchType.ordinal());
    }

    public BlockState getCrateBlock(FluidState fluid) {
        Level level = this.level();
        if (fluid.getType() == Fluids.LAVA) {
            if (level.dimension() == Level.NETHER) {
                return TideBlocks.OBSIDIAN_LOOT_CRATE.defaultBlockState();
            }
            if (level.dimension() == Level.END) {
                return TideBlocks.END_LOOT_CRATE.defaultBlockState();
            }
            return TideBlocks.OBSIDIAN_LOOT_CRATE.defaultBlockState();
        }
        if (level.dimension() == Level.END) {
            return TideBlocks.END_LOOT_CRATE.defaultBlockState();
        }
        return TideBlocks.SURFACE_LOOT_CRATE.defaultBlockState();
    }

    public void handleEntityEvent(byte event) {
        if (event == 31 && this.level().isClientSide && this.hookedIn instanceof Player && ((Player)this.hookedIn).isLocalPlayer()) {
            this.pullEntity(this.hookedIn);
        }
        super.handleEntityEvent(event);
    }

    protected void pullEntity(Entity entity) {
        Entity owner = this.getOwner();
        if (owner != null) {
            Vec3 vec3 = new Vec3(owner.getX() - this.getX(), owner.getY() - this.getY(), owner.getZ() - this.getZ()).scale(0.1);
            entity.setDeltaMovement(entity.getDeltaMovement().add(vec3));
        }
    }

    protected void startRetrieving() {
        this.catchType = CatchType.NOTHING;
        this.discard();
    }

    protected Entity.MovementEmission getMovementEmission() {
        return Entity.MovementEmission.NONE;
    }

    public void remove(Entity.RemovalReason reason) {
        this.updateOwnerInfo(null);
        super.remove(reason);
    }

    public void onClientRemoval() {
        this.updateOwnerInfo(null);
    }

    public void setOwner(Entity entity) {
        super.setOwner(entity);
        this.updateOwnerInfo(this);
    }

    private void updateOwnerInfo(TideFishingHook hook) {
        Player player = this.getPlayerOwner();
        if (player != null) {
            if (hook == null && player.fishing != null) {
                ((HookAccessor)player.fishing).clearHook(player);
            }
            if (player.fishing == null && hook != null) {
                player.fishing = new HookAccessor(hook, this.level());
            }
        }
    }

    public Player getPlayerOwner() {
        Entity entity = this.getOwner();
        return entity instanceof Player ? (Player)entity : null;
    }

    public Entity getHookedIn() {
        return this.hookedIn;
    }

    public void recreateFromPacket(ClientboundAddEntityPacket p_150150_) {
        super.recreateFromPacket(p_150150_);
        if (this.getPlayerOwner() == null) {
            int i = p_150150_.getData();
            LOGGER.error("Failed to recreate fishing hook on client. {} (id: {}) is not a valid owner.", (Object)this.level().getEntity(i), (Object)i);
            this.kill();
        }
    }

    public boolean fireImmune() {
        if (this.canFishInLava()) {
            return true;
        }
        return super.fireImmune();
    }

    public boolean isOnFire() {
        if (this.canFishInLava()) {
            return false;
        }
        return super.isOnFire();
    }

    public boolean canFishIn(FluidState fluidState) {
        if (fluidState.is(TideTags.Fluids.LAVA_FISHING)) {
            return this.canFishInLava();
        }
        return fluidState.is(TideTags.Fluids.CAN_FISH_IN);
    }

    public boolean canFishInLava() {
        return this.getRodItem().isLavaproof(this.rod);
    }

    public TideFishingRodItem getRodItem() {
        return (TideFishingRodItem)this.rod.getItem();
    }

    public BobberModifier getBobberModifier() {
        return CustomRodManager.getBobber(this.rod);
    }

    public HookModifier getHookModifier() {
        return CustomRodManager.getHook(this.rod);
    }

    public LineModifier getLineModifier() {
        return CustomRodManager.getLine(this.rod);
    }

    public boolean hasHookedItem() {
        return this.hookedItem != null && !this.hookedItem.is(Items.AIR);
    }

    public Item getHookedItem() {
        return this.hookedItem.getItem();
    }

    public void setMinigameActive(boolean state) {
        this.minigameActive = state;
        if (!this.minigameActive) {
            this.nibble = 0;
        }
        this.entityData.set(DATA_MINIGAME_ACTIVE, (Object)state);
    }

    public CatchType getCatchType() {
        return CatchType.values()[(Integer)this.getEntityData().get(DATA_CATCH_TYPE)];
    }

    static enum FishHookState {
        FLYING,
        HOOKED_IN_ENTITY,
        BOBBING;

    }

    public static enum CatchType {
        FISH,
        CRATE,
        ITEM,
        NOTHING;

    }

    static enum OpenFluidType {
        ABOVE_WATER,
        INSIDE_WATER,
        INVALID;

    }
}

