/*
 * Decompiled with CFR 0.152.
 */
package com.li64.tide.registries.entities.misc.fishing;

import com.li64.tide.registries.TideEntityTypes;
import com.li64.tide.registries.entities.misc.fishing.TideFishingHook;
import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.FishingHook;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;

public class HookAccessor
extends FishingHook {
    private TideFishingHook hook = null;

    public HookAccessor(TideFishingHook hook, Level level) {
        super(TideEntityTypes.HOOK_ACCESSOR, level);
        this.hook = hook;
    }

    public HookAccessor(EntityType<? extends FishingHook> entityType, Level level) {
        super(entityType, level);
    }

    public static boolean bobberRemoved(Player player) {
        return player == null || player.fishing == null || HookAccessor.getHook(player) == null;
    }

    public void clearHook(Player player) {
        this.hook = null;
        player.fishing = null;
    }

    public boolean isFishing() {
        return this.hook != null;
    }

    public static TideFishingHook getHook(Player player) {
        HookAccessor placeholder = (HookAccessor)player.fishing;
        if (placeholder != null) {
            return placeholder.hook;
        }
        return null;
    }

    public boolean isOpenWaterFishing() {
        return this.hook.isOpenWaterFishing();
    }

    public double getX() {
        return this.hook.getX();
    }

    public double getY() {
        return this.hook.getY();
    }

    public double getZ() {
        return this.hook.getZ();
    }

    public void remove(Entity.RemovalReason reason) {
        this.hook.remove(reason);
        super.remove(reason);
    }

    public Vec3 position() {
        return this.hook.position();
    }

    public BlockPos blockPosition() {
        return this.hook.blockPosition();
    }

    @Nullable
    public Player getPlayerOwner() {
        return this.hook.getPlayerOwner();
    }
}

