/*
 * Decompiled with CFR 0.152.
 */
package com.li64.tide.registries.entities.misc;

import com.li64.tide.registries.TideEntityTypes;
import com.li64.tide.registries.TideItems;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;

public class DeepAquaArrow
extends AbstractArrow {
    public int lifetime = 50;
    private static final ItemStack DEFAULT_ARROW_STACK = new ItemStack((ItemLike)TideItems.DEEP_AQUA_ARROW);

    public DeepAquaArrow(EntityType<? extends AbstractArrow> entityType, Level level) {
        super(entityType, level);
    }

    public DeepAquaArrow(Level level, LivingEntity entity, ItemStack itemStack, ItemStack itemStack1) {
        super(TideEntityTypes.DEEP_AQUA_ARROW, entity, level, itemStack, itemStack1);
    }

    public void tick() {
        super.tick();
        if (!this.onGround()) {
            Vec3 vel = this.getDeltaMovement();
            double d5 = vel.x;
            double d6 = vel.y;
            double d1 = vel.z;
            for (int i = 0; i < 4; ++i) {
                this.level().addParticle((ParticleOptions)ParticleTypes.SPLASH, this.getX() + d5 * (double)i / 4.0, this.getY() + d6 * (double)i / 4.0, this.getZ() + d1 * (double)i / 4.0, -d5, -d6 + 0.2, -d1);
            }
            if (!this.level().isClientSide()) {
                --this.lifetime;
                if (this.lifetime <= 0) {
                    this.playSplashParticles(this.blockPosition());
                    this.kill();
                }
            }
        }
    }

    protected void onHit(HitResult hitResult) {
        HitResult.Type hitType = hitResult.getType();
        if (hitType == HitResult.Type.ENTITY) {
            this.onHitEntity((EntityHitResult)hitResult);
            this.level().gameEvent((Holder)GameEvent.PROJECTILE_LAND, hitResult.getLocation(), GameEvent.Context.of((Entity)this, null));
            this.playSplashParticles(this.blockPosition());
        } else if (hitType == HitResult.Type.BLOCK) {
            BlockHitResult blockhitresult = (BlockHitResult)hitResult;
            this.onHitBlock(blockhitresult);
            BlockPos blockpos = blockhitresult.getBlockPos();
            this.playSplashParticles(blockpos);
            this.level().gameEvent((Holder)GameEvent.PROJECTILE_LAND, blockpos, GameEvent.Context.of((Entity)this, (BlockState)this.level().getBlockState(blockpos)));
            this.kill();
        }
    }

    private void playSplashParticles(BlockPos pos) {
        for (int i = 0; i < 15; ++i) {
            this.level().addParticle((ParticleOptions)ParticleTypes.SPLASH, (double)pos.getX() + 0.5, (double)pos.getY() + 0.7, (double)pos.getZ() + 0.5, (double)(this.random.nextFloat() * 1.5f), 0.2, (double)(this.random.nextFloat() * 1.5f));
        }
    }

    @NotNull
    public Vec3 getDeltaMovement() {
        if (this.isCritArrow()) {
            return super.getDeltaMovement().normalize().scale(2.5);
        }
        return super.getDeltaMovement().normalize().scale((double)1.8f);
    }

    public boolean isNoGravity() {
        return true;
    }

    public void setNoGravity(boolean value) {
        super.setNoGravity(false);
    }

    @NotNull
    protected ItemStack getDefaultPickupItem() {
        return new ItemStack((ItemLike)TideItems.DEEP_AQUA_ARROW);
    }
}

