/*
 * Decompiled with CFR 0.152.
 */
package com.li64.tide.registries.blocks;

import com.li64.tide.registries.blocks.entities.LootCrateBlockEntity;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.Container;
import net.minecraft.world.Containers;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;

public abstract class AbstractLootCrateBlock<E extends BlockEntity>
extends BaseEntityBlock {
    protected final Supplier<BlockEntityType<? extends E>> blockEntityType;
    public static final BooleanProperty OPEN = BlockStateProperties.OPEN;

    protected AbstractLootCrateBlock(BlockBehaviour.Properties properties, Supplier<BlockEntityType<? extends E>> p_48678_) {
        super(properties);
        this.blockEntityType = p_48678_;
        this.registerDefaultState((BlockState)this.defaultBlockState().setValue((Property)OPEN, (Comparable)Boolean.valueOf(false)));
    }

    protected InteractionResult useWithoutItem(BlockState state, Level level, BlockPos pos, Player player, BlockHitResult result) {
        if (level.isClientSide) {
            return InteractionResult.SUCCESS;
        }
        BlockEntity blockentity = level.getBlockEntity(pos);
        if (blockentity instanceof LootCrateBlockEntity) {
            LootCrateBlockEntity block = (LootCrateBlockEntity)blockentity;
            player.openMenu((MenuProvider)block);
        }
        return InteractionResult.CONSUME;
    }

    public void onRemove(BlockState state, Level level, BlockPos p_49078_, BlockState p_49079_, boolean p_49080_) {
        if (!state.is(p_49079_.getBlock())) {
            BlockEntity blockentity = level.getBlockEntity(p_49078_);
            if (blockentity instanceof Container) {
                Containers.dropContents((Level)level, (BlockPos)p_49078_, (Container)((Container)blockentity));
                level.updateNeighbourForOutputSignal(p_49078_, (Block)this);
            }
            super.onRemove(state, level, p_49078_, p_49079_, p_49080_);
        }
    }

    public void tick(BlockState p_220758_, ServerLevel p_220759_, BlockPos p_220760_, RandomSource p_220761_) {
        BlockEntity blockentity = p_220759_.getBlockEntity(p_220760_);
        if (blockentity instanceof LootCrateBlockEntity) {
            ((LootCrateBlockEntity)blockentity).recheckOpen();
        }
    }

    public RenderShape getRenderShape(BlockState p_49090_) {
        return RenderShape.MODEL;
    }

    public boolean hasAnalogOutputSignal(BlockState p_49058_) {
        return true;
    }

    public int getAnalogOutputSignal(BlockState p_49065_, Level p_49066_, BlockPos p_49067_) {
        return AbstractContainerMenu.getRedstoneSignalFromBlockEntity((BlockEntity)p_49066_.getBlockEntity(p_49067_));
    }

    public BlockState getStateForPlacement(BlockPlaceContext p_49820_) {
        return (BlockState)this.defaultBlockState().setValue((Property)OPEN, (Comparable)Boolean.valueOf(false));
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{OPEN});
    }
}

