/*
 * Decompiled with CFR 0.152.
 */
package com.li64.tide.registries;

import com.li64.tide.Tide;
import com.li64.tide.registries.blocks.AlgaeBlock;
import com.li64.tide.registries.blocks.AnglerWorkshopBlock;
import com.li64.tide.registries.blocks.EndLootCrateBlock;
import com.li64.tide.registries.blocks.JellyTorchBlock;
import com.li64.tide.registries.blocks.JellyWallTorchBlock;
import com.li64.tide.registries.blocks.ObsidianLootCrateBlock;
import com.li64.tide.registries.blocks.SurfaceLootCrateBlock;
import java.util.HashMap;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockBehaviour;

public class TideBlocks {
    public static final HashMap<String, Block> BLOCKS = new HashMap();
    public static Block SURFACE_LOOT_CRATE = TideBlocks.register("surface_loot_crate", new SurfaceLootCrateBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.BARREL)));
    public static Block OBSIDIAN_LOOT_CRATE = TideBlocks.register("obsidian_loot_crate", new ObsidianLootCrateBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.OBSIDIAN)));
    public static Block END_LOOT_CRATE = TideBlocks.register("end_loot_crate", new EndLootCrateBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.PURPUR_PILLAR)));
    public static Block ANGLER_WORKSHOP = TideBlocks.register("angler_workshop", new AnglerWorkshopBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.CRAFTING_TABLE)));
    public static Block ALGAE = TideBlocks.register("algae", new AlgaeBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.LILY_PAD).sound(SoundType.CROP).noCollission()));
    public static Block JELLY_TORCH = TideBlocks.register("jelly_torch", new JellyTorchBlock(ParticleTypes.END_ROD, BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.TORCH).sound(SoundType.SLIME_BLOCK)));
    public static Block JELLY_WALL_TORCH = TideBlocks.register("jelly_wall_torch", new JellyWallTorchBlock(ParticleTypes.END_ROD, BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)JELLY_TORCH)));

    public static <T extends Block> T register(String key, T block) {
        BLOCKS.put(key, block);
        return block;
    }

    public static void init() {
        BLOCKS.forEach(Tide.PLATFORM::registerBlock);
    }
}

