/*
 * Decompiled with CFR 0.152.
 */
package com.li64.tide.network.messages;

import com.li64.tide.Tide;
import com.li64.tide.client.TideClientHelper;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.NotNull;

public class ShowToastMsg
implements CustomPacketPayload {
    public static final CustomPacketPayload.Type<ShowToastMsg> TYPE = new CustomPacketPayload.Type(Tide.resource("show_toast"));
    public final Component title;
    public final Component description;
    public final ItemStack display;

    public ShowToastMsg(Component title, Component description, ItemStack display) {
        this.title = title;
        this.description = description;
        this.display = display;
    }

    public ShowToastMsg(FriendlyByteBuf buf) {
        this.title = Component.translatable((String)buf.readUtf());
        this.description = Component.translatable((String)buf.readUtf());
        this.display = ((Item)BuiltInRegistries.ITEM.get((ResourceLocation)ResourceLocation.read((String)buf.readUtf()).getOrThrow())).getDefaultInstance();
    }

    public static void encode(ShowToastMsg message, FriendlyByteBuf buf) {
        buf.writeUtf(message.title.getString());
        buf.writeUtf(message.description.getString());
        buf.writeUtf(BuiltInRegistries.ITEM.getKey((Object)message.display.getItem()).toString());
    }

    public static void handle(ShowToastMsg message, Player player) {
        TideClientHelper.showToast(message.title, message.description, message.display);
    }

    @NotNull
    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return TYPE;
    }
}

