/*
 * Decompiled with CFR 0.152.
 */
package com.li64.tide.loot.modifiers;

import com.li64.tide.registries.TideItems;
import com.mojang.serialization.MapCodec;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.storage.loot.BuiltInLootTables;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.neoforged.neoforge.common.loot.IGlobalLootModifier;
import net.neoforged.neoforge.common.loot.LootModifier;
import org.jetbrains.annotations.NotNull;

public class FishingJunkModifier
extends LootModifier {
    public static final MapCodec<FishingJunkModifier> CODEC = FishingJunkModifier.newCodec();

    public FishingJunkModifier() {
        super(new LootItemCondition[0]);
    }

    @NotNull
    protected ObjectArrayList<ItemStack> doApply(ObjectArrayList<ItemStack> generatedLoot, LootContext context) {
        if (generatedLoot.isEmpty()) {
            return generatedLoot;
        }
        if (!context.getQueriedLootTableId().toString().matches(BuiltInLootTables.FISHING_JUNK.location().toString())) {
            return generatedLoot;
        }
        if (context.getRandom().nextInt(10) == 0) {
            generatedLoot.set(0, (Object)TideItems.FISH_BONE.getDefaultInstance());
        }
        return generatedLoot;
    }

    public static MapCodec<FishingJunkModifier> newCodec() {
        return MapCodec.unit(FishingJunkModifier::new);
    }

    public MapCodec<? extends IGlobalLootModifier> codec() {
        return CODEC;
    }
}

