/*
 * Decompiled with CFR 0.152.
 */
package com.li64.tide.data.rods;

import com.li64.tide.Tide;
import com.li64.tide.registries.TideItems;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;

public enum HookModifier {
    NORMAL(TideItems.FISHING_HOOK, "hook.tide.normal", false),
    IRON(TideItems.IRON_FISHING_HOOK, "hook.tide.iron", false),
    LAVAPROOF(TideItems.LAVAPROOF_FISHING_HOOK, "hook.tide.lavaproof", true);

    public static final HookModifier DEFAULT;
    final Item item;
    final String translationKey;
    final boolean isLavaproof;
    ResourceLocation textureLocation;

    private HookModifier(Item item, String translationKey, boolean isLavaproof) {
        this.item = item;
        this.translationKey = translationKey;
        this.isLavaproof = isLavaproof;
    }

    public Item getItem() {
        return this.item;
    }

    public String getTranslationKey() {
        return this.translationKey;
    }

    public ResourceLocation getTextureLocation() {
        if (this.textureLocation == null) {
            this.textureLocation = Tide.resource(this.getTexturePath());
        }
        return this.textureLocation;
    }

    public boolean isLavaproof() {
        return this.isLavaproof;
    }

    private String getTexturePath() {
        return switch (this.ordinal()) {
            default -> throw new MatchException(null, null);
            case 0 -> "textures/entity/fishing_hook/fishing_hook.png";
            case 1 -> "textures/entity/fishing_hook/iron_fishing_hook.png";
            case 2 -> "textures/entity/fishing_hook/lavaproof_fishing_hook.png";
        };
    }

    static {
        DEFAULT = NORMAL;
    }
}

