/*
 * Decompiled with CFR 0.152.
 */
package com.li64.tide.data.player;

import com.li64.tide.Tide;
import com.li64.tide.client.gui.JournalPage;
import com.li64.tide.data.journal.JournalLayout;
import com.li64.tide.network.messages.SyncDataMsg;
import com.li64.tide.util.TideUtils;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;

public class TidePlayerData {
    public static TidePlayerData CLIENT_DATA = new TidePlayerData();
    private static final String NBT_TAG = "TidePlayerData";
    public List<Integer> fishUnlocked = new ArrayList<Integer>();
    public List<Integer> unreadProfiles = new ArrayList<Integer>();
    public List<Integer> pagesUnlocked = new ArrayList<Integer>();
    public List<Integer> pagesCompleted = new ArrayList<Integer>();
    public boolean gotJournal = false;
    public boolean finishedJournal = false;

    public static TidePlayerData getOrCreate(ServerPlayer player) {
        return TidePlayerData.getOrCreate(Tide.PLATFORM.getPlayerData(player));
    }

    public static TidePlayerData getOrCreate(CompoundTag tag) {
        if (!tag.contains(NBT_TAG)) {
            tag.put(NBT_TAG, (Tag)new CompoundTag());
        }
        return new TidePlayerData(tag.getCompound(NBT_TAG));
    }

    public TidePlayerData(CompoundTag tag) {
        this.deserializeNBT(tag);
    }

    public TidePlayerData() {
    }

    public void deserializeNBT(CompoundTag tag) {
        this.fishUnlocked = TidePlayerData.fromIntArray(tag.getIntArray("fish_unlocked"));
        this.unreadProfiles = TidePlayerData.fromIntArray(tag.getIntArray("unread_pages"));
        this.pagesUnlocked = TidePlayerData.fromIntArray(tag.getIntArray("pages_unlocked"));
        this.pagesCompleted = TidePlayerData.fromIntArray(tag.getIntArray("pages_completed"));
        this.gotJournal = tag.getBoolean("got_journal");
        this.finishedJournal = tag.getBoolean("finished_journal");
    }

    public CompoundTag serializeNBT() {
        CompoundTag tag = new CompoundTag();
        tag.putIntArray("fish_unlocked", this.fishUnlocked);
        tag.putIntArray("unread_pages", this.unreadProfiles);
        tag.putIntArray("pages_unlocked", this.pagesUnlocked);
        tag.putIntArray("pages_completed", this.pagesCompleted);
        tag.putBoolean("got_journal", this.gotJournal);
        tag.putBoolean("finished_journal", this.finishedJournal);
        return tag;
    }

    public void syncTo(ServerPlayer player) {
        CompoundTag playerData = Tide.PLATFORM.getPlayerData(player);
        playerData.put(NBT_TAG, (Tag)this.serializeNBT());
        if (player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = player;
            Tide.NETWORK.sendToPlayer(new SyncDataMsg(this), serverPlayer);
        }
    }

    public static ArrayList<Integer> fromIntArray(int[] array) {
        ArrayList<Integer> newList = new ArrayList<Integer>();
        for (int value : array) {
            newList.add(value);
        }
        return newList;
    }

    public int[] pagesIntArray() {
        int[] intArray = new int[this.pagesUnlocked.size()];
        for (int i = 0; i < this.pagesUnlocked.size(); ++i) {
            intArray[i] = this.pagesUnlocked.get(i);
        }
        return intArray;
    }

    public int[] pagesCompletedIntArray() {
        int[] intArray = new int[this.pagesUnlocked.size()];
        for (int i = 0; i < this.pagesUnlocked.size(); ++i) {
            intArray[i] = this.pagesUnlocked.get(i);
        }
        return intArray;
    }

    public int[] fishIntArray() {
        int[] intArray = new int[this.fishUnlocked.size()];
        for (int i = 0; i < this.fishUnlocked.size(); ++i) {
            intArray[i] = this.fishUnlocked.get(i);
        }
        return intArray;
    }

    public int[] unreadIntArray() {
        int[] intArray = new int[this.unreadProfiles.size()];
        for (int i = 0; i < this.unreadProfiles.size(); ++i) {
            intArray[i] = this.unreadProfiles.get(i);
        }
        return intArray;
    }

    public boolean hasPageUnlocked(JournalPage page) {
        return this.pagesUnlocked.contains(page.id()) || page.unlockedByDefault();
    }

    public boolean unlockPage(JournalPage page) {
        if (!this.hasPageUnlocked(page)) {
            this.pagesUnlocked.add(page.id());
            return true;
        }
        return false;
    }

    public void lockAllPages() {
        this.pagesUnlocked.clear();
    }

    public boolean hasFishUnlocked(ItemStack fish) {
        return this.hasFishUnlocked(fish.getItem());
    }

    public boolean hasFishUnlocked(Item fish) {
        int fishId = Item.getId((Item)fish);
        return this.fishUnlocked.contains(fishId);
    }

    public void unlockFish(ItemStack fish) {
        if (!this.hasFishUnlocked(fish)) {
            int fishId = Item.getId((Item)fish.getItem());
            this.fishUnlocked.add(fishId);
            this.markAsUnread(fishId);
        }
    }

    public void lockAllFish() {
        this.pagesCompleted.clear();
        this.pagesUnlocked.clear();
        this.fishUnlocked.clear();
        this.unreadProfiles.clear();
    }

    public boolean hasPageCompleted(JournalPage page) {
        return this.pagesCompleted.contains(page.id());
    }

    public boolean isUnread(JournalLayout.Profile profile) {
        Item fish = TideUtils.getItemFromName(profile.fishItem());
        int fishId = Item.getId((Item)fish);
        return this.unreadProfiles.contains(fishId);
    }

    public void markAsRead(int fishId) {
        Tide.LOG.info("Marked id {} as read", (Object)fishId);
        this.unreadProfiles.remove((Object)fishId);
    }

    public void markAsUnread(int fishId) {
        Tide.LOG.info("Marked id {} as unread", (Object)fishId);
        if (!this.unreadProfiles.contains(fishId)) {
            this.unreadProfiles.add(fishId);
        }
    }
}

