/*
 * Decompiled with CFR 0.152.
 */
package com.li64.tide.data.journal;

import com.li64.tide.Tide;
import com.li64.tide.data.journal.config.JournalRemovalCustomData;
import com.li64.tide.util.TideUtils;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.world.item.ItemStack;

public class JournalLayout {
    private final List<Profile> profiles = new ArrayList<Profile>(20);
    private final List<Page> pages = new ArrayList<Page>(6);

    public JournalLayout() {
        this.addPage("welcome", "journal.title.welcome", "journal.content.welcome", "minecraft:air", true);
        this.addPage("freshwater", "journal.title.freshwater", "journal.content.freshwater", "minecraft:salmon", false);
        this.addPage("saltwater", "journal.title.saltwater", "journal.content.saltwater", "minecraft:tropical_fish", false);
        this.addPage("underground", "journal.title.underground", "journal.content.underground", "minecraft:stone", false);
        this.addPage("depths", "journal.title.depths", "journal.content.depths", "minecraft:deepslate", false);
        this.addPage("biome", "journal.title.biome", "journal.content.biome", "tide:sporestalker", false);
        this.addPage("lava", "journal.title.lava", "journal.content.lava", "tide:fish_bone", false);
        this.addPage("nether", "journal.title.nether", "journal.content.nether", "tide:magma_mackerel", false);
        if (Tide.PLATFORM.isModLoaded("blue_skies")) {
            this.addPage("blueskies", "journal.title.blueskies", "journal.content.blueskies", "blue_skies:municipal_monkfish", false);
        }
        this.addPage("end", "journal.title.end", "journal.content.end", "tide:endstone_perch", false);
        this.addPage("legendary", "journal.title.legendary", "journal.content.legendary", "tide:midas_fish", false);
        this.addProfile("tide:trout", "profile.item.tide.trout", "freshwater", "freshwater", "cold");
        this.addProfile("minecraft:salmon", "profile.item.minecraft.salmon", "freshwater", "freshwater", "cold");
        this.addProfile("tide:bass", "profile.item.tide.bass", "freshwater", "freshwater", "normal");
        this.addProfile("tide:yellow_perch", "profile.item.tide.yellow_perch", "freshwater", "freshwater", "normal");
        this.addProfile("tide:bluegill", "profile.item.tide.bluegill", "freshwater", "freshwater", "normal");
        this.addProfile("tide:mint_carp", "profile.item.tide.mint_carp", "freshwater", "freshwater", "warm");
        this.addProfile("tide:pike", "profile.item.tide.pike", "freshwater", "freshwater", "cold");
        this.addProfile("tide:guppy", "profile.item.tide.guppy", "freshwater", "freshwater", "warm");
        this.addProfile("tide:catfish", "profile.item.tide.catfish", "freshwater", "freshwater", "cold");
        this.addProfile("tide:clayfish", "profile.item.tide.clayfish", "freshwater", "freshwater", "cold");
        this.addProfile("minecraft:cod", "profile.item.minecraft.cod", "saltwater", "saltwater", "cold");
        this.addProfile("minecraft:tropical_fish", "profile.item.minecraft.tropical_fish", "saltwater", "saltwater", "warm");
        this.addProfile("minecraft:pufferfish", "profile.item.minecraft.pufferfish", "saltwater", "saltwater", "warm");
        this.addProfile("tide:tuna", "profile.item.tide.tuna", "saltwater", "saltwater", "normal");
        this.addProfile("tide:ocean_perch", "profile.item.tide.ocean_perch", "saltwater", "saltwater", "cold");
        this.addProfile("tide:mackerel", "profile.item.tide.mackerel", "saltwater", "saltwater", "normal");
        this.addProfile("tide:angelfish", "profile.item.tide.angelfish", "saltwater", "saltwater", "warm");
        this.addProfile("tide:barracuda", "profile.item.tide.barracuda", "saltwater", "saltwater", "normal");
        this.addProfile("tide:sailfish", "profile.item.tide.sailfish", "saltwater", "saltwater", "warm");
        this.addProfile("tide:cave_eel", "profile.item.tide.cave_eel", "underground", "underground", "cold");
        this.addProfile("tide:crystal_shrimp", "profile.item.tide.crystal_shrimp", "underground", "underground", "any");
        this.addProfile("tide:iron_tetra", "profile.item.tide.iron_tetra", "underground", "underground", "any");
        this.addProfile("tide:glowfish", "profile.item.tide.glowfish", "underground", "underground", "cold");
        this.addProfile("tide:anglerfish", "profile.item.tide.anglerfish", "underground", "underground", "cold");
        this.addProfile("tide:cave_crawler", "profile.item.tide.cave_crawler", "underground", "underground", "cold");
        this.addProfile("tide:gilded_minnow", "profile.item.tide.gilded_minnow", "underground", "underground", "any");
        this.addProfile("tide:deep_grouper", "profile.item.tide.deep_grouper", "depths", "depths", "cold");
        this.addProfile("tide:shadow_snapper", "profile.item.tide.shadow_snapper", "depths", "depths", "cold");
        this.addProfile("tide:abyss_angler", "profile.item.tide.abyss_angler", "depths", "depths", "cold");
        this.addProfile("tide:lapis_lanternfish", "profile.item.tide.lapis_lanternfish", "depths", "depths", "any");
        this.addProfile("tide:luminescent_jellyfish", "profile.item.tide.luminescent_jellyfish", "depths", "depths", "cold");
        this.addProfile("tide:crystalline_carp", "profile.item.tide.crystalline_carp", "depths", "depths", "any");
        this.addProfile("tide:bedrock_tetra", "profile.item.tide.bedrock_tetra", "depths", "depths", "any");
        this.addProfile("tide:prarie_pike", "profile.item.tide.prarie_pike", "biome", "plains", "normal");
        this.addProfile("tide:sandskipper", "profile.item.tide.sandskipper", "biome", "desert", "warm");
        this.addProfile("tide:blossom_bass", "profile.item.tide.blossom_bass", "biome", "cherry", "normal");
        this.addProfile("tide:oakfish", "profile.item.tide.oakfish", "biome", "forest", "normal");
        this.addProfile("tide:frostbite_flounder", "profile.item.tide.frostbite_flounder", "biome", "frozen", "cold");
        this.addProfile("tide:mirage_catfish", "profile.item.tide.mirage_catfish", "biome", "badlands", "warm");
        this.addProfile("tide:echofin_snapper", "profile.item.tide.echofin_snapper", "biome", "deep_dark", "cold");
        this.addProfile("tide:sunspike_goby", "profile.item.tide.sunspike_goby", "biome", "savanna", "warm");
        this.addProfile("tide:birch_trout", "profile.item.tide.birch_trout", "biome", "birch", "normal");
        this.addProfile("tide:stonefish", "profile.item.tide.stonefish", "biome", "mountain", "cold");
        this.addProfile("tide:dripstone_darter", "profile.item.tide.dripstone_darter", "biome", "dripstone", "cold");
        this.addProfile("tide:slimefin_snapper", "profile.item.tide.slimefin_snapper", "biome", "swamp", "normal");
        this.addProfile("tide:sporestalker", "profile.item.tide.sporestalker", "biome", "mushroom", "normal");
        this.addProfile("tide:leafback", "profile.item.tide.leafback", "biome", "jungle", "warm");
        this.addProfile("tide:fluttergill", "profile.item.tide.fluttergill", "biome", "lush_caves", "normal");
        this.addProfile("tide:pine_perch", "profile.item.tide.pine_perch", "biome", "taiga", "cold");
        this.addProfile("tide:ember_koi", "profile.item.tide.ember_koi", "lava", "lava", "very_hot");
        this.addProfile("tide:inferno_guppy", "profile.item.tide.inferno_guppy", "lava", "lava", "very_hot");
        this.addProfile("tide:obsidian_pike", "profile.item.tide.obsidian_pike", "lava", "lava", "very_hot");
        this.addProfile("tide:volcano_tuna", "profile.item.tide.volcano_tuna", "lava", "lava", "very_hot");
        this.addProfile("tide:magma_mackerel", "profile.item.tide.magma_mackerel", "nether", "nether", "very_hot");
        this.addProfile("tide:ashen_perch", "profile.item.tide.ashen_perch", "nether", "nether", "very_hot");
        this.addProfile("tide:soulscaler", "profile.item.tide.soulscaler", "nether", "nether", "very_hot");
        this.addProfile("tide:warped_guppy", "profile.item.tide.warped_guppy", "nether", "nether", "very_hot");
        this.addProfile("tide:crimson_fangjaw", "profile.item.tide.crimson_fangjaw", "nether", "nether", "very_hot");
        this.addProfile("tide:witherfin", "profile.item.tide.witherfin", "nether", "nether", "very_hot");
        this.addProfile("tide:blazing_swordfish", "profile.item.tide.blazing_swordfish", "nether", "nether", "very_hot");
        this.addProfile("tide:endstone_perch", "profile.item.tide.endstone_perch", "end", "end", "cold");
        this.addProfile("tide:enderfin", "profile.item.tide.enderfin", "end", "end", "cold");
        this.addProfile("tide:endergazer", "profile.item.tide.endergazer", "end", "end", "cold");
        this.addProfile("tide:purpur_pike", "profile.item.tide.purpur_pike", "end", "end", "cold");
        this.addProfile("tide:chorus_cod", "profile.item.tide.chorus_cod", "end", "end", "cold");
        this.addProfile("tide:elytrout", "profile.item.tide.elytrout", "end", "end", "cold");
        if (Tide.PLATFORM.isModLoaded("blue_skies")) {
            this.addProfile("blue_skies:municipal_monkfish", "", "blueskies", "everbright", "cold");
            this.addProfile("blue_skies:grittle_flatfish", "", "blueskies", "everbright", "cold");
            this.addProfile("blue_skies:charscale_moki", "", "blueskies", "everdawn", "warm");
            this.addProfile("blue_skies:horizofin_tunid", "", "blueskies", "everdawn", "warm");
        }
        if (Tide.PLATFORM.isModLoaded("unusualfishmod")) {
            this.addProfile("unusualfishmod:raw_eyelash", "", "freshwater", "jungle", "warm");
            this.addProfile("unusualfishmod:raw_spindlefish", "", "saltwater", "saltwater", "warm");
            this.addProfile("unusualfishmod:raw_snowflake", "", "saltwater", "saltwater", "cold");
            this.addProfile("unusualfishmod:raw_aero_mono", "", "saltwater", "saltwater", "normal");
            this.addProfile("unusualfishmod:raw_rhino_tetra", "", "freshwater", "freshwater", "normal");
            this.addProfile("unusualfishmod:raw_sailor_barb", "", "freshwater", "swamp", "normal");
            this.addProfile("unusualfishmod:raw_bark_angelfish", "", "freshwater", "swamp", "normal");
            this.addProfile("unusualfishmod:raw_picklefish", "", "saltwater", "saltwater", "warm");
            this.addProfile("unusualfishmod:raw_amber_goby", "", "saltwater", "saltwater", "warm");
            this.addProfile("unusualfishmod:raw_beaked_herring", "", "saltwater", "saltwater", "normal");
            this.addProfile("unusualfishmod:raw_blind_sailfin", "", "freshwater", "overworld", "any");
            this.addProfile("unusualfishmod:raw_circus_fish", "", "saltwater", "saltwater", "warm");
            this.addProfile("unusualfishmod:raw_copperflame_anthias", "", "saltwater", "saltwater", "warm");
            this.addProfile("unusualfishmod:raw_demon_herring", "", "saltwater", "saltwater", "normal");
            this.addProfile("unusualfishmod:raw_drooping_gourami", "", "freshwater", "swamp", "normal");
            this.addProfile("unusualfishmod:raw_duality_damselfish", "", "saltwater", "saltwater", "warm");
            this.addProfile("unusualfishmod:raw_forkfish", "", "saltwater", "saltwater", "warm");
            this.addProfile("unusualfishmod:raw_hatchetfish", "", "freshwater", "overworld", "any");
            this.addProfile("unusualfishmod:raw_sneep_snorp", "", "saltwater", "saltwater", "warm");
            this.addProfile("unusualfishmod:raw_triple_twirl_pleco", "", "freshwater", "freshwater", "normal");
        }
        if (Tide.PLATFORM.isModLoaded("rainbowreef")) {
            this.addProfile("rainbowreef:raw_basslet", "", "saltwater", "saltwater", "warm");
            this.addProfile("rainbowreef:raw_boxfish", "", "saltwater", "saltwater", "warm");
            this.addProfile("rainbowreef:raw_butterflyfish", "", "saltwater", "saltwater", "warm");
            this.addProfile("rainbowreef:raw_clownfish", "", "saltwater", "saltwater", "warm");
            this.addProfile("rainbowreef:raw_dwarf_angelfish", "", "saltwater", "saltwater", "warm");
            this.addProfile("rainbowreef:raw_goby", "", "saltwater", "saltwater", "warm");
            this.addProfile("rainbowreef:raw_hogfish", "", "saltwater", "saltwater", "warm");
            this.addProfile("rainbowreef:raw_parrotfish", "", "saltwater", "saltwater", "warm");
            this.addProfile("rainbowreef:raw_pipefish", "", "freshwater", "swamp", "warm");
            this.addProfile("rainbowreef:raw_seahorse", "", "saltwater", "saltwater", "warm");
            this.addProfile("rainbowreef:raw_tang", "", "saltwater", "saltwater", "warm");
        }
        if (Tide.PLATFORM.isModLoaded("fishofthieves")) {
            this.addProfile("fishofthieves:splashtail", "", "saltwater", "saltwater", "normal");
            this.addProfile("fishofthieves:pondie", "", "freshwater", "freshwater", "normal");
            this.addProfile("fishofthieves:islehopper", "", "saltwater", "saltwater", "normal");
            this.addProfile("fishofthieves:ancientscale", "", "saltwater", "saltwater", "warm");
            this.addProfile("fishofthieves:plentifin", "", "saltwater", "saltwater", "warm");
            this.addProfile("fishofthieves:wildsplash", "", "freshwater", "jungle", "warm");
            this.addProfile("fishofthieves:devilfish", "", "underground", "dripstone", "cold");
            this.addProfile("fishofthieves:battlegill", "", "saltwater", "structures", "raids");
            this.addProfile("fishofthieves:wrecker", "", "saltwater", "shipwrecks", "any");
            this.addProfile("fishofthieves:stormfish", "", "freshwater", "any", "thunderstorms");
        }
        if (Tide.PLATFORM.isModLoaded("netherdepthsupgrade")) {
            this.addProfile("netherdepthsupgrade:lava_pufferfish", "", "nether", "nether", "very_hot");
            this.addProfile("netherdepthsupgrade:obsidianfish", "", "nether", "nether", "very_hot");
            this.addProfile("netherdepthsupgrade:searing_cod", "", "nether", "nether", "very_hot");
            this.addProfile("netherdepthsupgrade:bonefish", "", "nether", "nether", "very_hot");
            this.addProfile("netherdepthsupgrade:wither_bonefish", "", "nether", "nether", "very_hot");
            this.addProfile("netherdepthsupgrade:blazefish", "", "nether", "nether", "very_hot");
            this.addProfile("netherdepthsupgrade:magmacubefish", "", "nether", "nether", "very_hot");
            this.addProfile("netherdepthsupgrade:glowdine", "", "nether", "nether", "very_hot");
            this.addProfile("netherdepthsupgrade:soulsucker", "", "nether", "nether", "very_hot");
        }
        if (Tide.PLATFORM.isModLoaded("aquamirae")) {
            this.addProfile("aquamirae:spinefish", "", "saltwater", "saltwater", "cold");
        }
        if (Tide.PLATFORM.isModLoaded("finsandtails")) {
            this.addProfile("finsandtails:banded_redback_shrimp", "", "saltwater", "saltwater", "warm");
            this.addProfile("finsandtails:wee_wee", "", "freshwater", "freshwater", "normal");
            this.addProfile("finsandtails:pea_wee", "", "freshwater", "jungle", "warm");
            this.addProfile("finsandtails:blu_wee", "", "saltwater", "saltwater", "cold");
            this.addProfile("finsandtails:vibra_wee", "", "freshwater", "jungle", "warm");
            this.addProfile("finsandtails:papa_wee", "", "freshwater", "freshwater", "normal");
            this.addProfile("finsandtails:flatback_sucker", "", "freshwater", "freshwater", "normal");
            this.addProfile("finsandtails:high_finned_blue", "", "saltwater", "saltwater", "normal");
            this.addProfile("finsandtails:night_light_squid", "", "saltwater", "saltwater", "cold");
            this.addProfile("finsandtails:ornate_bugfish", "", "saltwater", "saltwater", "warm");
            this.addProfile("finsandtails:swamp_mucker", "", "freshwater", "swamp", "warm");
            this.addProfile("finsandtails:teal_arrowfish", "", "saltwater", "saltwater", "cold");
            this.addProfile("finsandtails:ruby_spindly_gem_crab", "", "saltwater", "saltwater", "warm");
            this.addProfile("finsandtails:amber_spindly_gem_crab", "", "saltwater", "saltwater", "warm");
            this.addProfile("finsandtails:emerald_spindly_gem_crab", "", "saltwater", "saltwater", "warm");
            this.addProfile("finsandtails:pearl_spindly_gem_crab", "", "saltwater", "saltwater", "warm");
            this.addProfile("finsandtails:sapphire_spindly_gem_crab", "", "saltwater", "saltwater", "warm");
        }
        this.addProfile("tide:midas_fish", "profile.item.tide.midas_fish", "legendary", "any", "lucky");
        this.addProfile("tide:voidseeker", "profile.item.tide.voidseeker", "legendary", "end", "full_new_moon");
        this.addProfile("tide:shooting_starfish", "profile.item.tide.shooting_starfish", "legendary", "saltwater", "night_full_moon");
    }

    private void addPage(String id, String name, String content, String icon, boolean unlocked) {
        this.pages.add(new Page(id, name, content, icon, unlocked));
    }

    private void addProfile(String fish, String desc, String page, String location, String climate) {
        this.profiles.add(new Profile(fish, desc, page, location, climate));
    }

    public List<Page> getPageConfigs() {
        return this.pages;
    }

    public List<Profile> getProfileConfigs() {
        return this.profiles;
    }

    public void addPageConfigs(List<Page> newPages) {
        this.pages.addAll(newPages);
    }

    public void addProfileConfigs(List<Profile> newProfiles) {
        this.profiles.addAll(newProfiles);
    }

    public void removeProfileConfigs(List<JournalRemovalCustomData.JournalRemoval> removals) {
        this.profiles.removeIf(profile -> removals.stream().map(JournalRemovalCustomData.JournalRemoval::item).toList().contains(profile.fishItem));
    }

    public record Page(String id, String name, String content, String icon, boolean unlockedByDefault) {
        public static final Codec<Page> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.STRING.fieldOf("id").forGetter(Page::id), (App)Codec.STRING.fieldOf("name").forGetter(Page::name), (App)Codec.STRING.fieldOf("content").forGetter(Page::content), (App)Codec.STRING.fieldOf("icon").forGetter(Page::icon), (App)Codec.BOOL.fieldOf("unlocked_by_default").forGetter(Page::unlockedByDefault)).apply((Applicative)instance, Page::new));
    }

    public record Profile(String fishItem, String description, String journalPage, String location, String climate) {
        public static final Codec<Profile> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.STRING.fieldOf("item").forGetter(Profile::fishItem), (App)Codec.STRING.fieldOf("description").forGetter(Profile::description), (App)Codec.STRING.fieldOf("page").forGetter(Profile::journalPage), (App)Codec.STRING.fieldOf("location").forGetter(Profile::location), (App)Codec.STRING.fieldOf("climate").forGetter(Profile::climate)).apply((Applicative)instance, Profile::new));

        public ItemStack getFish() {
            return TideUtils.getItemFromName(this.fishItem).getDefaultInstance();
        }
    }
}

