/*
 * Decompiled with CFR 0.152.
 */
package com.li64.tide.client.gui.overlays;

import com.li64.tide.Tide;
import com.mojang.blaze3d.systems.RenderSystem;
import net.minecraft.client.DeltaTracker;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;

public class CastBarOverlay {
    private static final ResourceLocation BAR_EMPTY_TEX = Tide.resource("textures/gui/fishing/cast_bar_empty.png");
    private static final ResourceLocation BAR_FILLED_TEX = Tide.resource("textures/gui/fishing/cast_bar_filled.png");
    private static float rodChargePercent = 0.0f;
    private static float timer = 20.0f;

    public static void render(GuiGraphics graphics, DeltaTracker tracker) {
        if (timer >= 20.0f) {
            return;
        }
        float alpha = -Mth.clamp((float)(((timer += tracker.getRealtimeDeltaTicks()) - 10.0f) / 10.0f), (float)0.0f, (float)1.0f) + 1.0f;
        int texWidth = 24;
        int texHeight = 16;
        int x = (graphics.guiWidth() - texWidth) / 2;
        int y = graphics.guiHeight() / 2 - texHeight - 6;
        int fillWidth = (int)Math.ceil(rodChargePercent * (float)texWidth);
        RenderSystem.enableBlend();
        graphics.setColor(1.0f, 1.0f, 1.0f, alpha);
        graphics.blit(BAR_EMPTY_TEX, x, y, 0.0f, 0.0f, texWidth, texHeight, texWidth, texHeight);
        graphics.blit(BAR_FILLED_TEX, x, y, 0.0f, 0.0f, fillWidth, texHeight, texWidth, texHeight);
        RenderSystem.disableBlend();
        graphics.setColor(1.0f, 1.0f, 1.0f, 1.0f);
    }

    public static void rodChargeTick(float percent) {
        rodChargePercent = percent;
        timer = 0.0f;
    }
}

