/*
 * Decompiled with CFR 0.152.
 */
package com.ldtteam.structurize.network.messages;

import com.ldtteam.common.network.AbstractClientPlayMessage;
import com.ldtteam.common.network.PlayMessageType;
import com.ldtteam.structurize.storage.ClientStructurePackLoader;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.world.entity.player.Player;
import net.neoforged.neoforge.network.handling.IPayloadContext;

public class TransferStructurePackToClient
extends AbstractClientPlayMessage {
    public static final PlayMessageType<?> TYPE = PlayMessageType.forClient((String)"structurize", (String)"transfer_structure_pack_to_client", TransferStructurePackToClient::new);
    private final ByteBuf payload;
    private final String packname;
    private final boolean eol;

    protected TransferStructurePackToClient(RegistryFriendlyByteBuf buf, PlayMessageType<?> type) {
        super(buf, type);
        this.packname = buf.readUtf(Short.MAX_VALUE);
        this.eol = buf.readBoolean();
        int size = buf.readInt();
        this.payload = Unpooled.wrappedBuffer((ByteBuf)buf.readBytes(size));
    }

    public TransferStructurePackToClient(String packName, ByteBuf payload, boolean eol) {
        super(TYPE);
        this.packname = packName;
        this.payload = payload;
        this.eol = eol;
    }

    protected void toBytes(RegistryFriendlyByteBuf buf) {
        buf.writeUtf(this.packname);
        buf.writeBoolean(this.eol);
        int size = this.payload.readableBytes();
        buf.writeInt(size);
        buf.writeBytes(this.payload, size);
        this.payload.resetReaderIndex();
    }

    protected void onExecute(IPayloadContext context, Player player) {
        ClientStructurePackLoader.onStructurePackTransfer(this.packname, this.payload, this.eol);
    }
}

