/*
 * Decompiled with CFR 0.152.
 */
package com.ldtteam.structurize.network.messages;

import com.ldtteam.common.network.AbstractServerPlayMessage;
import com.ldtteam.common.network.PlayMessageType;
import com.ldtteam.structurize.Structurize;
import com.ldtteam.structurize.config.ClientConfiguration;
import com.ldtteam.structurize.storage.rendering.ServerPreviewDistributor;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.neoforged.neoforge.network.handling.IPayloadContext;

public class SyncSettingsToServer
extends AbstractServerPlayMessage {
    public static final PlayMessageType<?> TYPE = PlayMessageType.forServer((String)"structurize", (String)"sync_settings_to_server", SyncSettingsToServer::new);
    private final boolean displayShared;

    protected SyncSettingsToServer(RegistryFriendlyByteBuf buf, PlayMessageType<?> type) {
        super(buf, type);
        this.displayShared = buf.readBoolean();
    }

    public SyncSettingsToServer() {
        super(TYPE);
        this.displayShared = (Boolean)((ClientConfiguration)Structurize.getConfig().getClient()).displayShared.get();
    }

    protected void toBytes(RegistryFriendlyByteBuf buf) {
        buf.writeBoolean(this.displayShared);
    }

    protected void onExecute(IPayloadContext context, ServerPlayer player) {
        ServerPreviewDistributor.register(player, this.displayShared);
    }
}

