/*
 * Decompiled with CFR 0.152.
 */
package com.ldtteam.structurize.network.messages;

import com.ldtteam.common.network.AbstractClientPlayMessage;
import com.ldtteam.common.network.PlayMessageType;
import com.ldtteam.structurize.api.Log;
import com.ldtteam.structurize.storage.ClientStructurePackLoader;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufInputStream;
import io.netty.buffer.ByteBufOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtAccounter;
import net.minecraft.nbt.NbtIo;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.world.entity.player.Player;
import net.neoforged.neoforge.network.handling.IPayloadContext;

public class SaveScanMessage
extends AbstractClientPlayMessage {
    public static final PlayMessageType<?> TYPE = PlayMessageType.forClient((String)"structurize", (String)"save_scan", SaveScanMessage::new);
    private static final String TAG_MILLIS = "millies";
    public static final String TAG_SCHEMATIC = "schematic";
    private final CompoundTag compoundNBT;
    private final String fileName;

    protected SaveScanMessage(RegistryFriendlyByteBuf buf, PlayMessageType<?> type) {
        super(buf, type);
        FriendlyByteBuf buffer = new FriendlyByteBuf((ByteBuf)buf);
        CompoundTag tag = null;
        String name = null;
        try (ByteBufInputStream stream = new ByteBufInputStream((ByteBuf)buffer);){
            CompoundTag wrapperCompound = NbtIo.readCompressed((InputStream)stream, (NbtAccounter)NbtAccounter.unlimitedHeap());
            tag = wrapperCompound.getCompound(TAG_SCHEMATIC);
            name = wrapperCompound.getString(TAG_MILLIS);
        }
        catch (RuntimeException e) {
            Log.getLogger().info("Structure too big to be processed", (Throwable)e);
        }
        catch (IOException e) {
            Log.getLogger().info("Problem at retrieving structure on server.", (Throwable)e);
        }
        this.compoundNBT = tag;
        this.fileName = name;
    }

    public SaveScanMessage(CompoundTag CompoundNBT, String fileName) {
        super(TYPE);
        this.fileName = fileName;
        this.compoundNBT = CompoundNBT;
    }

    protected void toBytes(RegistryFriendlyByteBuf buf) {
        CompoundTag wrapperCompound = new CompoundTag();
        wrapperCompound.putString(TAG_MILLIS, this.fileName);
        wrapperCompound.put(TAG_SCHEMATIC, (Tag)this.compoundNBT);
        FriendlyByteBuf buffer = new FriendlyByteBuf((ByteBuf)buf);
        try (ByteBufOutputStream stream = new ByteBufOutputStream((ByteBuf)buffer);){
            NbtIo.writeCompressed((CompoundTag)wrapperCompound, (OutputStream)stream);
        }
        catch (IOException e) {
            Log.getLogger().info("Problem at retrieving structure on server.", (Throwable)e);
        }
    }

    protected void onExecute(IPayloadContext context, Player player) {
        if (this.compoundNBT != null) {
            ClientStructurePackLoader.handleSaveScanMessage(this.compoundNBT, this.fileName, (HolderLookup.Provider)player.level().registryAccess());
        }
    }
}

