/*
 * Decompiled with CFR 0.152.
 */
package com.ldtteam.structurize.network.messages;

import com.ldtteam.common.network.AbstractServerPlayMessage;
import com.ldtteam.common.network.PlayMessageType;
import com.ldtteam.structurize.api.IScrollableItem;
import com.ldtteam.structurize.api.ISpecialBlockPickItem;
import net.minecraft.core.BlockPos;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.network.handling.IPayloadContext;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ItemMiddleMouseMessage
extends AbstractServerPlayMessage {
    public static final PlayMessageType<?> TYPE = PlayMessageType.forServer((String)"structurize", (String)"item_middle_mouse", ItemMiddleMouseMessage::new);
    @Nullable
    private final BlockPos pos;
    private final double deltaX;
    private final double deltaY;
    private final boolean ctrlKey;

    public ItemMiddleMouseMessage(@Nullable BlockPos pos, boolean ctrlKey) {
        super(TYPE);
        this.pos = pos;
        this.deltaX = 0.0;
        this.deltaY = 0.0;
        this.ctrlKey = ctrlKey;
    }

    public ItemMiddleMouseMessage(double deltaX, double deltaY, boolean ctrlKey) {
        super(TYPE);
        this.pos = null;
        this.deltaX = deltaX;
        this.deltaY = deltaY;
        this.ctrlKey = ctrlKey;
    }

    protected ItemMiddleMouseMessage(@NotNull RegistryFriendlyByteBuf buf, PlayMessageType<?> type) {
        super(buf, type);
        this.pos = buf.readBoolean() ? buf.readBlockPos() : null;
        this.deltaX = buf.readDouble();
        this.deltaY = buf.readDouble();
        this.ctrlKey = buf.readBoolean();
    }

    protected void toBytes(@NotNull RegistryFriendlyByteBuf buf) {
        if (this.pos == null) {
            buf.writeBoolean(false);
        } else {
            buf.writeBoolean(true);
            buf.writeBlockPos(this.pos);
        }
        buf.writeDouble(this.deltaX);
        buf.writeDouble(this.deltaY);
        buf.writeBoolean(this.ctrlKey);
    }

    protected void onExecute(IPayloadContext context, ServerPlayer player) {
        ItemStack current = player.getInventory().getSelected();
        if (this.deltaX == 0.0 && this.deltaY == 0.0) {
            Item item = current.getItem();
            if (item instanceof ISpecialBlockPickItem) {
                ISpecialBlockPickItem clickableItem = (ISpecialBlockPickItem)item;
                clickableItem.onBlockPick((Player)player, current, this.pos, this.ctrlKey);
            }
        } else {
            Item item = current.getItem();
            if (item instanceof IScrollableItem) {
                IScrollableItem scrollableItem = (IScrollableItem)item;
                scrollableItem.onMouseScroll((Player)player, current, this.deltaX, this.deltaY, this.ctrlKey);
            }
        }
    }
}

