/*
 * Decompiled with CFR 0.152.
 */
package com.ldtteam.structurize.client.gui;

import com.google.gson.internal.LazilyParsedNumber;
import com.ldtteam.blockui.Pane;
import com.ldtteam.blockui.PaneBuilders;
import com.ldtteam.blockui.controls.Button;
import com.ldtteam.blockui.controls.ButtonImage;
import com.ldtteam.blockui.controls.Image;
import com.ldtteam.blockui.controls.Text;
import com.ldtteam.blockui.controls.TextField;
import com.ldtteam.blockui.controls.TextFieldVanilla;
import com.ldtteam.blockui.views.BOWindow;
import com.ldtteam.blockui.views.ScrollingList;
import com.ldtteam.structurize.Structurize;
import com.ldtteam.structurize.api.Utils;
import com.ldtteam.structurize.api.constants.Constants;
import com.ldtteam.structurize.blueprints.v1.Blueprint;
import com.ldtteam.structurize.client.BlueprintHandler;
import com.ldtteam.structurize.client.ModKeyMappings;
import com.ldtteam.structurize.client.gui.AbstractWindowSkeleton;
import com.ldtteam.structurize.client.gui.WindowBlockGetterContents;
import com.ldtteam.structurize.config.ClientConfiguration;
import com.ldtteam.structurize.network.messages.BuildToolPlacementMessage;
import com.ldtteam.structurize.storage.ISurvivalBlueprintHandler;
import com.ldtteam.structurize.storage.SurvivalBlueprintHandlers;
import com.ldtteam.structurize.storage.rendering.RenderingCache;
import com.ldtteam.structurize.storage.rendering.types.BlueprintPreviewData;
import com.mojang.blaze3d.platform.InputConstants;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.client.KeyMapping;
import net.minecraft.client.Minecraft;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.ComponentContents;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.contents.TranslatableContents;
import net.minecraft.util.Tuple;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.neoforged.neoforge.common.ModConfigSpec;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractBlueprintManipulationWindow
extends AbstractWindowSkeleton {
    private final String bluePrintId;
    protected ScrollingList settingsList;
    private final ScrollingList placementOptionsList;
    protected int groundstyle;
    private int openTicks = 0;

    public AbstractBlueprintManipulationWindow(@NotNull String resourceId, @Nullable BlockPos pos, int groundstyle, String blueprintId) {
        super(resourceId);
        this.groundstyle = groundstyle;
        this.bluePrintId = blueprintId;
        BlockPos localPos = pos;
        if (localPos == null) {
            localPos = this.mc.player.blockPosition().relative(this.mc.player.getDirection(), 10);
        }
        BlockPos oldPos = RenderingCache.getOrCreateBlueprintPreviewData(blueprintId).getPos();
        if (localPos != null && oldPos == null) {
            RenderingCache.getOrCreateBlueprintPreviewData(blueprintId).setPos(localPos);
            this.adjustToGroundOffset();
        }
        this.registerButton("confirm", this::confirmClicked);
        this.registerButton("cancel", this::cancelClicked);
        this.registerButton("left", this::moveLeftClicked);
        this.registerButton("mirror", this::mirrorClicked);
        this.registerButton("right", this::moveRightClicked);
        this.registerButton("down", this::moveBackClicked);
        this.registerButton("up", this::moveForwardClicked);
        this.registerButton("plus", this::moveUpClicked);
        this.registerButton("minus", this::moveDownClicked);
        this.registerButton("rotateRight", this::rotateRightClicked);
        this.registerButton("rotateLeft", this::rotateLeftClicked);
        this.registerButton("settings", this::settingsClicked);
        this.registerButton("contents", this::openContents);
        this.settingsList = (ScrollingList)this.findPaneOfTypeByID("settinglist", ScrollingList.class);
        this.placementOptionsList = (ScrollingList)this.findPaneOfTypeByID("placement", ScrollingList.class);
        this.updateRotationState();
        ((Text)this.findPaneOfTypeByID("tip", Text.class)).setVisible(oldPos == null);
        this.initSettings();
    }

    public void onOpened() {
        super.onOpened();
        if (RenderingCache.getOrCreateBlueprintPreviewData(this.bluePrintId).getPos() == null) {
            Utils.playErrorSound((Player)Minecraft.getInstance().player);
            Minecraft.getInstance().player.displayClientMessage((Component)Component.translatable((String)"structurize.gui.missing.pos"), false);
            this.cancelClicked();
        }
    }

    protected abstract void cancelClicked();

    protected void confirmClicked() {
        BlueprintPreviewData previewData = RenderingCache.getOrCreateBlueprintPreviewData(this.bluePrintId);
        if (previewData.getBlueprint() != null) {
            if (!Minecraft.getInstance().player.isCreative()) {
                List<ISurvivalBlueprintHandler> handlers = SurvivalBlueprintHandlers.getMatchingHandlers(previewData.getBlueprint(), Minecraft.getInstance().level, (Player)Minecraft.getInstance().player, previewData.getPos(), previewData.getRotationMirror());
                if (handlers.isEmpty()) {
                    Utils.playErrorSound((Player)Minecraft.getInstance().player);
                    if (SurvivalBlueprintHandlers.getHandlers().isEmpty()) {
                        Minecraft.getInstance().player.displayClientMessage((Component)Component.translatable((String)"structurize.gui.no.survival.handler"), false);
                    }
                    return;
                }
                if (handlers.size() == 1) {
                    this.handlePlacement(BuildToolPlacementMessage.HandlerType.Survival, handlers.get(0).getId());
                    return;
                }
            }
            this.updatePlacementOptions();
        }
    }

    protected abstract void handlePlacement(BuildToolPlacementMessage.HandlerType var1, String var2);

    protected void hideOtherGuiForPlacement() {
        this.settingsList.hide();
        this.settingsList.disable();
    }

    protected void hidePlacementGui() {
        this.placementOptionsList.hide();
        this.placementOptionsList.disable();
        this.settingsList.hide();
        this.settingsList.disable();
    }

    public void updatePlacementOptions() {
        BlueprintPreviewData previewData;
        this.placementOptionsList.enable();
        this.placementOptionsList.show();
        this.hideOtherGuiForPlacement();
        final ArrayList<Tuple> categories = new ArrayList<Tuple>();
        if (Minecraft.getInstance().player.isCreative()) {
            categories.add(new Tuple((Object)Component.translatable((String)"structurize.gui.buildtool.complete"), () -> this.handlePlacement(BuildToolPlacementMessage.HandlerType.Complete, "")));
            categories.add(new Tuple((Object)Component.translatable((String)"structurize.gui.buildtool.pretty"), () -> this.handlePlacement(BuildToolPlacementMessage.HandlerType.Pretty, "")));
        }
        if ((previewData = RenderingCache.getOrCreateBlueprintPreviewData(this.bluePrintId)).getBlueprint() != null) {
            for (ISurvivalBlueprintHandler handler : SurvivalBlueprintHandlers.getMatchingHandlers(previewData.getBlueprint(), Minecraft.getInstance().level, (Player)Minecraft.getInstance().player, previewData.getPos(), previewData.getRotationMirror())) {
                categories.add(new Tuple((Object)handler.getDisplayName(), () -> this.handlePlacement(BuildToolPlacementMessage.HandlerType.Survival, handler.getId())));
            }
        }
        this.placementOptionsList.setDataProvider(new ScrollingList.DataProvider(){

            public int getElementCount() {
                return categories.size();
            }

            public void updateElement(int index, Pane rowPane) {
                ButtonImage buttonImage = (ButtonImage)rowPane.findPaneOfTypeByID("type", ButtonImage.class);
                buttonImage.setText((Component)((Tuple)categories.get(index)).getA());
                buttonImage.setTextColor(ChatFormatting.BLACK.getColor().intValue());
                buttonImage.setHandler(button -> ((Runnable)((Tuple)categories.get(index)).getB()).run());
            }
        });
    }

    public void onUpdate() {
        super.onUpdate();
        if (this.openTicks++ >= 200) {
            ((Text)this.findPaneOfTypeByID("tip", Text.class)).setVisible(false);
        }
        this.findPaneByID("contents").setVisible(RenderingCache.getOrCreateBlueprintPreviewData(this.bluePrintId).getBlueprint() != null);
    }

    public boolean onUnhandledKeyTyped(int ch, int key) {
        if (ch != 0 || AbstractBlueprintManipulationWindow.getFocus() != null) {
            return super.onUnhandledKeyTyped(ch, key);
        }
        InputConstants.Key inputKey = InputConstants.Type.KEYSYM.getOrCreate(key);
        if (((KeyMapping)ModKeyMappings.MOVE_FORWARD.get()).isActiveAndMatches(inputKey)) {
            this.moveForwardClicked();
        } else if (((KeyMapping)ModKeyMappings.MOVE_BACK.get()).isActiveAndMatches(inputKey)) {
            this.moveBackClicked();
        } else if (((KeyMapping)ModKeyMappings.MOVE_LEFT.get()).isActiveAndMatches(inputKey)) {
            this.moveLeftClicked();
        } else if (((KeyMapping)ModKeyMappings.MOVE_RIGHT.get()).isActiveAndMatches(inputKey)) {
            this.moveRightClicked();
        } else if (((KeyMapping)ModKeyMappings.MOVE_UP.get()).isActiveAndMatches(inputKey)) {
            this.moveUpClicked();
        } else if (((KeyMapping)ModKeyMappings.MOVE_DOWN.get()).isActiveAndMatches(inputKey)) {
            this.moveDownClicked();
        } else if (((KeyMapping)ModKeyMappings.ROTATE_CW.get()).isActiveAndMatches(inputKey)) {
            this.rotateRightClicked();
        } else if (((KeyMapping)ModKeyMappings.ROTATE_CCW.get()).isActiveAndMatches(inputKey)) {
            this.rotateLeftClicked();
        } else if (((KeyMapping)ModKeyMappings.MIRROR.get()).isActiveAndMatches(inputKey)) {
            this.mirrorClicked();
        } else if (((KeyMapping)ModKeyMappings.PLACE.get()).isActiveAndMatches(inputKey)) {
            this.confirmClicked();
        } else {
            return super.onUnhandledKeyTyped(ch, key);
        }
        return true;
    }

    protected void settingsClicked() {
        if (this.settingsList.isVisible()) {
            this.settingsList.hide();
            this.settingsList.disable();
            return;
        }
        this.settingsList.show();
        this.settingsList.enable();
    }

    protected void initSettings() {
        ArrayList settings = new ArrayList();
        ((ClientConfiguration)Structurize.getConfig().getClient()).collectPreviewRendererSettings(settings::add);
        this.settingsList.setDataProvider(settings::size, (index, rowPane) -> {
            TranslatableContents tkey;
            ComponentContents patt0$temp;
            ModConfigSpec.ConfigValue setting = (ModConfigSpec.ConfigValue)settings.get(index);
            ModConfigSpec.ValueSpec settingSpec = setting.getSpec();
            Text label = (Text)rowPane.findPaneOfTypeByID("label", Text.class);
            String nameTKey = settingSpec.getTranslationKey();
            if (label.getText() != null && (patt0$temp = label.getText().getContents()) instanceof TranslatableContents && (tkey = (TranslatableContents)patt0$temp).getKey().equals(nameTKey)) {
                return;
            }
            label.setText(Component.translatable((String)nameTKey));
            PaneBuilders.singleLineTooltip((MutableComponent)Component.literal((String)settingSpec.getComment()), (Pane)rowPane);
            ButtonImage buttonImage = (ButtonImage)rowPane.findPaneOfTypeByID("switch", ButtonImage.class);
            TextFieldVanilla inputField = (TextFieldVanilla)rowPane.findPaneOfTypeByID("set_input", TextFieldVanilla.class);
            Object patt1$temp = setting.get();
            if (patt1$temp instanceof Boolean) {
                Boolean value = (Boolean)patt1$temp;
                typedSetting = setting;
                inputField.off();
                buttonImage.on();
                buttonImage.setText(Component.translatable((String)(value != false ? "options.on" : "options.off")));
                buttonImage.setHandler(button -> {
                    Boolean newValue = (Boolean)typedSetting.get() == false;
                    Structurize.getConfig().set(typedSetting, (Object)newValue);
                    buttonImage.setText(Component.translatable((String)(newValue != false ? "options.on" : "options.off")));
                });
            } else if (setting.get() instanceof Number) {
                typedSetting = setting;
                buttonImage.off();
                inputField.on();
                inputField.setText(((Number)typedSetting.get()).toString());
                inputField.setFilter(new TextField.Filter(this){

                    public String filter(String s) {
                        return s;
                    }

                    public boolean isAllowedCharacter(char c) {
                        return Character.isDigit(c) || c == '-' || c == '.';
                    }
                });
                inputField.setHandler(a -> {
                    boolean testResult;
                    if (inputField.getText().isBlank()) {
                        return;
                    }
                    LazilyParsedNumber newValue = new LazilyParsedNumber(inputField.getText());
                    try {
                        testResult = settingSpec.test((Object)newValue);
                    }
                    catch (NumberFormatException e) {
                        inputField.setTextColor(-65536);
                        return;
                    }
                    if (testResult) {
                        inputField.setTextColor(-2039584);
                        ModConfigSpec.DoubleValue rendererTransparency = ((ClientConfiguration)Structurize.getConfig().getClient()).rendererTransparency;
                        if (setting == rendererTransparency && (Double)rendererTransparency.get() < 0.0) {
                            BOWindow confirmDialog = new BOWindow(Constants.resLocStruct("gui/dialogconfirmtransparency.xml"));
                            ((ButtonImage)confirmDialog.findPaneOfTypeByID("confirm", ButtonImage.class)).setHandler(arg_0 -> AbstractBlueprintManipulationWindow.lambda$initSettings$4((Number)newValue, rendererTransparency, inputField, confirmDialog, arg_0));
                            ((ButtonImage)confirmDialog.findPaneOfTypeByID("cancel", ButtonImage.class)).setHandler(b -> {
                                inputField.setText(Double.toString((Double)rendererTransparency.get()));
                                confirmDialog.close();
                            });
                            confirmDialog.openAsLayer();
                        } else {
                            Object oldValue = typedSetting.get();
                            if (oldValue instanceof Integer) {
                                Structurize.getConfig().set(typedSetting, (Object)newValue.intValue());
                            } else if (oldValue instanceof Long) {
                                Structurize.getConfig().set(typedSetting, (Object)newValue.longValue());
                            } else if (oldValue instanceof Double) {
                                Structurize.getConfig().set(typedSetting, (Object)newValue.doubleValue());
                            }
                        }
                    } else {
                        inputField.setTextColor(-65536);
                    }
                });
            }
        });
    }

    private void mirrorClicked() {
        RenderingCache.getOrCreateBlueprintPreviewData(this.bluePrintId).mirror();
        this.updateRotationState();
    }

    private void moveUpClicked() {
        RenderingCache.getOrCreateBlueprintPreviewData(this.bluePrintId).move(new BlockPos(0, 1, 0));
    }

    private void moveDownClicked() {
        RenderingCache.getOrCreateBlueprintPreviewData(this.bluePrintId).move(new BlockPos(0, -1, 0));
    }

    private void moveLeftClicked() {
        RenderingCache.getOrCreateBlueprintPreviewData(this.bluePrintId).move(new BlockPos(0, 0, 0).relative(this.mc.player.getDirection().getCounterClockWise()));
    }

    private void moveRightClicked() {
        RenderingCache.getOrCreateBlueprintPreviewData(this.bluePrintId).move(new BlockPos(0, 0, 0).relative(this.mc.player.getDirection().getClockWise()));
    }

    private void moveForwardClicked() {
        RenderingCache.getOrCreateBlueprintPreviewData(this.bluePrintId).move(new BlockPos(0, 0, 0).relative(this.mc.player.getDirection()));
    }

    private void moveBackClicked() {
        RenderingCache.getOrCreateBlueprintPreviewData(this.bluePrintId).move(new BlockPos(0, 0, 0).relative(this.mc.player.getDirection().getOpposite()));
    }

    private void rotateRightClicked() {
        RenderingCache.getOrCreateBlueprintPreviewData(this.bluePrintId).rotate(Rotation.CLOCKWISE_90);
        this.updateRotationState();
    }

    private void rotateLeftClicked() {
        RenderingCache.getOrCreateBlueprintPreviewData(this.bluePrintId).rotate(Rotation.COUNTERCLOCKWISE_90);
        this.updateRotationState();
    }

    private void openContents() {
        BlueprintPreviewData previewData = RenderingCache.getOrCreateBlueprintPreviewData(this.bluePrintId);
        new WindowBlockGetterContents(previewData.getBlueprint(), (Level)Minecraft.getInstance().level, BlueprintHandler.getInstance().getOptionalEntitiesForBlueprint(previewData)).openAsLayer();
    }

    protected void updateRotationState() {
        ((ButtonImage)this.findPaneOfTypeByID("mirror", ButtonImage.class)).setImage(Constants.resLocStruct(String.format("textures/gui/buildtool/%s.png", "mirror" + (RenderingCache.getOrCreateBlueprintPreviewData(this.bluePrintId).getRotationMirror().mirror().equals((Object)Mirror.NONE) ? "" : "_green"))));
        String rotation = switch (RenderingCache.getOrCreateBlueprintPreviewData(this.bluePrintId).getRotationMirror().rotation()) {
            default -> throw new MatchException(null, null);
            case Rotation.CLOCKWISE_90 -> "right_green";
            case Rotation.CLOCKWISE_180 -> "down_green";
            case Rotation.COUNTERCLOCKWISE_90 -> "left_green";
            case Rotation.NONE -> "up_green";
        };
        ((Image)this.findPaneOfTypeByID("rotation", Image.class)).setImage(Constants.resLocStruct(String.format("textures/gui/buildtool/%s.png", rotation)), false);
    }

    protected void adjustToGroundOffset() {
        Blueprint blueprint = RenderingCache.getOrCreateBlueprintPreviewData(this.bluePrintId).getBlueprint();
        if (blueprint != null) {
            RenderingCache.getOrCreateBlueprintPreviewData(this.bluePrintId).setGroundOffset(--groundOffset);
        }
    }

    private static /* synthetic */ void lambda$initSettings$4(Number newValue, ModConfigSpec.DoubleValue rendererTransparency, TextFieldVanilla inputField, BOWindow confirmDialog, Button b) {
        double newVal = newValue.doubleValue();
        Structurize.getConfig().set((ModConfigSpec.ConfigValue)rendererTransparency, (Object)(newVal < 0.0 ? 1.0 : newVal));
        if (newVal < 0.0) {
            inputField.setText("1.0");
        }
        confirmDialog.close();
    }
}

