/*
 * Decompiled with CFR 0.152.
 */
package com.ldtteam.structurize.client;

import com.ldtteam.common.fakelevel.SingleBlockFakeLevel;
import com.ldtteam.structurize.blockentities.BlockEntityTagSubstitution;
import com.ldtteam.structurize.component.CapturedBlock;
import com.ldtteam.structurize.items.ItemTagSubstitution;
import com.mojang.blaze3d.vertex.PoseStack;
import net.minecraft.client.renderer.BlockEntityWithoutLevelRenderer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderDispatcher;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.neoforge.client.NeoForgeRenderTypes;
import net.neoforged.neoforge.client.model.data.ModelData;
import org.jetbrains.annotations.NotNull;

public class TagSubstitutionRenderer
extends BlockEntityWithoutLevelRenderer
implements BlockEntityRenderer<BlockEntityTagSubstitution> {
    private static TagSubstitutionRenderer INSTANCE;
    private final BlockEntityRendererProvider.Context context;
    private SingleBlockFakeLevel renderLevel;

    public static TagSubstitutionRenderer getInstance() {
        return INSTANCE;
    }

    public TagSubstitutionRenderer(@NotNull BlockEntityRendererProvider.Context context) {
        super(context.getBlockEntityRenderDispatcher(), context.getModelSet());
        INSTANCE = this;
        this.context = context;
    }

    public void render(@NotNull BlockEntityTagSubstitution entity, float partialTick, @NotNull PoseStack poseStack, @NotNull MultiBufferSource buffers, int packedLight, int packedOverlay) {
        RenderType renderType = NeoForgeRenderTypes.ITEM_LAYERED_TRANSLUCENT.get();
        this.render(entity.getReplacement(), entity.getTilePos(), partialTick, poseStack, buffers, packedLight, packedOverlay, renderType);
    }

    public void renderByItem(@NotNull ItemStack stack, @NotNull ItemDisplayContext transformType, @NotNull PoseStack poseStack, @NotNull MultiBufferSource buffers, int packedLight, int packedOverlay) {
        RenderType renderType = NeoForgeRenderTypes.ITEM_LAYERED_TRANSLUCENT.get();
        Item item = stack.getItem();
        if (item instanceof ItemTagSubstitution) {
            ItemTagSubstitution anchor = (ItemTagSubstitution)item;
            this.context.getBlockRenderDispatcher().renderSingleBlock(anchor.getBlock().defaultBlockState(), poseStack, buffers, packedLight, packedOverlay, ModelData.EMPTY, renderType);
            this.render(CapturedBlock.readFromItemStack(stack), BlockPos.ZERO, 0.0f, poseStack, buffers, packedLight, packedOverlay, renderType);
        }
    }

    private void render(@NotNull CapturedBlock replacement, @NotNull BlockPos pos, float partialTick, @NotNull PoseStack poseStack, @NotNull MultiBufferSource buffers, int packedLight, int packedOverlay, @NotNull RenderType renderType) {
        if (replacement.blockState().isAir()) {
            return;
        }
        poseStack.pushPose();
        poseStack.scale(0.995f, 0.995f, 0.995f);
        poseStack.translate(0.0025f, 0.0025f, 0.0025f);
        if (replacement.hasBlockEntity()) {
            BlockEntityRenderDispatcher entityDispatcher = this.context.getBlockEntityRenderDispatcher();
            Level realLevel = entityDispatcher.level;
            if (this.renderLevel == null) {
                this.renderLevel = new SingleBlockFakeLevel(realLevel);
            }
            this.renderLevel.withFakeLevelContext(replacement.blockState(), BlockEntity.loadStatic((BlockPos)BlockPos.ZERO, (BlockState)replacement.blockState(), (CompoundTag)replacement.serializedBE().get(), (HolderLookup.Provider)realLevel.registryAccess()), realLevel, fakeLevel -> {
                this.context.getBlockRenderDispatcher().renderSingleBlock(replacement.blockState(), poseStack, buffers, packedLight, packedOverlay, ((SingleBlockFakeLevel.SingleBlockFakeLevelGetter)this.renderLevel.getLevelSource()).blockEntity.getModelData(), renderType);
                entityDispatcher.render(((SingleBlockFakeLevel.SingleBlockFakeLevelGetter)this.renderLevel.getLevelSource()).blockEntity, partialTick, poseStack, buffers);
            });
        } else {
            this.context.getBlockRenderDispatcher().renderSingleBlock(replacement.blockState(), poseStack, buffers, packedLight, packedOverlay, ModelData.EMPTY, renderType);
        }
        poseStack.popPose();
    }
}

