/*
 * Decompiled with CFR 0.152.
 */
package com.faboslav.structurify.common.config.data;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class StructureData {
    public static final boolean IS_DISABLED_DEFAULT_VALUE = false;
    public static final boolean ENABLE_FLATNESS_CHECK_DEFAULT_VALUE = false;
    public static final int FLATNESS_CHECK_THRESHOLD_DEFAULT_VALUE = 10;
    public static final boolean ENABLE_BIOME_CHECK_DEFAULT_VALUE = false;
    public static final BiomeCheckMode BIOME_CHECK_MODE_DEFAULT_VALUE = BiomeCheckMode.BLACKLIST;
    public static final List<String> BIOME_CHECK_BLACKLISTED_BIOMES_DEFAULT_VALUE = List.of("#is_river", "#is_ocean", "#is_beach");
    public static final boolean ALLOW_AIR_BLOCKS_IN_FLATNESS_CHECK_DEFAULT_VALUE = false;
    public static final boolean ALLOW_LIQUID_BLOCKS_IN_FLATNESS_CHECK_DEFAULT_VALUE = false;
    private final List<String> defaultBiomes;
    private final int defaultCheckDistance;
    private boolean isDisabled = false;
    private boolean enableFlatnessCheck = false;
    private int flatnessCheckDistance;
    private int flatnessCheckThreshold = 10;
    private boolean allowAirBlocksInFlatnessCheck = false;
    private boolean allowLiquidBlocksInFlatnessCheck = false;
    private boolean enableBiomeCheck = false;
    private BiomeCheckMode biomeCheckMode = BIOME_CHECK_MODE_DEFAULT_VALUE;
    private int biomeCheckDistance;
    private List<String> biomeCheckBlacklistedBiomes = BIOME_CHECK_BLACKLISTED_BIOMES_DEFAULT_VALUE;
    private List<String> biomes;

    public StructureData(List<String> biomes, int checkDistance) {
        this.defaultBiomes = biomes;
        this.biomes = biomes.stream().toList();
        this.defaultCheckDistance = checkDistance;
        this.flatnessCheckDistance = checkDistance;
        this.biomeCheckDistance = checkDistance;
    }

    public boolean isUsingDefaultValues() {
        ArrayList<String> biomes = new ArrayList<String>(this.biomes);
        ArrayList<String> defaultBiomes = new ArrayList<String>(this.defaultBiomes);
        Collections.sort(biomes);
        Collections.sort(defaultBiomes);
        return !this.isDisabled && !this.enableFlatnessCheck && this.flatnessCheckDistance == this.defaultCheckDistance && this.flatnessCheckThreshold == 10 && !this.enableBiomeCheck && this.biomeCheckMode == BIOME_CHECK_MODE_DEFAULT_VALUE && this.biomeCheckDistance == this.defaultCheckDistance && this.biomeCheckBlacklistedBiomes.equals(BIOME_CHECK_BLACKLISTED_BIOMES_DEFAULT_VALUE) && biomes.equals(defaultBiomes);
    }

    public boolean isDisabled() {
        return this.isDisabled;
    }

    public void setDisabled(boolean isDisabled) {
        this.isDisabled = isDisabled;
    }

    public int getDefaultCheckDistance() {
        return this.defaultCheckDistance;
    }

    public boolean isFlatnessCheckEnabled() {
        return this.enableFlatnessCheck;
    }

    public void setEnableFlatnessCheck(boolean enableFlatnessCheck) {
        this.enableFlatnessCheck = enableFlatnessCheck;
    }

    public boolean areAirBlocksAllowedInFlatnessCheck() {
        return this.allowAirBlocksInFlatnessCheck;
    }

    public void setAllowAirBlocksInFlatnessCheck(boolean allowAirBlocksInFlatnessCheck) {
        this.allowAirBlocksInFlatnessCheck = allowAirBlocksInFlatnessCheck;
    }

    public boolean areLiquidBlocksAllowedInFlatnessCheck() {
        return this.allowLiquidBlocksInFlatnessCheck;
    }

    public void setAllowLiquidBlocksInFlatnessCheck(boolean allowLiquidBlocksInFlatnessCheck) {
        this.allowLiquidBlocksInFlatnessCheck = allowLiquidBlocksInFlatnessCheck;
    }

    public int getFlatnessCheckDistance() {
        return this.flatnessCheckDistance;
    }

    public void setFlatnessCheckDistance(int flatnessCheckDistance) {
        this.flatnessCheckDistance = flatnessCheckDistance;
    }

    public int getFlatnessCheckThreshold() {
        return this.flatnessCheckThreshold;
    }

    public void setFlatnessCheckThreshold(int flatnessCheckThreshold) {
        this.flatnessCheckThreshold = flatnessCheckThreshold;
    }

    public boolean isBiomeCheckEnabled() {
        return this.enableBiomeCheck;
    }

    public void setEnableBiomeCheck(boolean enableBiomeCheck) {
        this.enableBiomeCheck = enableBiomeCheck;
    }

    public BiomeCheckMode getBiomeCheckMode() {
        return this.biomeCheckMode;
    }

    public void setBiomeCheckMode(BiomeCheckMode biomeCheckMode) {
        this.biomeCheckMode = biomeCheckMode;
    }

    public int getBiomeCheckDistance() {
        return this.biomeCheckDistance;
    }

    public void setBiomeCheckDistance(int biomeCheckDistance) {
        this.biomeCheckDistance = biomeCheckDistance;
    }

    public List<String> getBiomeCheckBlacklistedBiomes() {
        return this.biomeCheckBlacklistedBiomes;
    }

    public void setBiomeCheckBlacklistedBiomes(List<String> blacklistedBiomes) {
        this.biomeCheckBlacklistedBiomes = blacklistedBiomes;
    }

    public List<String> getDefaultBiomes() {
        return this.defaultBiomes;
    }

    public List<String> getBiomes() {
        return this.biomes;
    }

    public void setBiomes(List<String> biomes) {
        this.biomes = biomes;
    }

    public static enum BiomeCheckMode {
        STRICT,
        BLACKLIST;

    }
}

