/*
 * Decompiled with CFR 0.152.
 */
package com.faboslav.structurify.common.config.client.gui;

import com.faboslav.structurify.common.Structurify;
import com.faboslav.structurify.common.config.StructurifyConfig;
import com.faboslav.structurify.common.config.client.api.controller.builder.StructureButtonControllerBuilder;
import com.faboslav.structurify.common.config.data.StructureData;
import com.faboslav.structurify.common.config.data.WorldgenDataProvider;
import com.faboslav.structurify.common.events.common.LoadConfigEvent;
import com.faboslav.structurify.common.registry.StructurifyRegistryManagerProvider;
import com.faboslav.structurify.common.util.LanguageUtil;
import dev.isxander.yacl3.api.ConfigCategory;
import dev.isxander.yacl3.api.Option;
import dev.isxander.yacl3.api.OptionDescription;
import dev.isxander.yacl3.api.OptionGroup;
import dev.isxander.yacl3.api.YetAnotherConfigLib;
import dev.isxander.yacl3.api.controller.BooleanControllerBuilder;
import dev.isxander.yacl3.api.controller.IntegerSliderControllerBuilder;
import dev.isxander.yacl3.gui.YACLScreen;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.HolderSet;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.level.biome.Biome;

public final class StructuresConfigScreen {
    private static final List<Option<Boolean>> structureOptions = new ArrayList<Option<Boolean>>();

    public static YACLScreen createConfigGui(StructurifyConfig config, Screen parent) {
        LoadConfigEvent.EVENT.invoke(new LoadConfigEvent());
        YetAnotherConfigLib.Builder yacl = YetAnotherConfigLib.createBuilder().title((Component)Component.translatable((String)"gui.structurify.structures_category.title")).save(config::save);
        StructuresConfigScreen.createStructuresTab(yacl, config);
        return (YACLScreen)yacl.build().generateScreen(parent);
    }

    public static void createStructuresTab(YetAnotherConfigLib.Builder yacl, StructurifyConfig config) {
        ConfigCategory.Builder structureCategoryBuilder = ConfigCategory.createBuilder().name((Component)Component.translatable((String)"gui.structurify.structures_category.title")).tooltip(new Component[]{Component.translatable((String)"gui.structurify.structures_category.description")});
        StructuresConfigScreen.addGeneralSettings(structureCategoryBuilder, config);
        StructuresConfigScreen.addStructures(structureCategoryBuilder, config);
        yacl.category(structureCategoryBuilder.build());
    }

    private static void addGeneralSettings(ConfigCategory.Builder structureCategoryBuilder, StructurifyConfig config) {
        OptionGroup.Builder generalStructuresGroupBuilder = OptionGroup.createBuilder().name((Component)Component.translatable((String)"gui.structurify.structures.global.title")).description(OptionDescription.of((Component[])new Component[]{Component.translatable((String)"gui.structurify.structures.global.description")}));
        Option disableAllStructuresOption = Option.createBuilder().name((Component)Component.translatable((String)"gui.structurify.structures.disable_all_structures.title")).description(OptionDescription.of((Component[])new Component[]{Component.translatable((String)"gui.structurify.structures.disable_all_structures.description")})).binding((Object)false, () -> config.disableAllStructures, disableAllStructures -> {
            config.disableAllStructures = disableAllStructures;
        }).controller(opt -> BooleanControllerBuilder.create((Option)opt).valueFormatter(val -> val != false ? Component.translatable((String)"gui.structurify.label.yes").withStyle(style -> style.withColor(ChatFormatting.RED)) : Component.translatable((String)"gui.structurify.label.no").withStyle(style -> style.withColor(ChatFormatting.GREEN)))).build();
        disableAllStructuresOption.addListener((opt, disableAllStructures) -> {
            for (Option<Boolean> structureOption : structureOptions) {
                structureOption.setAvailable(disableAllStructures == false);
            }
        });
        generalStructuresGroupBuilder.option(disableAllStructuresOption);
        Option.Builder minStructureDistanceFromWorldOptionBuilder = Option.createBuilder().name((Component)Component.translatable((String)"gui.structurify.structures.min_structure_distance_from_world_center.title")).description(OptionDescription.of((Component[])new Component[]{Component.translatable((String)"gui.structurify.structures.min_structure_distance_from_world_center.description")})).binding((Object)0, () -> config.minStructureDistanceFromWorldCenter, minStructureDistanceFromWorldCenter -> {
            config.minStructureDistanceFromWorldCenter = minStructureDistanceFromWorldCenter;
        }).controller(opt -> ((IntegerSliderControllerBuilder)IntegerSliderControllerBuilder.create((Option)opt).range((Number)0, (Number)1024)).step((Number)1));
        generalStructuresGroupBuilder.option(minStructureDistanceFromWorldOptionBuilder.build());
        structureCategoryBuilder.group(generalStructuresGroupBuilder.build());
    }

    private static void addStructures(ConfigCategory.Builder structureCategoryBuilder, StructurifyConfig config) {
        Map<String, StructureData> structures = WorldgenDataProvider.getStructures();
        ArrayList<OptionGroup> optionGroups = new ArrayList<OptionGroup>();
        OptionGroup.Builder currentGroupBuilder = null;
        String currentNamespace = null;
        HolderLookup.RegistryLookup<Biome> biomeRegistry = StructurifyRegistryManagerProvider.getBiomeRegistry();
        for (Map.Entry<String, StructureData> entry : structures.entrySet()) {
            String structureStringId = entry.getKey();
            StructureData structureData = entry.getValue();
            ResourceLocation structureId = Structurify.makeNamespacedId(structureStringId);
            String namespace = structureId.getNamespace();
            if (!namespace.equals(currentNamespace)) {
                if (currentGroupBuilder != null) {
                    optionGroups.add(currentGroupBuilder.build());
                }
                currentGroupBuilder = OptionGroup.createBuilder().name((Component)Component.translatable((String)"gui.structurify.structures.structures_group.title", (Object[])new Object[]{LanguageUtil.translateId(null, namespace).getString()})).description(OptionDescription.of((Component[])new Component[]{Component.translatable((String)"gui.structurify.structures.structures_group.description", (Object[])new Object[]{namespace})}));
                currentNamespace = namespace;
            }
            Option.Builder structureOptionBuilder = Option.createBuilder().name((Component)LanguageUtil.translateId("structure", structureStringId)).binding((Object)true, () -> !config.getStructureData().get(structureStringId).isDisabled(), isEnabled -> config.getStructureData().get(structureStringId).setDisabled(isEnabled == false)).available(!config.disableAllStructures).controller(opt -> ((BooleanControllerBuilder)StructureButtonControllerBuilder.create((Option<Boolean>)opt, structureStringId).valueFormatter(val -> val != false ? Component.translatable((String)"gui.structurify.label.enabled") : Component.translatable((String)"gui.structurify.label.disabled"))).coloured(true));
            OptionDescription.Builder descriptionBuilder = OptionDescription.createBuilder();
            descriptionBuilder.text(new Component[]{Component.translatable((String)"gui.structurify.structures.biomes_description").append((Component)Component.literal((String)"\n"))});
            for (String biome : structureData.getBiomes()) {
                if (biome.contains("#")) {
                    TagKey biomeTagKey;
                    HolderSet.Named biomeTagHolder;
                    if (biomeRegistry == null || (biomeTagHolder = (HolderSet.Named)biomeRegistry.get(biomeTagKey = TagKey.create((ResourceKey)Registries.BIOME, (ResourceLocation)Structurify.makeNamespacedId(biome.replace("#", "")))).orElse(null)) == null) continue;
                    for (Holder biomeHolder : biomeTagHolder.stream().toList()) {
                        descriptionBuilder.text(new Component[]{Component.literal((String)" - ").append((Component)LanguageUtil.translateId("biome", ((ResourceKey)biomeHolder.unwrap().left().get()).location().toLanguageKey()))});
                    }
                    continue;
                }
                descriptionBuilder.text(new Component[]{Component.literal((String)" - ").append((Component)LanguageUtil.translateId("biome", biome))});
            }
            descriptionBuilder.text(new Component[]{Component.literal((String)"\n\n").append((Component)Component.translatable((String)"gui.structurify.structures.warning")).withStyle(style -> style.withColor(ChatFormatting.YELLOW))});
            structureOptionBuilder.description(descriptionBuilder.build());
            Option structureOption = structureOptionBuilder.build();
            structureOptions.add((Option<Boolean>)structureOption);
            currentGroupBuilder.option(structureOption);
        }
        if (currentGroupBuilder != null) {
            optionGroups.add(currentGroupBuilder.build());
        }
        for (OptionGroup structureOptionGroup : optionGroups) {
            structureCategoryBuilder.group(structureOptionGroup);
        }
    }

    private static void addSpecificStructure(ConfigCategory.Builder structureCategoryBuilder, StructurifyConfig config) {
    }
}

