/*
 * Decompiled with CFR 0.152.
 */
package com.faboslav.structurify.common.checks;

import com.faboslav.structurify.common.config.data.StructureData;
import net.minecraft.core.BlockPos;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.LevelHeightAccessor;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.levelgen.RandomState;
import net.minecraft.world.level.levelgen.WorldGenerationContext;
import net.minecraft.world.level.levelgen.heightproviders.HeightProvider;
import net.minecraft.world.level.levelgen.structure.Structure;

public final class JigsawStructureFlatnessCheck {
    public static boolean checkFlatness(StructureData structureData, HeightProvider startHeight, Structure.GenerationContext generationContext) {
        int flatnessCheckDistance = structureData.getFlatnessCheckDistance();
        int flatnessCheckThreshold = structureData.getFlatnessCheckThreshold();
        boolean areAirBlocksAllowed = structureData.areAirBlocksAllowedInFlatnessCheck();
        boolean areLiquidBlocksAllowed = structureData.areLiquidBlocksAllowedInFlatnessCheck();
        if (flatnessCheckDistance == 0 || flatnessCheckThreshold == 0) {
            return true;
        }
        int offsetStep = (int)Math.ceil((float)flatnessCheckDistance / 2.0f);
        int stepsPerAxis = 2 * flatnessCheckDistance / offsetStep + 1;
        int stepAmount = stepsPerAxis * stepsPerAxis;
        int allowedAirBlockSteps = stepAmount / 2;
        int allowedLiquidBlockSteps = stepAmount / 2;
        ChunkGenerator chunkGenerator = generationContext.chunkGenerator();
        LevelHeightAccessor heightAccessor = generationContext.heightAccessor();
        RandomState randomState = generationContext.randomState();
        ChunkPos chunkPos = generationContext.chunkPos();
        int y = startHeight.sample((RandomSource)generationContext.random(), new WorldGenerationContext(chunkGenerator, heightAccessor));
        BlockPos basePos = new BlockPos(chunkPos.getMinBlockX(), y, chunkPos.getMinBlockZ());
        int baseX = basePos.getX();
        int baseZ = basePos.getZ();
        int minHeight = Integer.MAX_VALUE;
        int maxHeight = Integer.MIN_VALUE;
        int airBlockSteps = 0;
        int fluidBlockSteps = 0;
        for (int xOffset = -flatnessCheckDistance; xOffset <= flatnessCheckDistance; xOffset += offsetStep) {
            for (int zOffset = -flatnessCheckDistance; zOffset <= flatnessCheckDistance; zOffset += offsetStep) {
                int x = baseX + xOffset;
                int z = baseZ + zOffset;
                int height = chunkGenerator.getFirstOccupiedHeight(x, z, Heightmap.Types.WORLD_SURFACE_WG, heightAccessor, randomState);
                if (height > maxHeight && (maxHeight = height) - minHeight > flatnessCheckThreshold) {
                    return false;
                }
                if (height < minHeight && maxHeight - (minHeight = height) > flatnessCheckThreshold) {
                    return false;
                }
                if (areAirBlocksAllowed && areLiquidBlocksAllowed) continue;
                BlockState blockState = null;
                if (!areAirBlocksAllowed) {
                    if (blockState == null) {
                        blockState = chunkGenerator.getBaseColumn(x, z, heightAccessor, randomState).getBlock(height);
                    }
                    if (blockState.isAir() && ++airBlockSteps >= allowedAirBlockSteps) {
                        return false;
                    }
                }
                if (areLiquidBlocksAllowed) continue;
                if (blockState == null) {
                    blockState = chunkGenerator.getBaseColumn(x, z, heightAccessor, randomState).getBlock(height);
                }
                if (blockState.getFluidState().isEmpty() || ++fluidBlockSteps < allowedLiquidBlockSteps) continue;
                return false;
            }
        }
        return true;
    }
}

