/*
 * Decompiled with CFR 0.152.
 */
package io.github.mortuusars.sootychimneys.recipe.result;

import com.google.common.base.Preconditions;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Either;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.ItemStack;

public record ChanceResult(ItemStack stack, float chance) {
    public static final Codec<ChanceResult> CHANCE_RESULT_ONLY_CODEC = RecordCodecBuilder.create(instance -> instance.group((App)ItemStack.CODEC.fieldOf("item").forGetter(ChanceResult::stack), (App)Codec.FLOAT.optionalFieldOf("chance", (Object)Float.valueOf(1.0f)).validate(chance -> {
        if (Float.isNaN(chance.floatValue())) {
            return DataResult.error(() -> "'chance' cannot be NaN.");
        }
        if ((double)chance.floatValue() <= 0.0) {
            return DataResult.error(() -> "'chance' '{" + chance + "}' is not valid. Should be larger than 0.");
        }
        return DataResult.success((Object)chance);
    }).forGetter(ChanceResult::chance)).apply((Applicative)instance, ChanceResult::new));
    public static final Codec<ChanceResult> CODEC = Codec.either((Codec)ItemStack.CODEC, CHANCE_RESULT_ONLY_CODEC).xmap(itemStackOrChanceResult -> (ChanceResult)Either.unwrap((Either)itemStackOrChanceResult.mapLeft(ChanceResult::new)), chanceResult -> chanceResult.chance() >= 1.0f ? Either.left((Object)chanceResult.stack()) : Either.right((Object)chanceResult));
    public static final StreamCodec<RegistryFriendlyByteBuf, ChanceResult> STREAM_CODEC = StreamCodec.composite((StreamCodec)ItemStack.STREAM_CODEC, ChanceResult::stack, (StreamCodec)ByteBufCodecs.FLOAT, ChanceResult::chance, ChanceResult::new);

    public ChanceResult(ItemStack stack, float chance) {
        Preconditions.checkArgument((!stack.isEmpty() ? 1 : 0) != 0, (Object)"Item Stack cannot be empty.");
        this.stack = stack;
        Preconditions.checkArgument((!Float.isNaN(chance) ? 1 : 0) != 0, (String)"Chance '{}' is not valid. Should not be NaN.", (Object)Float.valueOf(chance));
        Preconditions.checkArgument(((double)chance > 0.0 ? 1 : 0) != 0, (String)"Chance '{}' is not valid. Should be larger than 0.", (Object)Float.valueOf(chance));
        this.chance = chance;
    }

    public ChanceResult(ItemStack stack) {
        this(stack, 1.0f);
    }

    public ItemStack rollOutput(RandomSource rand) {
        int outputAmount = this.stack.getCount();
        for (int roll = 0; roll < this.stack.getCount(); ++roll) {
            if (!(rand.nextFloat() > this.chance)) continue;
            --outputAmount;
        }
        if (outputAmount == 0) {
            return ItemStack.EMPTY;
        }
        ItemStack out = this.stack.copy();
        out.setCount(outputAmount);
        return out;
    }
}

