/*
 * Decompiled with CFR 0.152.
 */
package io.github.mortuusars.sootychimneys.integration.jei.drawable;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Random;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.drawable.IDrawableAnimated;
import mezz.jei.api.gui.drawable.IDrawableStatic;
import mezz.jei.api.helpers.IGuiHelper;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Tuple;
import net.minecraft.world.phys.Vec2;

public class ChimneySmokeAnimatedDrawable
implements IDrawableAnimated {
    private final Random random = new Random();
    private final List<IDrawable> smokeParticles = new ArrayList<IDrawable>();
    private final List<Tuple<Vec2, Integer>> currentParticles = new ArrayList<Tuple<Vec2, Integer>>();
    private float speed = 1.0f;
    private float intensity = 1.0f;
    private int animationSpeedTicks = 1;
    private long previousGameTime = 0L;
    private int particleAddDelay = 0;

    public ChimneySmokeAnimatedDrawable(IGuiHelper helper) {
        IDrawableStatic particle11 = helper.drawableBuilder(ResourceLocation.withDefaultNamespace((String)"textures/particle/big_smoke_11.png"), 0, 0, 16, 16).setTextureSize(16, 16).build();
        this.smokeParticles.add((IDrawable)particle11);
        IDrawableStatic particle10 = helper.drawableBuilder(ResourceLocation.withDefaultNamespace((String)"textures/particle/big_smoke_10.png"), 0, 0, 16, 16).setTextureSize(16, 16).build();
        this.smokeParticles.add((IDrawable)particle10);
        for (int i = 0; i < 12; ++i) {
            IDrawableStatic particle = helper.drawableBuilder(ResourceLocation.withDefaultNamespace((String)("textures/particle/big_smoke_" + i + ".png")), 0, 0, 16, 16).setTextureSize(16, 16).build();
            this.smokeParticles.add((IDrawable)particle);
        }
    }

    public void draw(GuiGraphics guiGraphics, int xOffset, int yOffset) {
        this.calculateAnimationTick();
        for (Tuple<Vec2, Integer> particle : this.currentParticles) {
            Vec2 pos = (Vec2)particle.getA();
            int index = (Integer)particle.getB();
            IDrawable particleFrame = this.smokeParticles.get(index);
            guiGraphics.pose().translate(0.0f, 0.0f, 100.0f);
            particleFrame.draw(guiGraphics, (int)((float)xOffset + pos.x), (int)((float)yOffset + pos.y));
        }
    }

    private void update() {
        --this.particleAddDelay;
        if (this.particleAddDelay <= 0 && this.currentParticles.size() < (int)(11.0f * this.getIntensity())) {
            this.particleAddDelay = this.random.nextInt(4, (int)(11.0f - 5.0f * this.getIntensity()));
            this.currentParticles.add((Tuple<Vec2, Integer>)new Tuple((Object)new Vec2((float)this.random.nextGaussian(), (float)(-(this.random.nextDouble() * 5.0))), (Object)0));
        }
        ArrayList<Tuple<Vec2, Integer>> particlesToRemove = new ArrayList<Tuple<Vec2, Integer>>();
        for (Tuple<Vec2, Integer> particle : this.currentParticles) {
            particle.setB((Object)((Integer)particle.getB() + 1));
            particle.setA((Object)((Vec2)particle.getA()).add(new Vec2((float)this.random.nextInt(0, 2), -2.0f * this.getSpeed())));
            if ((Integer)particle.getB() < this.smokeParticles.size()) continue;
            particlesToRemove.add(particle);
        }
        particlesToRemove.forEach(particleToRemove -> this.currentParticles.remove(particleToRemove));
    }

    private void calculateAnimationTick() {
        long gameTime = Objects.requireNonNull(Minecraft.getInstance().level).getGameTime();
        if (Math.abs(gameTime - this.previousGameTime) > (long)this.animationSpeedTicks) {
            this.update();
            this.previousGameTime = gameTime;
        }
    }

    public int getWidth() {
        return 16;
    }

    public int getHeight() {
        return 16;
    }

    public int getAnimationSpeedTicks() {
        return this.animationSpeedTicks;
    }

    public void setAnimationSpeedTicks(int ticks) {
        this.animationSpeedTicks = ticks;
    }

    public float getSpeed() {
        return this.speed;
    }

    public void setSpeed(float speed) {
        this.speed = speed;
    }

    public float getIntensity() {
        return this.intensity;
    }

    public void setIntensity(float strength) {
        this.intensity = strength;
    }
}

