/*
 * Decompiled with CFR 0.152.
 */
package io.github.mortuusars.sootychimneys.data.wind;

import io.github.mortuusars.sootychimneys.Config;
import java.util.Objects;
import net.minecraft.util.Mth;

public class WindData {
    private double angleDegrees;
    private float strength;
    private double xCoordinate;
    private double yCoordinate;

    public WindData(double angleDegrees, float strength) {
        this.angleDegrees = angleDegrees;
        this.strength = strength;
    }

    public void set(double angleDegrees, float strength) {
        this.angleDegrees = angleDegrees;
        this.strength = strength;
        double _angleRadians = this.getAngleInRadians();
        this.xCoordinate = Math.cos(_angleRadians);
        this.yCoordinate = Math.sin(_angleRadians);
    }

    public void update(double addDegrees, float addStrength) {
        this.angleDegrees = (this.angleDegrees + addDegrees) % 360.0;
        this.strength = Mth.clamp((float)(this.strength + addStrength), (float)0.0f, (float)1.0f);
        double angleRadians = this.getAngleInRadians();
        this.xCoordinate = Math.cos(angleRadians);
        this.yCoordinate = Math.sin(angleRadians);
    }

    public float getStrength() {
        return this.strength;
    }

    public float getAdjustedStrength() {
        return this.getStrength() * 0.1f * ((Double)Config.Common.WIND_STRENGTH.get()).floatValue();
    }

    public double getAngleInDegrees() {
        return this.angleDegrees;
    }

    public double getAngleInRadians() {
        return this.angleDegrees * (Math.PI / 180);
    }

    public double getXCoordinate() {
        return this.xCoordinate;
    }

    public double getYCoordinate() {
        return this.yCoordinate;
    }

    public String toString() {
        return "Wind{Angle=" + String.format("%.1f", this.angleDegrees) + ", Strength=" + String.format("%.2f", Float.valueOf(this.strength)) + "}";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        WindData wind = (WindData)o;
        return this.angleDegrees == wind.angleDegrees && Float.compare(wind.strength, this.strength) == 0;
    }

    public int hashCode() {
        return Objects.hash(this.angleDegrees, Float.valueOf(this.strength));
    }
}

