/*
 * Decompiled with CFR 0.152.
 */
package com.flanks255.simplylight.blocks;

import com.flanks255.simplylight.blocks.LampBlock;
import com.google.common.base.Suppliers;
import java.util.List;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Equipable;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.block.Block;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

public class BaseBlockItem
extends BlockItem
implements Equipable {
    private final Supplier<ResourceLocation> lazyRes = Suppliers.memoize(() -> BuiltInRegistries.ITEM.getKey((Object)this));
    private final Block block;

    public BaseBlockItem(Block blockIn, Item.Properties builder) {
        super(blockIn, builder);
        this.block = blockIn;
    }

    public ResourceLocation getRegistryName() {
        return this.lazyRes.get();
    }

    @OnlyIn(value=Dist.CLIENT)
    public void appendHoverText(@Nonnull ItemStack stack, @Nonnull Item.TooltipContext context, @Nonnull List<Component> tooltip, @Nonnull TooltipFlag flagIn) {
        super.appendHoverText(stack, context, tooltip, flagIn);
        boolean redstoneFlag = this.block instanceof LampBlock;
        if (Screen.hasShiftDown() && I18n.exists((String)(this.block.getDescriptionId() + ".info"))) {
            tooltip.add((Component)Component.translatable((String)(this.block.getDescriptionId() + ".info")).withStyle(ChatFormatting.GRAY));
            if (I18n.exists((String)(this.block.getDescriptionId() + ".info2"))) {
                if (redstoneFlag) {
                    tooltip.add((Component)Component.translatable((String)(this.block.getDescriptionId() + ".info2"), (Object[])new Object[]{Component.translatable((String)"simplylight.redstone").withStyle(ChatFormatting.DARK_RED)}).withStyle(ChatFormatting.GRAY));
                } else {
                    tooltip.add((Component)Component.translatable((String)(this.block.getDescriptionId() + ".info2")).withStyle(ChatFormatting.GRAY));
                }
            }
        } else {
            tooltip.add((Component)Component.translatable((String)"simplylight.shift", (Object[])new Object[]{Component.translatable((String)"simplylight.key.shift").withStyle(new ChatFormatting[]{ChatFormatting.GOLD, ChatFormatting.ITALIC})}).withStyle(ChatFormatting.GRAY));
        }
    }

    public EquipmentSlot getEquipmentSlot() {
        return EquipmentSlot.HEAD;
    }
}

