/*
 * Decompiled with CFR 0.152.
 */
package xyz.przemyk.simpleplanes.upgrades.supplycrate;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.SimpleMenuProvider;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.neoforge.capabilities.BaseCapability;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.client.model.data.ModelData;
import net.neoforged.neoforge.items.IItemHandler;
import net.neoforged.neoforge.items.ItemStackHandler;
import xyz.przemyk.simpleplanes.container.StorageContainer;
import xyz.przemyk.simpleplanes.entities.ParachuteEntity;
import xyz.przemyk.simpleplanes.entities.PlaneEntity;
import xyz.przemyk.simpleplanes.setup.SimplePlanesEntities;
import xyz.przemyk.simpleplanes.setup.SimplePlanesItems;
import xyz.przemyk.simpleplanes.setup.SimplePlanesUpgrades;
import xyz.przemyk.simpleplanes.upgrades.LargeUpgrade;

public class SupplyCrateUpgrade
extends LargeUpgrade {
    public final ItemStackHandler itemStackHandler = new ItemStackHandler(27);

    public SupplyCrateUpgrade(PlaneEntity planeEntity) {
        super(SimplePlanesUpgrades.SUPPLY_CRATE.get(), planeEntity);
    }

    @Override
    public Tag serializeNBT() {
        return this.itemStackHandler.serializeNBT((HolderLookup.Provider)this.planeEntity.registryAccess());
    }

    @Override
    public void deserializeNBT(CompoundTag nbt) {
        this.itemStackHandler.deserializeNBT((HolderLookup.Provider)this.planeEntity.registryAccess(), nbt);
    }

    @Override
    public void render(PoseStack matrixStack, MultiBufferSource buffer, int packedLight, float partialTicks) {
        matrixStack.pushPose();
        EntityType entityType = this.planeEntity.getType();
        if (entityType == SimplePlanesEntities.HELICOPTER.get()) {
            matrixStack.translate(0.0, -0.1, -1.28);
        } else {
            matrixStack.translate(0.0, 0.0, 0.1);
        }
        matrixStack.mulPose(Axis.ZP.rotationDegrees(180.0f));
        matrixStack.translate(-0.4, -1.0, 0.3);
        matrixStack.scale(0.82f, 0.82f, 0.82f);
        BlockState state = Blocks.BARREL.defaultBlockState();
        Minecraft.getInstance().getBlockRenderer().renderSingleBlock(state, matrixStack, buffer, packedLight, OverlayTexture.NO_OVERLAY, ModelData.EMPTY, null);
        matrixStack.scale(0.875f, 0.875f, 0.875f);
        matrixStack.translate(0.0625f, 0.25f, 0.0625f);
        state = Blocks.WHITE_WOOL.defaultBlockState();
        Minecraft.getInstance().getBlockRenderer().renderSingleBlock(state, matrixStack, buffer, packedLight, OverlayTexture.NO_OVERLAY, ModelData.EMPTY, null);
        matrixStack.popPose();
    }

    @Override
    public void writePacket(RegistryFriendlyByteBuf buffer) {
    }

    @Override
    public void readPacket(RegistryFriendlyByteBuf buffer) {
    }

    @Override
    public void onRemoved() {
        for (int i = 0; i < this.itemStackHandler.getSlots(); ++i) {
            ItemStack itemStack = this.itemStackHandler.getStackInSlot(i);
            if (itemStack.isEmpty()) continue;
            this.planeEntity.spawnAtLocation(itemStack);
        }
    }

    @Override
    public ItemStack getItemStack() {
        return SimplePlanesItems.SUPPLY_CRATE.get().getDefaultInstance();
    }

    @Override
    public boolean hasStorage() {
        return true;
    }

    @Override
    public <T> T getCap(BaseCapability<T, ?> cap) {
        if (cap == Capabilities.ItemHandler.ENTITY) {
            return (T)this.itemStackHandler;
        }
        return super.getCap(cap);
    }

    @Override
    public void openStorageGui(Player player, int cycleableContainerID) {
        player.openMenu((MenuProvider)new SimpleMenuProvider((id, playerInventory, playerIn) -> new StorageContainer(id, playerInventory, (IItemHandler)this.itemStackHandler, BuiltInRegistries.ITEM.getKey((Object)Items.BARREL).toString(), cycleableContainerID), (Component)Component.translatable((String)"simpleplanes:supply_crate")), buffer -> {
            buffer.writeUtf(BuiltInRegistries.ITEM.getKey((Object)Items.BARREL).toString());
            buffer.writeByte(cycleableContainerID);
        });
    }

    @Override
    public boolean canBeDroppedAsPayload() {
        return true;
    }

    @Override
    public void dropAsPayload() {
        ParachuteEntity parachuteEntity = new ParachuteEntity(this.planeEntity.level(), this.itemStackHandler);
        parachuteEntity.setPos(this.planeEntity.position());
        parachuteEntity.setDeltaMovement(this.planeEntity.getDeltaMovement());
        this.planeEntity.level().addFreshEntity((Entity)parachuteEntity);
        this.remove();
    }
}

