/*
 * Decompiled with CFR 0.152.
 */
package xyz.przemyk.simpleplanes.upgrades.heal;

import com.mojang.blaze3d.vertex.PoseStack;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.world.item.ItemStack;
import xyz.przemyk.simpleplanes.entities.PlaneEntity;
import xyz.przemyk.simpleplanes.setup.SimplePlanesItems;
import xyz.przemyk.simpleplanes.setup.SimplePlanesUpgrades;
import xyz.przemyk.simpleplanes.upgrades.Upgrade;

public class HealingUpgrade
extends Upgrade {
    private int cooldown = 10;

    public HealingUpgrade(PlaneEntity planeEntity) {
        super(SimplePlanesUpgrades.HEALING.get(), planeEntity);
    }

    @Override
    public Tag serializeNBT() {
        CompoundTag compoundNBT = new CompoundTag();
        compoundNBT.putInt("cooldown", this.cooldown);
        return compoundNBT;
    }

    @Override
    public void deserializeNBT(CompoundTag compoundNBT) {
        this.cooldown = compoundNBT.getInt("cooldown");
    }

    @Override
    public void tick() {
        if (this.cooldown > 0) {
            --this.cooldown;
        } else {
            this.remove();
        }
    }

    @Override
    public void render(PoseStack matrixStack, MultiBufferSource buffer, int packedLight, float partialTicks) {
    }

    @Override
    public void onApply(ItemStack itemStack) {
        int m;
        int health = this.planeEntity.getHealth();
        if (health < (m = this.planeEntity.getMaxHealth() * 2)) {
            int heal = this.planeEntity.getOnGround() ? 2 : 1;
            this.planeEntity.setHealth(Math.min(health + heal, m));
        }
        this.planeEntity.goldenHeartsTimeout = 0;
    }

    @Override
    public void writePacket(RegistryFriendlyByteBuf buffer) {
    }

    @Override
    public void readPacket(RegistryFriendlyByteBuf buffer) {
    }

    @Override
    public ItemStack getItemStack() {
        return SimplePlanesItems.HEALING.get().getDefaultInstance();
    }
}

