/*
 * Decompiled with CFR 0.152.
 */
package xyz.przemyk.simpleplanes.upgrades.floating;

import com.mojang.blaze3d.vertex.PoseStack;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.core.BlockPos;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.tags.FluidTags;
import net.minecraft.util.Mth;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.phys.Vec3;
import xyz.przemyk.simpleplanes.client.render.PlaneRenderer;
import xyz.przemyk.simpleplanes.client.render.UpgradesModels;
import xyz.przemyk.simpleplanes.entities.PlaneEntity;
import xyz.przemyk.simpleplanes.setup.SimplePlanesEntities;
import xyz.przemyk.simpleplanes.setup.SimplePlanesItems;
import xyz.przemyk.simpleplanes.setup.SimplePlanesUpgrades;
import xyz.przemyk.simpleplanes.upgrades.Upgrade;

public class FloatingUpgrade
extends Upgrade {
    public FloatingUpgrade(PlaneEntity planeEntity) {
        super(SimplePlanesUpgrades.FLOATY_BEDDING.get(), planeEntity);
    }

    @Override
    public void tick() {
        if (this.planeEntity.getHealth() > 0 && this.planeEntity.isOnWater()) {
            Vec3 motion = this.planeEntity.getDeltaMovement();
            double f = 1.0;
            double y = Mth.lerp((double)1.0, (double)motion.y, (double)Math.max(motion.y, 0.0));
            this.planeEntity.setDeltaMovement(motion.x * f, y, motion.z * f);
            if (this.planeEntity.level().getBlockState(new BlockPos((int)this.planeEntity.getX(), (int)(this.planeEntity.getY() + 0.5), (int)this.planeEntity.getZ())).getFluidState().is(FluidTags.WATER)) {
                this.planeEntity.setDeltaMovement(this.planeEntity.getDeltaMovement().add(0.0, 0.04, 0.0));
            }
        }
    }

    @Override
    public void render(PoseStack matrixStack, MultiBufferSource buffer, int packedLight, float partialTicks) {
        super.render(matrixStack, buffer, packedLight, partialTicks);
        if (this.planeEntity.getType() == SimplePlanesEntities.CARGO_PLANE.get()) {
            UpgradesModels.WOODEN_CARGO_FLOATING.renderToBuffer(matrixStack, buffer.getBuffer(UpgradesModels.SEATS.renderType(PlaneRenderer.getMaterialTexture(this.planeEntity))), packedLight, OverlayTexture.NO_OVERLAY);
        }
    }

    @Override
    public void writePacket(RegistryFriendlyByteBuf buffer) {
    }

    @Override
    public void readPacket(RegistryFriendlyByteBuf buffer) {
    }

    @Override
    public ItemStack getItemStack() {
        return SimplePlanesItems.FLOATY_BEDDING.get().getDefaultInstance();
    }
}

