/*
 * Decompiled with CFR 0.152.
 */
package xyz.przemyk.simpleplanes.entities;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BarrelBlockEntity;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.items.ItemStackHandler;
import xyz.przemyk.simpleplanes.setup.SimplePlanesEntities;
import xyz.przemyk.simpleplanes.setup.SimplePlanesItems;

public class ParachuteEntity
extends Entity {
    public static final EntityDataAccessor<Boolean> HAS_STORAGE_CRATE = SynchedEntityData.defineId(ParachuteEntity.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    public static final double MOTION_DECAY = 0.9;
    private ItemStackHandler itemStackHandler;

    public ParachuteEntity(Level level) {
        super(SimplePlanesEntities.PARACHUTE.get(), level);
    }

    public ParachuteEntity(EntityType<?> entityType, Level level) {
        super(entityType, level);
    }

    public ParachuteEntity(Level level, ItemStackHandler itemStackHandler) {
        super(SimplePlanesEntities.PARACHUTE.get(), level);
        this.entityData.set(HAS_STORAGE_CRATE, (Object)true);
        this.itemStackHandler = itemStackHandler;
    }

    public boolean hasStorageCrate() {
        return (Boolean)this.entityData.get(HAS_STORAGE_CRATE);
    }

    public LivingEntity getControllingPassenger() {
        Entity entity = this.getFirstPassenger();
        if (entity instanceof LivingEntity) {
            LivingEntity entity2 = (LivingEntity)entity;
            return entity2;
        }
        return null;
    }

    public void tick() {
        LivingEntity passenger = this.getControllingPassenger();
        if (passenger == null && !this.hasStorageCrate() || !this.level().getBlockState(new BlockPos((int)this.getX(), (int)this.getY() - 1, (int)this.getZ())).canBeReplaced()) {
            this.kill();
            this.spawnAtLocation((ItemLike)SimplePlanesItems.PARACHUTE_ITEM.get());
            if (this.hasStorageCrate() && !this.level().isClientSide) {
                int i;
                BlockPos.MutableBlockPos mutableBlockPos = new BlockPos.MutableBlockPos(this.getBlockX(), this.getBlockY(), this.getBlockZ());
                for (i = 0; i < 50; ++i) {
                    BlockState blockState = this.level().getBlockState((BlockPos)mutableBlockPos);
                    if (blockState.canBeReplaced()) {
                        this.level().setBlock((BlockPos)mutableBlockPos, Blocks.BARREL.defaultBlockState(), 3);
                        BlockEntity blockEntity = this.level().getBlockEntity((BlockPos)mutableBlockPos);
                        if (blockEntity instanceof BarrelBlockEntity) {
                            BarrelBlockEntity barrelBlockEntity = (BarrelBlockEntity)blockEntity;
                            for (int s = 0; s < 27; ++s) {
                                ItemStack itemStack;
                                try {
                                    itemStack = this.itemStackHandler.getStackInSlot(s);
                                }
                                catch (Exception e) {
                                    itemStack = ItemStack.EMPTY;
                                }
                                if (itemStack.isEmpty()) continue;
                                barrelBlockEntity.setItem(s, itemStack);
                            }
                        }
                        return;
                    }
                    mutableBlockPos.move(Direction.UP);
                }
                for (i = 0; i < this.itemStackHandler.getSlots(); ++i) {
                    ItemStack itemStack = this.itemStackHandler.getStackInSlot(i);
                    if (itemStack.isEmpty()) continue;
                    this.spawnAtLocation(itemStack);
                }
            }
        } else {
            super.tick();
            this.fallDistance = 0.0f;
            float moveStrafing = 0.0f;
            float moveForward = 0.0f;
            if (passenger instanceof LivingEntity) {
                LivingEntity livingEntity = passenger;
                float angle = (float)((double)livingEntity.getYRot() * Math.PI / 180.0);
                float sin = Mth.sin((float)angle);
                float cos = Mth.cos((float)angle);
                moveStrafing = (cos * livingEntity.xxa - sin * livingEntity.zza) / 50.0f;
                moveForward = (sin * livingEntity.xxa + cos * livingEntity.zza) / 50.0f;
            }
            Vec3 motion = this.getDeltaMovement();
            this.setDeltaMovement(motion.x * 0.9 + (double)moveStrafing, Math.max(-0.1, motion.y - 0.005), motion.z * 0.9 + (double)moveForward);
            this.move(MoverType.SELF, this.getDeltaMovement());
        }
    }

    protected void defineSynchedData(SynchedEntityData.Builder pBuilder) {
        pBuilder.define(HAS_STORAGE_CRATE, (Object)false);
    }

    protected void readAdditionalSaveData(CompoundTag compoundTag) {
        this.entityData.set(HAS_STORAGE_CRATE, (Object)compoundTag.getBoolean("has_storage_crate"));
        if (this.hasStorageCrate()) {
            this.itemStackHandler = new ItemStackHandler();
            this.itemStackHandler.deserializeNBT((HolderLookup.Provider)this.level().registryAccess(), compoundTag.getCompound("items"));
        }
    }

    protected void addAdditionalSaveData(CompoundTag compoundTag) {
        compoundTag.putBoolean("has_storage_crate", this.hasStorageCrate());
        if (this.hasStorageCrate()) {
            compoundTag.put("items", (Tag)this.itemStackHandler.serializeNBT((HolderLookup.Provider)this.level().registryAccess()));
        }
    }
}

