/*
 * Decompiled with CFR 0.152.
 */
package xyz.przemyk.simpleplanes.entities;

import java.util.List;
import java.util.Optional;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntitySelector;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.npc.Villager;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.neoforged.neoforge.network.PacketDistributor;
import org.joml.Vector3f;
import xyz.przemyk.simpleplanes.datapack.PayloadEntry;
import xyz.przemyk.simpleplanes.datapack.PlanePayloadReloadListener;
import xyz.przemyk.simpleplanes.entities.PlaneEntity;
import xyz.przemyk.simpleplanes.network.DropPayloadPacket;
import xyz.przemyk.simpleplanes.setup.SimplePlanesConfig;
import xyz.przemyk.simpleplanes.setup.SimplePlanesItems;
import xyz.przemyk.simpleplanes.setup.SimplePlanesRegistries;
import xyz.przemyk.simpleplanes.setup.SimplePlanesUpgrades;
import xyz.przemyk.simpleplanes.upgrades.LargeUpgrade;
import xyz.przemyk.simpleplanes.upgrades.Upgrade;
import xyz.przemyk.simpleplanes.upgrades.UpgradeType;
import xyz.przemyk.simpleplanes.upgrades.payload.PayloadUpgrade;

public class LargePlaneEntity
extends PlaneEntity {
    public boolean hasLargeUpgrade = false;

    public LargePlaneEntity(EntityType<? extends LargePlaneEntity> entityType, Level level) {
        super(entityType, level);
    }

    @Override
    public void tick() {
        super.tick();
        List list = this.level().getEntities((Entity)this, this.getBoundingBox().inflate((double)0.2f, (double)-0.01f, (double)0.2f), EntitySelector.pushableBy((Entity)this));
        for (Entity entity : list) {
            if (this.level().isClientSide || this.getControllingPassenger() instanceof Player || entity.hasPassenger((Entity)this) || entity.isPassenger() || !(entity instanceof LivingEntity) || entity instanceof Player) continue;
            entity.startRiding((Entity)this);
        }
    }

    @Override
    public boolean tryToAddUpgrade(Player playerEntity, ItemStack itemStack) {
        if (super.tryToAddUpgrade(playerEntity, itemStack)) {
            return true;
        }
        if (!this.hasLargeUpgrade && this.getPassengers().size() < 2) {
            Optional<UpgradeType> upgradeTypeOptional = SimplePlanesUpgrades.getLargeUpgradeFromItem(itemStack.getItem());
            if (upgradeTypeOptional.map(upgradeType -> {
                if (this.canAddUpgrade((UpgradeType)upgradeType)) {
                    Upgrade upgrade = upgradeType.instanceSupplier.apply(this);
                    this.addUpgrade(playerEntity, itemStack, upgrade);
                    return true;
                }
                return false;
            }).orElse(false).booleanValue()) {
                return true;
            }
            PayloadEntry payloadEntry = PlanePayloadReloadListener.payloadEntries.get(itemStack.getItem());
            if (payloadEntry != null) {
                this.addUpgrade(playerEntity, itemStack, new PayloadUpgrade(this, payloadEntry));
                return true;
            }
        }
        return false;
    }

    @Override
    protected float getGroundPitch() {
        return 0.0f;
    }

    @Override
    public int getFuelCost() {
        return (Integer)SimplePlanesConfig.LARGE_PLANE_FUEL_COST.get();
    }

    @Override
    protected boolean canAddPassenger(Entity passenger) {
        List passengers = this.getPassengers();
        if (passenger.getVehicle() == this || passenger instanceof PlaneEntity) {
            return false;
        }
        if (!this.upgrades.containsKey(SimplePlanesRegistries.UPGRADE_TYPE.getKey((Object)SimplePlanesUpgrades.SEATS.get()))) {
            return passengers.size() <= 1 && (passengers.isEmpty() || !this.hasLargeUpgrade);
        }
        return this.hasLargeUpgrade ? passengers.size() < 3 : passengers.size() < 4;
    }

    @Override
    public void positionRider(Entity passenger, Entity.MoveFunction moveFunction) {
        this.positionRiderGeneric(passenger);
        int index = this.getPassengers().indexOf(passenger);
        if (index == 0) {
            Vector3f pos = this.transformPos(new Vector3f(0.0f, this.getPassengersRidingOffset() + this.getEntityYOffset(passenger), 1.0f));
            moveFunction.accept(passenger, this.getX() + (double)pos.x(), this.getY() + (double)pos.y(), this.getZ() + (double)pos.z());
        } else {
            if (this.hasLargeUpgrade) {
                ++index;
            }
            switch (index) {
                case 1: {
                    Vector3f pos = this.transformPos(new Vector3f(0.0f, this.getPassengersRidingOffset() + this.getEntityYOffset(passenger), 0.0f));
                    moveFunction.accept(passenger, this.getX() + (double)pos.x(), this.getY() + (double)pos.y(), this.getZ() + (double)pos.z());
                    break;
                }
                case 2: {
                    Vector3f pos = this.transformPos(new Vector3f(0.0f, this.getPassengersRidingOffset() + this.getEntityYOffset(passenger), -1.0f));
                    moveFunction.accept(passenger, this.getX() + (double)pos.x(), this.getY() + (double)pos.y(), this.getZ() + (double)pos.z());
                    break;
                }
                case 3: {
                    Vector3f pos = this.transformPos(new Vector3f(0.0f, this.getPassengersRidingOffset() + this.getEntityYOffset(passenger), -1.8f));
                    moveFunction.accept(passenger, this.getX() + (double)pos.x(), this.getY() + (double)pos.y(), this.getZ() + (double)pos.z());
                }
            }
        }
    }

    public float getEntityYOffset(Entity passenger) {
        if (passenger instanceof Villager) {
            return ((Villager)passenger).isBaby() ? -0.1f : -0.3f;
        }
        return -0.4f;
    }

    @Override
    public double getCameraDistanceMultiplayer() {
        return (Double)SimplePlanesConfig.LARGE_PLANE_CAMERA_DISTANCE_MULTIPLIER.get();
    }

    @Override
    protected Item getItem() {
        return SimplePlanesItems.LARGE_PLANE_ITEM.get();
    }

    public boolean hasStorageUpgrade() {
        if (this.hasLargeUpgrade) {
            for (Upgrade upgrade : this.upgrades.values()) {
                if (!(upgrade instanceof LargeUpgrade)) continue;
                LargeUpgrade largeUpgrade = (LargeUpgrade)upgrade;
                return largeUpgrade.hasStorage();
            }
        }
        return false;
    }

    @Override
    public void dropPayload() {
        for (Upgrade upgrade : this.upgrades.values()) {
            if (!upgrade.canBeDroppedAsPayload()) continue;
            upgrade.dropAsPayload();
            if (upgrade.removed) {
                this.upgrades.remove(SimplePlanesRegistries.UPGRADE_TYPE.getKey((Object)upgrade.getType()));
            }
            if (!this.level().isClientSide) break;
            PacketDistributor.sendToServer((CustomPacketPayload)new DropPayloadPacket(), (CustomPacketPayload[])new CustomPacketPayload[0]);
            break;
        }
    }

    @Override
    protected float getRotationSpeedMultiplier() {
        return 0.5f;
    }
}

