/*
 * Decompiled with CFR 0.152.
 */
package xyz.przemyk.simpleplanes.entities;

import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import org.joml.Quaternionf;
import org.joml.Vector3f;
import xyz.przemyk.simpleplanes.entities.LargePlaneEntity;
import xyz.przemyk.simpleplanes.entities.PlaneEntity;
import xyz.przemyk.simpleplanes.misc.MathUtil;
import xyz.przemyk.simpleplanes.setup.SimplePlanesConfig;
import xyz.przemyk.simpleplanes.setup.SimplePlanesItems;
import xyz.przemyk.simpleplanes.setup.SimplePlanesUpgrades;
import xyz.przemyk.simpleplanes.upgrades.UpgradeType;

public class HelicopterEntity
extends LargePlaneEntity {
    public static final EntityDataAccessor<Boolean> MOVE_UP = SynchedEntityData.defineId(HelicopterEntity.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);

    public HelicopterEntity(EntityType<? extends HelicopterEntity> entityTypeIn, Level worldIn) {
        super((EntityType<? extends LargePlaneEntity>)entityTypeIn, worldIn);
    }

    @Override
    protected void defineSynchedData(SynchedEntityData.Builder pBuilder) {
        super.defineSynchedData(pBuilder);
        pBuilder.define(MOVE_UP, (Object)false);
    }

    @Override
    protected PlaneEntity.TempMotionVars getMotionVars() {
        PlaneEntity.TempMotionVars motionTempMotionVars = super.getMotionVars();
        motionTempMotionVars.passiveEnginePush = 0.028f;
        motionTempMotionVars.push = 0.05f;
        motionTempMotionVars.dragQuad *= 10.0;
        motionTempMotionVars.dragMul *= 2.0;
        return motionTempMotionVars;
    }

    @Override
    protected Vector3f getTickPush(PlaneEntity.TempMotionVars tempMotionVars) {
        if (tempMotionVars.moveForward < 0.0f && this.isPowered() && !((Boolean)this.entityData.get(MOVE_UP)).booleanValue()) {
            tempMotionVars.push *= 0.2f;
        }
        if (tempMotionVars.moveForward > 0.0f && this.isPowered() && !((Boolean)this.entityData.get(MOVE_UP)).booleanValue()) {
            tempMotionVars.push *= 1.5f;
        }
        if (this.isPowered() && ((Boolean)this.entityData.get(MOVE_UP)).booleanValue() && tempMotionVars.moveForward >= 0.0f) {
            tempMotionVars.push += 0.01f * (float)this.getThrottle();
        }
        return this.transformPos(new Vector3f(0.0f, tempMotionVars.push, 0.0f));
    }

    @Override
    protected void tickPitch(PlaneEntity.TempMotionVars tempMotionVars) {
        if (this.getHealth() <= 0) {
            this.setXRot(-2.0f);
            this.setDeltaMovement(this.getDeltaMovement().add(0.0, -0.04, 0.0));
        } else if (!this.onGround()) {
            if (tempMotionVars.moveForward > 0.0f) {
                this.setXRot(Math.max(this.getXRot() - 1.0f, -20.0f));
            } else if (tempMotionVars.moveForward < 0.0f && ((Boolean)this.entityData.get(MOVE_UP)).booleanValue()) {
                this.setXRot(Math.min(this.getXRot() + 1.0f, 20.0f));
            } else {
                this.setXRot(MathUtil.lerpAngle(0.2f, this.getXRot(), 0.0f));
                double drag = 0.999;
                this.setDeltaMovement(this.getDeltaMovement().multiply(drag, 1.0, drag));
            }
        }
    }

    @Override
    protected void tickYaw() {
    }

    @Override
    protected boolean tickOnGround(PlaneEntity.TempMotionVars tempMotionVars) {
        float push = tempMotionVars.push;
        super.tickOnGround(tempMotionVars);
        tempMotionVars.push = (Boolean)this.entityData.get(MOVE_UP) != false ? push : 0.0f;
        return false;
    }

    @Override
    public int getFuelCost() {
        return (Integer)SimplePlanesConfig.HELICOPTER_FUEL_COST.get();
    }

    @Override
    protected Quaternionf tickRotateMotion(PlaneEntity.TempMotionVars tempMotionVars, Quaternionf q, Vec3 motion) {
        return q;
    }

    @Override
    protected void tickRoll(PlaneEntity.TempMotionVars tempMotionVars) {
        if (this.getHealth() <= 0) {
            this.setYRot(this.getYRot() + (this.getId() % 2 == 0 ? 16.0f : -16.0f));
            return;
        }
        if (!((Boolean)this.entityData.get(MOVE_UP)).booleanValue()) {
            this.setYRot(this.getYRot() - tempMotionVars.moveStrafing * 2.0f);
            this.rotationRoll = tempMotionVars.moveForward > 0.0f && !this.onGround() ? MathUtil.lerpAngle(0.1f, this.rotationRoll, tempMotionVars.moveStrafing * 30.0f) : MathUtil.lerpAngle(0.1f, this.rotationRoll, 0.0f);
        } else if (!this.onGround()) {
            this.rotationRoll = MathUtil.lerpAngle(0.1f, this.rotationRoll, tempMotionVars.moveStrafing * 50.0f);
        }
    }

    @Override
    public void positionRider(Entity passenger, Entity.MoveFunction moveFunction) {
        this.positionRiderGeneric(passenger);
        int index = this.getPassengers().indexOf(passenger);
        if (index == 0) {
            Vector3f pos = this.transformPos(new Vector3f(0.0f, this.getPassengersRidingOffset() + this.getEntityYOffset(passenger), 0.5f));
            moveFunction.accept(passenger, this.getX() + (double)pos.x(), this.getY() + (double)pos.y(), this.getZ() + (double)pos.z());
        } else {
            if (this.hasLargeUpgrade) {
                ++index;
            }
            switch (index) {
                case 1: {
                    Vector3f pos = this.transformPos(new Vector3f(0.0f, this.getPassengersRidingOffset() + this.getEntityYOffset(passenger), -0.5f));
                    moveFunction.accept(passenger, this.getX() + (double)pos.x(), this.getY() + (double)pos.y(), this.getZ() + (double)pos.z());
                    break;
                }
                case 2: {
                    Vector3f pos = this.transformPos(new Vector3f(-1.0f, this.getPassengersRidingOffset() + this.getEntityYOffset(passenger), 0.0f));
                    moveFunction.accept(passenger, this.getX() + (double)pos.x(), this.getY() + (double)pos.y(), this.getZ() + (double)pos.z());
                    break;
                }
                case 3: {
                    Vector3f pos = this.transformPos(new Vector3f(1.0f, this.getPassengersRidingOffset() + this.getEntityYOffset(passenger), 0.0f));
                    moveFunction.accept(passenger, this.getX() + (double)pos.x(), this.getY() + (double)pos.y(), this.getZ() + (double)pos.z());
                }
            }
        }
    }

    @Override
    protected Item getItem() {
        return SimplePlanesItems.HELICOPTER_ITEM.get();
    }

    @Override
    public boolean canAddUpgrade(UpgradeType upgradeType) {
        if (upgradeType == SimplePlanesUpgrades.SOLAR_PANEL.get()) {
            return false;
        }
        return super.canAddUpgrade(upgradeType);
    }

    @Override
    public double getCameraDistanceMultiplayer() {
        return (Double)SimplePlanesConfig.HELI_CAMERA_DISTANCE_MULTIPLIER.get();
    }

    public void setMoveUp(boolean up) {
        this.entityData.set(MOVE_UP, (Object)up);
    }
}

